# 画面設計書 29-仕訳帳一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける仕訳帳一覧画面の設計仕様を定義します。仕訳帳（Journal）は会計取引を記録する帳簿であり、現金出納帳、銀行帳、売上帳、仕入帳、クレジットカード帳などの種類があります。

### 本画面の処理概要

**業務上の目的・背景**：
仕訳帳は会計システムの基盤となる構成要素であり、すべての取引は適切な仕訳帳に記録されます。この一覧画面では、システムに登録されている仕訳帳を管理し、新規作成・編集・削除などの操作を行います。仕訳帳の種類によって記録される取引の性質が異なり、売上・仕入・銀行取引・現金取引などを適切に分類して管理します。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「仕訳帳」を選択

**主要な操作・処理内容**：
1. 仕訳帳の一覧表示・検索・ソート
2. 新規仕訳帳の作成画面への遷移
3. 既存仕訳帳の詳細・編集画面への遷移
4. 仕訳帳の削除
5. 一括削除

**画面遷移**：
- 遷移元：会計モジュールのメニュー
- 遷移先：仕訳帳作成画面、仕訳帳詳細画面、仕訳帳編集画面

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-010 | 仕訳帳管理 | 主機能 | 仕訳帳のCRUD操作 |
| FN-ACC-001 | 請求書管理 | 参照機能 | 請求書との連携 |
| FN-ACC-002 | 支払管理 | 参照機能 | 支払処理との連携 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/accounts/journals`

## 画面構成

- ヘッダーアクション
  - 作成ボタン（CreateAction）- アイコン付き
- テーブル
  - 名称（name）カラム
  - 種類（type）カラム
  - コード（code）カラム
  - 通貨（currency.name）カラム
  - 作成者（createdBy.name）カラム
  - 行アクション（表示・編集・削除）
- ツールバーアクション
  - 一括アクショングループ（削除）

## 入出力項目

本画面は一覧表示のため、直接の入力項目はありません。

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 |
|--------|--------|----------|----------|--------|------|
| 名称 | name | string | テキスト | ○ | ○ |
| 種類 | type | enum | ラベル（変換表示） | ○ | ○ |
| コード | code | string | テキスト | ○ | ○ |
| 通貨 | currency.name | string | テキスト | ○ | ○ |
| 作成者 | createdBy.name | string | テキスト | ○ | ○ |

### 仕訳帳種類（JournalType）

| 値 | 表示名 |
|----|--------|
| sale | 売上 |
| purchase | 仕入 |
| cash | 現金 |
| bank | 銀行 |
| credit_card | クレジットカード |
| general | 一般 |

## イベント仕様

### 1-作成ボタン押下

1. 仕訳帳作成画面（CreateJournal）へ遷移

### 2-行クリック/表示ボタン押下

1. 仕訳帳詳細画面（ViewJournal）へ遷移

### 3-編集ボタン押下（行アクション）

1. 仕訳帳編集画面（EditJournal）へ遷移

### 4-削除ボタン押下（行アクション）

1. 確認ダイアログ表示
2. ユーザーが確認した場合、レコードを削除
3. 成功通知を表示
4. テーブルを更新

### 5-一括削除

1. 選択された複数レコードを一括削除
2. 成功通知を表示
3. テーブルを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | journals | SELECT | 仕訳帳一覧の取得 |
| 削除ボタン押下 | journals | DELETE | 仕訳帳レコードの削除 |
| 一括削除 | journals | DELETE | 複数仕訳帳の削除 |

### テーブル別更新項目詳細

#### journals（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | - | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | type | - | JournalType enum |
| SELECT | code | - | 表示用 |
| SELECT | currency_id | - | リレーション用 |
| SELECT | creator_id | - | リレーション用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| journal.table.actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| journal.table.actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |
| journal.table.bulk-actions.delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| journal.table.bulk-actions.delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 権限不足 | 操作権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| 参照整合性エラー | 取引が紐づいている仕訳帳を削除 | エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装されている
- モデルはJournal
- ナビゲーションアイコンは`heroicon-o-book-open`
- shouldRegisterNavigationがfalseのため、直接のナビゲーション登録はされていない
- 仕訳帳種類（type）はJournalType enumで定義され、表示時に日本語ラベルに変換
- 仕訳帳に取引が紐づいている場合、削除時に参照整合性エラーが発生する可能性あり
