# 画面設計書 290-UTMソース一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおけるUTMソース一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、応募者の流入元を追跡するためのUTMソース（応募経路）のマスタを一覧管理するための画面です。求人サイト、SNS、自社サイトなど、応募者がどこから来たかを分類するためのマスタです。

**業務上の目的・背景**：採用活動において、どの媒体・チャネルから応募があったかを把握することは、採用マーケティングの効果測定に重要です。本画面により、人事担当者はUTMソース（応募経路）マスタを管理し、応募者情報の流入元分析を可能にします。

**画面へのアクセス方法**：採用モジュールの設定メニューから「UTMソース」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. UTMソース一覧の表示
2. 新規UTMソースの作成（モーダル）
3. 既存UTMソースの編集（モーダル）
4. UTMソースの削除

**画面遷移**：
- 本画面から遷移可能：なし（モーダル内で完結）
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | UTMソース管理 | 主機能 | UTMソースデータのCRUD操作 |
| - | 応募者管理 | 関連機能 | 応募者の流入元設定で使用 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/utm-source`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：UTMソース一覧テーブル
- フィルターエリア：名前
- 行アクション：表示（モーダル）、編集（モーダル）、削除
- 一括操作エリア：一括削除

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | ソース名 | name | string | ○ | 255 | テキスト | - | required,max:255 | プレースホルダーあり |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | ID | id | integer | UTMソースID | デフォルト非表示 |
| 2 | ソース名 | name | string | UTMソースの名称 | 検索・ソート可能 |
| 3 | 作成者 | createdBy.name | string | 作成者名 | デフォルト非表示 |
| 4 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 5 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、UTMソース作成モーダルが表示されます。名前を入力して保存するとUTMソースが登録されます。

### 2-表示アクション

行の表示アクションを選択すると、UTMソースの詳細情報がモーダルで表示されます。

### 3-編集アクション

行の編集アクションを選択すると、UTMソース編集モーダルが表示されます。内容を変更して保存するとUTMソースが更新されます。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | supports_utm_sources | INSERT | UTMソースレコードの新規作成 |
| 編集 | supports_utm_sources | UPDATE | UTMソースレコードの更新 |
| 削除アクション | supports_utm_sources | DELETE | 選択したUTMソースレコードを削除 |
| 一括削除 | supports_utm_sources | DELETE | 選択した複数のUTMソースレコードを削除 |

### テーブル別更新項目詳細

#### supports_utm_sources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | UTMソース名 |
| UPDATE | name | 入力値 | UTMソース名 |
| DELETE | - | 主キー（id）で特定 | 削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | UTMソースが作成されました | 作成成功時 |
| MSG-002 | 成功 | UTMソースが更新されました | 更新成功時 |
| MSG-003 | 成功 | UTMソースが削除されました | 削除成功時 |
| MSG-004 | 成功 | UTMソースが一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 処理中断 | システムエラーが発生しました |
| 削除失敗（使用中） | エラー通知表示 | このUTMソースは使用中のため削除できません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- 作成・編集・表示はモーダルで行われ、画面遷移は発生しません
- ベースモデルとしてWebkul\Support\Models\UTMSourceを継承しています
- URLスラグは `/utm-source` として設定されています
- ナビゲーショングループは「Source Tracking」に属します
