# 画面設計書 291-UTMメディア一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用管理モジュールにおける「UTMメディア一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

UTMメディア一覧画面は、採用活動のトラッキングに使用するUTMメディア情報を一覧表示・管理するための画面です。

**業務上の目的・背景**：採用活動において、候補者がどのメディア（SNS、メール、検索広告など）を通じて求人情報にアクセスしたかを追跡することは、採用マーケティングの効果測定に不可欠です。この画面により、UTMメディアマスタを効率的に管理し、採用チャネルの分析精度を向上させることができます。

**画面へのアクセス方法**：サイドメニューから「採用」>「設定」>「UTMメディア」を選択することでアクセスできます。採用管理クラスターの設定カテゴリに配置されています。

**主要な操作・処理内容**：
1. UTMメディア一覧の表示・検索・ソート
2. 新規UTMメディアの作成（モーダルダイアログ）
3. 既存UTMメディアの詳細表示
4. UTMメディア情報の編集
5. UTMメディアの削除（単一・一括）

**画面遷移**：この画面は採用モジュールの設定画面群の一部として機能します。一覧からモーダルダイアログで詳細表示・編集を行い、画面遷移は最小限に抑えられています。

**権限による表示制御**：採用管理の設定権限を持つユーザーのみがアクセス可能です。削除操作は追加の権限が必要な場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-016 | UTMメディア管理 | 主機能 | UTMメディアのCRUD操作 |
| FN-REC-001 | 応募者一覧 | 遷移先機能 | 応募者のUTMメディア参照 |

## 画面種別

一覧（SimpleResource - モーダルベースのCRUD）

## URL/ルーティング

`/recruitments/configurations/utm-mediums`

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン（+アイコン付き）
- フィルターエリア
  - クエリビルダーベースのフィルター機能
- テーブルエリア
  - ID列（デフォルト非表示）
  - 名称列
  - 作成者列（デフォルト非表示）
  - 作成日時列（デフォルト非表示）
  - 更新日時列（デフォルト非表示）
  - アクション列（表示・編集・削除）
- バルクアクションエリア
  - 一括削除

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 備考 |
|--------|--------|-----------|----------|------|--------|------|
| 名称 | name | 入力 | string | Yes | 255 | UTMメディア名 |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|----------|--------|------|--------|
| ID | id | integer | 数値 | Yes | Yes | 非表示（デフォルト） |
| 名称 | name | string | テキスト | Yes | Yes | 表示 |
| 作成者 | createdBy.name | string | テキスト | Yes | No | 非表示（デフォルト） |
| 作成日時 | created_at | datetime | 日時 | Yes | No | 非表示（デフォルト） |
| 更新日時 | updated_at | datetime | 日時 | Yes | No | 非表示（デフォルト） |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタンをクリックすると、UTMメディア作成用のモーダルダイアログが表示されます。名称を入力して保存すると、新しいUTMメディアが作成され、成功通知が表示されます。

### 2-表示アクション

テーブル行のアクションメニューから「表示」を選択すると、該当UTMメディアの詳細情報がモーダルダイアログで表示されます。

### 3-編集アクション

テーブル行のアクションメニューから「編集」を選択すると、編集用モーダルダイアログが表示されます。変更を保存すると成功通知が表示されます。

### 4-削除アクション

テーブル行のアクションメニューから「削除」を選択すると、確認後に該当レコードが削除されます。成功通知が表示されます。

### 5-一括削除

複数のレコードを選択した状態でバルクアクションの「削除」を実行すると、選択されたすべてのレコードが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | support_utm_mediums | INSERT | UTMメディアレコードの作成 |
| 編集保存 | support_utm_mediums | UPDATE | UTMメディアレコードの更新 |
| 削除 | support_utm_mediums | DELETE | UTMメディアレコードの削除 |
| 一括削除 | support_utm_mediums | DELETE | 複数UTMメディアレコードの削除 |

### テーブル別更新項目詳細

#### support_utm_mediums

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | creator_id | Auth::id() | 作成者ID |
| INSERT | created_at | now() | 作成日時 |
| UPDATE | name | フォーム入力値 | 変更された場合 |
| UPDATE | updated_at | now() | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | UTMメディアが正常に作成されました | 新規作成成功時 |
| MSG-002 | 成功 | UTMメディアが正常に更新されました | 編集保存成功時 |
| MSG-003 | 成功 | UTMメディアが正常に削除されました | 削除成功時 |
| MSG-004 | 成功 | 選択されたUTMメディアが正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 関連データが存在する場合の削除 | 削除処理中断 | 関連データ存在エラーメッセージ表示 |

## 備考

- UTMメディアはWebkul\Support\Models\UTMMediumを継承したRecruitmentモジュール固有のモデルを使用
- Filament ResourceのSimpleResourceパターンを採用し、モーダルベースでCRUD操作を実現
- ナビゲーショングループは「採用」カテゴリの設定セクションに配置
