# 画面設計書 292-辞退理由一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用管理モジュールにおける「辞退理由一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

辞退理由一覧画面は、採用プロセスにおいて応募者を辞退（不採用）とする際に使用する理由のマスタデータを管理するための画面です。

**業務上の目的・背景**：採用活動において、応募者に対して辞退通知を送信する際、標準化された理由とテンプレートを使用することで、一貫したコミュニケーションを実現し、採用プロセスの品質を維持できます。また、辞退理由の統計を取ることで、採用活動の改善ポイントを特定できます。

**画面へのアクセス方法**：サイドメニューから「採用」>「設定」>「辞退理由」を選択することでアクセスできます。採用管理クラスターの設定カテゴリに配置されています。

**主要な操作・処理内容**：
1. 辞退理由一覧の表示・検索・ソート
2. 新規辞退理由の作成（モーダルダイアログ）
3. 既存辞退理由の詳細表示
4. 辞退理由情報の編集
5. 辞退理由の削除（単一・一括）
6. 辞退理由の有効/無効切り替え
7. ドラッグ＆ドロップによる並び順変更

**画面遷移**：この画面は採用モジュールの設定画面群の一部として機能します。一覧からモーダルダイアログで詳細表示・編集を行い、画面遷移は最小限に抑えられています。

**権限による表示制御**：採用管理の設定権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-017 | 辞退理由管理 | 主機能 | 辞退理由のCRUD操作 |
| FN-REC-001 | 応募者管理 | 遷移先機能 | 応募者の辞退処理で理由を使用 |

## 画面種別

一覧（SimpleResource - モーダルベースのCRUD）

## URL/ルーティング

`/recruitments/configurations/refuse-reasons`

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン（+アイコン付き）
- フィルターエリア
  - クエリビルダーベースのフィルター機能
- テーブルエリア
  - 並び順ハンドル（ドラッグ可能）
  - ID列（デフォルト非表示）
  - 名称列（検索可能）
  - テンプレート列
  - 有効状態列（トグルスイッチ）
  - 作成者列（デフォルト非表示）
  - 作成日時列（デフォルト非表示）
  - 更新日時列（デフォルト非表示）
  - アクション列（表示・編集・削除）
- バルクアクションエリア
  - 一括削除

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 備考 |
|--------|--------|-----------|----------|------|--------|------|
| 名称 | name | 入力 | string | Yes | 255 | 辞退理由名 |
| テンプレート | template | 入力 | string | No | - | 辞退通知テンプレート |
| 有効 | is_active | 入力 | boolean | No | - | 有効/無効フラグ |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|----------|--------|------|--------|
| ID | id | integer | 数値 | Yes | Yes | 非表示（デフォルト） |
| 名称 | name | string | テキスト | Yes | Yes | 表示 |
| テンプレート | template | string | テキスト | No | No | 表示 |
| 有効 | is_active | boolean | トグルスイッチ | No | No | 表示 |
| 作成者 | createdBy.name | string | テキスト | Yes | No | 非表示（デフォルト） |
| 作成日時 | created_at | datetime | 日時 | Yes | No | 非表示（デフォルト） |
| 更新日時 | updated_at | datetime | 日時 | Yes | No | 非表示（デフォルト） |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタンをクリックすると、辞退理由作成用のモーダルダイアログが表示されます。名称、テンプレート、有効状態を入力して保存すると、新しい辞退理由が作成され、成功通知が表示されます。

### 2-表示アクション

テーブル行のアクションメニューから「表示」を選択すると、該当辞退理由の詳細情報がモーダルダイアログで表示されます。

### 3-編集アクション

テーブル行のアクションメニューから「編集」を選択すると、編集用モーダルダイアログが表示されます。変更を保存すると成功通知が表示されます。

### 4-削除アクション

テーブル行のアクションメニューから「削除」を選択すると、確認後に該当レコードが削除されます。成功通知が表示されます。

### 5-一括削除

複数のレコードを選択した状態でバルクアクションの「削除」を実行すると、選択されたすべてのレコードが削除されます。

### 6-有効/無効トグル変更

テーブル内の有効状態トグルスイッチを切り替えると、該当レコードの有効状態が即座に更新されます。

### 7-並び順変更（ドラッグ＆ドロップ）

テーブル行の左側にあるハンドルをドラッグすることで、辞退理由の表示順序を変更できます。順序はsortカラムに保存されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | recruitments_refuse_reasons | INSERT | 辞退理由レコードの作成 |
| 編集保存 | recruitments_refuse_reasons | UPDATE | 辞退理由レコードの更新 |
| 削除 | recruitments_refuse_reasons | DELETE | 辞退理由レコードの削除 |
| 一括削除 | recruitments_refuse_reasons | DELETE | 複数辞退理由レコードの削除 |
| 有効/無効切替 | recruitments_refuse_reasons | UPDATE | is_activeカラムの更新 |
| 並び順変更 | recruitments_refuse_reasons | UPDATE | sortカラムの更新 |

### テーブル別更新項目詳細

#### recruitments_refuse_reasons

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | template | フォーム入力値 | 任意 |
| INSERT | is_active | フォーム入力値（デフォルトtrue） | |
| INSERT | sort | 自動採番（最大値+1） | SortableTrait |
| INSERT | creator_id | Auth::id() | 作成者ID |
| INSERT | created_at | now() | 作成日時 |
| UPDATE | name | フォーム入力値 | |
| UPDATE | template | フォーム入力値 | |
| UPDATE | is_active | トグル値 | |
| UPDATE | sort | ドラッグ後の位置 | |
| UPDATE | updated_at | now() | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 辞退理由が正常に作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 辞退理由が正常に更新されました | 編集保存成功時 |
| MSG-003 | 成功 | 辞退理由が正常に削除されました | 削除成功時 |
| MSG-004 | 成功 | 選択された辞退理由が正常に削除されました | 一括削除成功時 |
| MSG-005 | 成功 | 有効状態が更新されました | トグル変更成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 関連データが存在する場合の削除 | 削除処理中断 | 関連データ存在エラーメッセージ表示 |

## 備考

- Spatie\EloquentSortable\SortableTraitを使用して並び順管理を実装
- sortカラムでソート順を管理し、ドラッグ＆ドロップで順序変更可能
- テンプレートフィールドはRichEditorまたはTextareaで実装
- is_activeフィールドでテーブル内から直接有効/無効を切り替え可能
