# 画面設計書 293-見積書一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「見積書一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

見積書一覧画面は、顧客向けの見積書を一覧表示し、検索・フィルタリング・管理するための中核的な画面です。

**業務上の目的・背景**：営業活動において、見積書の作成・管理・追跡は受注プロセスの起点となる重要な業務です。この画面により、営業担当者は顧客への見積書を効率的に管理し、商談の進捗状況を把握できます。見積書は承認後、受注（Sales Order）に変換されます。

**画面へのアクセス方法**：サイドメニューから「販売」>「注文」>「見積書」を選択することでアクセスできます。Ordersクラスターのメイン画面として配置されています。

**主要な操作・処理内容**：
1. 見積書一覧の表示・検索・ソート
2. 多様な条件でのフィルタリング
3. 見積書のグループ化表示
4. 新規見積書の作成
5. 見積書の詳細表示・編集・削除
6. 見積書の一括削除・復元・完全削除
7. 金額サマリの表示

**画面遷移**：この画面から見積書作成画面、見積書詳細画面、見積書編集画面へ遷移できます。また、見積書を受注に変換することで受注一覧画面と連携します。

**権限による表示制御**：販売管理の権限を持つユーザーがアクセス可能です。削除は見積書ステータスがSALEの場合は非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-001 | 見積書管理 | 主機能 | 見積書のCRUD操作 |
| FN-SAL-002 | 受注管理 | 遷移先機能 | 見積書から受注への変換 |
| FN-SAL-003 | 請求書管理 | 関連機能 | 見積書から請求書生成 |
| FN-SAL-004 | 配送管理 | 関連機能 | 見積書から配送指示生成 |

## 画面種別

一覧

## URL/ルーティング

`/sales/orders/quotations`

## 画面構成

- ヘッダーエリア
  - 画面タイトル「見積書」
  - 新規作成ボタン
- フィルターエリア
  - QueryBuilderベースのフィルター（2カラム）
  - 担当者、UTMソース、会社、顧客、仕訳帳、請求先住所、配送先住所、財務ポジション、支払条件、通貨、作成日、更新日でフィルタリング
- グルーピングオプション
  - メディア、ソース、チーム、担当者、通貨、会社、顧客、見積日、納期でグループ化
- テーブルエリア
  - カラム並び替え可能
  - カラムマネージャー（2カラム）
  - 見積書番号列（検索・ソート可能）
  - ステータス列（バッジ表示）
  - 請求ステータス列（バッジ表示）
  - 作成日列
  - 税抜金額列（合計表示）
  - 税額列（合計表示）
  - 合計金額列（合計表示）
  - 納期列
  - 予定日列
  - 顧客列（検索・ソート可能）
  - 担当者列
  - 営業チーム列
  - 顧客参照番号列（バッジ表示）
- アクション列
  - 表示・編集・削除・完全削除・復元
- バルクアクションエリア
  - 一括削除・一括完全削除・一括復元

## 入出力項目

この画面は主に表示専用のため、フィルター条件が主な入力項目となります。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 備考 |
|--------|--------|-----------|----------|------|--------|------|
| 担当者フィルター | user | 入力 | select | No | - | 複数選択可 |
| UTMソースフィルター | utm_source_id | 入力 | select | No | - | 複数選択可 |
| 会社フィルター | company_id | 入力 | select | No | - | 複数選択可 |
| 顧客フィルター | partner_id | 入力 | select | No | - | 複数選択可 |
| 作成日フィルター | created_at | 入力 | date | No | - | 日付範囲 |
| 更新日フィルター | updated_at | 入力 | date | No | - | 日付範囲 |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|----------|--------|------|--------|
| 見積書番号 | name | string | テキスト | Yes | Yes | Yes |
| ステータス | state | enum | バッジ | Yes | No | Yes |
| 請求ステータス | invoice_status | enum | バッジ | Yes | No | No |
| 作成日 | created_at | datetime | 日付 | Yes | No | No |
| 税抜金額 | amount_untaxed | decimal | 通貨 | Yes | No | No |
| 税額 | amount_tax | decimal | 通貨 | Yes | No | No |
| 合計金額 | amount_total | decimal | 通貨 | Yes | No | No |
| 納期 | commitment_date | date | 日付 | Yes | No | No |
| 予定日 | expected_date | date | 日付 | Yes | No | No |
| 顧客名 | partner.name | string | テキスト | Yes | Yes | No |
| 担当者 | user.name | string | テキスト | Yes | No | No |
| 営業チーム | team.name | string | テキスト | Yes | No | No |
| 顧客参照番号 | client_order_ref | string | バッジ | Yes | Yes | No |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、見積書作成画面（/sales/orders/quotations/create）へ遷移します。

### 2-行クリック（表示アクション）

テーブル行のアクションメニューから「表示」を選択すると、該当見積書の詳細画面へ遷移します。

### 3-編集アクション

テーブル行のアクションメニューから「編集」を選択すると、見積書編集画面へ遷移します。

### 4-削除アクション

テーブル行のアクションメニューから「削除」を選択すると、論理削除が実行されます。ただし、ステータスがSALE（受注済み）の見積書は削除できません。成功通知が表示されます。

### 5-完全削除アクション

論理削除された見積書に対して「完全削除」を選択すると、物理削除が実行されます。

### 6-復元アクション

論理削除された見積書に対して「復元」を選択すると、削除が取り消されます。

### 7-一括削除

複数のレコードを選択した状態でバルクアクションの「削除」を実行すると、選択されたすべてのレコードが論理削除されます。

### 8-グルーピング変更

グループ化オプションを選択すると、選択した項目でテーブルがグループ化されます。グループは折りたたみ可能です。

### 9-カラム並び替え

テーブルカラムをドラッグ＆ドロップで並び替えできます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | sales_orders | UPDATE | deleted_atにタイムスタンプを設定（論理削除） |
| 完全削除 | sales_orders | DELETE | レコードの物理削除 |
| 復元 | sales_orders | UPDATE | deleted_atをnullに設定 |
| 一括削除 | sales_orders | UPDATE | 複数レコードの論理削除 |
| 一括完全削除 | sales_orders | DELETE | 複数レコードの物理削除 |
| 一括復元 | sales_orders | UPDATE | 複数レコードの復元 |

### テーブル別更新項目詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | now() | 論理削除 |
| UPDATE（復元） | deleted_at | null | 復元 |
| DELETE | - | WHERE id = ? | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 見積書が正常に削除されました | 削除成功時 |
| MSG-002 | 成功 | 見積書が正常に完全削除されました | 完全削除成功時 |
| MSG-003 | 成功 | 見積書が正常に復元されました | 復元成功時 |
| MSG-004 | 成功 | 選択された見積書が正常に削除されました | 一括削除成功時 |
| MSG-005 | 成功 | 選択された見積書が正常に完全削除されました | 一括完全削除成功時 |
| MSG-006 | 成功 | 選択された見積書が正常に復元されました | 一括復元成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 受注済み見積書の削除試行 | 削除ボタン非表示 | アクションメニューから削除オプションが非表示 |
| 関連データが存在する場合の完全削除 | 削除処理中断 | 関連データ存在エラーメッセージ表示 |

## 備考

- モデルはWebkul\Sale\Models\Orderを使用（見積書と受注は同一モデル）
- SoftDeletes機能を使用して論理削除を実装
- 通貨はレコードごとに異なる場合があり、表示時にcurrency->codeで通貨記号を動的取得
- 金額カラムには合計（Sum）サマリーが表示される
- ステータスがSALEのレコードは削除不可（checkIfRecordIsSelectableUsing）
- QueryBuilderフィルターで高度な検索条件を設定可能
- テーブルは通貨リレーションを事前ロード（modifyQueryUsing）
