# 画面設計書 294-見積書作成

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「見積書作成」画面の設計仕様を定義するものです。

### 本画面の処理概要

見積書作成画面は、新規の見積書を作成するための入力フォーム画面です。

**業務上の目的・背景**：営業プロセスにおいて、顧客からの引き合いに対して見積書を作成することは商談の重要なステップです。この画面により、顧客情報、商品明細、支払条件、配送情報など見積書に必要な情報を包括的に入力できます。

**画面へのアクセス方法**：見積書一覧画面の「新規作成」ボタン、またはサイドメニューから直接「販売」>「注文」>「見積書」>「新規作成」でアクセスできます。

**主要な操作・処理内容**：
1. 顧客情報の選択
2. 有効期限・見積日の設定
3. 支払条件の選択
4. 商品明細の入力（Repeater形式）
5. オプション商品の追加
6. 追加情報（営業担当、配送、トラッキング、会社・通貨）の設定
7. 利用規約・備考の入力
8. 見積書の保存

**画面遷移**：保存成功後は見積書詳細画面へ遷移します。キャンセル時は見積書一覧画面へ戻ります。

**権限による表示制御**：販売管理の作成権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-001 | 見積書管理 | 主機能 | 見積書の新規作成 |
| FN-PAR-001 | 顧客管理 | 参照機能 | 顧客マスタ参照 |
| FN-PRD-001 | 商品管理 | 参照機能 | 商品マスタ参照 |
| FN-ACC-001 | 支払条件管理 | 参照機能 | 支払条件マスタ参照 |

## 画面種別

作成

## URL/ルーティング

`/sales/orders/quotations/create`

## 画面構成

- ステータスエリア
  - ProgressStepperによる状態表示（Draft表示、非活性）
- 基本情報セクション
  - 顧客選択（Select、必須、検索可能）
  - 有効期限（DatePicker、必須）
  - 見積日（DatePicker、必須）
  - 支払条件（Select、必須）
- タブエリア
  - 商品明細タブ
    - 商品Repeater（商品、数量、単位、リードタイム、パッケージング、単価、税、割引、小計）
    - サマリーLivewire（税抜金額、税額、合計金額）
  - オプション商品タブ（受注変換後は非表示）
    - オプション商品Repeater
  - その他情報タブ
    - 営業フィールドセット（担当者、顧客参照番号、タグ）
    - 配送フィールドセット（納期）
    - トラッキングフィールドセット（ソースドキュメント、キャンペーン、メディア、ソース）
    - 追加情報フィールドセット（会社、通貨）
  - 利用規約タブ
    - 利用規約・備考（RichEditor）
- フッターエリア
  - 作成ボタン
  - 作成して別のレコードを作成ボタン
  - キャンセルリンク

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 備考 |
|--------|--------|-----------|----------|------|--------|------|
| ステータス | state | 出力 | enum | - | - | デフォルトDraft、非活性 |
| 顧客 | partner_id | 入力 | integer | Yes | - | 顧客タイプのパートナーのみ |
| 有効期限 | validity_date | 入力 | date | Yes | - | 設定値からデフォルト日数計算 |
| 見積日 | date_order | 入力 | date | Yes | - | デフォルト今日 |
| 支払条件 | payment_term_id | 入力 | integer | Yes | - | デフォルトID:10 |
| 担当者 | user_id | 入力 | integer | No | - | 顧客選択時に自動設定 |
| 顧客参照番号 | client_order_ref | 入力 | string | No | 255 | |
| タグ | sales_order_tags | 入力 | array | No | - | 複数選択可 |
| 納期 | commitment_date | 入力 | date | No | - | |
| ソースドキュメント | origin | 入力 | string | No | 255 | |
| キャンペーン | campaign_id | 入力 | integer | No | - | |
| メディア | medium_id | 入力 | integer | No | - | |
| UTMソース | utm_source_id | 入力 | integer | No | - | |
| 会社 | company_id | 入力 | integer | No | - | デフォルトログインユーザーの会社 |
| 通貨 | currency_id | 入力 | integer | Yes | - | 会社選択時に自動設定 |
| 利用規約・備考 | note | 入力 | text | No | - | RichEditor |

### 商品明細（products - Repeater）

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 備考 |
|--------|--------|-----------|----------|------|------|
| 商品 | product_id | 入力 | integer | Yes | 検索可能、商品情報自動設定 |
| 数量 | product_uom_qty | 入力 | decimal | Yes | デフォルト1 |
| 単位 | product_uom_id | 入力 | integer | No | 設定で表示/非表示 |
| リードタイム | customer_lead | 入力 | integer | No | 日数 |
| パッケージング数量 | product_packaging_qty | 入力 | decimal | No | |
| パッケージング | product_packaging_id | 入力 | integer | No | 設定で表示/非表示 |
| 単価 | price_unit | 入力 | decimal | Yes | 商品から自動設定 |
| 原価 | purchase_price | 入力 | decimal | No | 設定で表示/非表示 |
| 税 | taxes | 入力 | array | No | 複数選択可 |
| 割引 | discount | 入力 | decimal | No | 設定で表示/非表示 |
| 小計 | price_subtotal | 出力 | decimal | - | 自動計算 |

## イベント仕様

### 1-顧客選択時

顧客を選択すると、以下が自動設定されます：
- 担当者（user_id）: 顧客に紐づく担当者
- 支払条件（payment_term_id）: 顧客のデフォルト支払条件

### 2-会社選択時

会社を選択すると、通貨（currency_id）が自動的に会社のデフォルト通貨に設定されます。

### 3-商品選択時

商品を選択すると、以下が自動設定されます：
- 単価（price_unit）: 商品の販売価格
- 税（taxes）: 商品のデフォルト税
- 単位（product_uom_id）: 商品の単位
- リードタイム（customer_lead）: 商品のリードタイム
- 原価（purchase_price）: 商品の原価

### 4-明細行計算

数量、単価、税、割引の変更時に小計が自動計算されます。
サマリーLivewireで税抜金額、税額、合計金額がリアルタイム更新されます。

### 5-作成ボタン押下

バリデーション通過後、見積書が作成されます。成功時は見積書詳細画面へ遷移し、成功通知が表示されます。

### 6-作成して別のレコードを作成

見積書作成後、フォームがリセットされ新規作成状態になります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | sales_orders | INSERT | 見積書ヘッダーの作成 |
| 作成 | sales_order_lines | INSERT | 見積書明細の作成（複数行） |
| 作成 | sales_order_tags | INSERT | タグ関連の作成 |
| 作成 | sales_order_line_taxes | INSERT | 明細行の税関連作成 |

### テーブル別更新項目詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | partner_id | フォーム入力値 | 必須 |
| INSERT | validity_date | フォーム入力値 | 必須 |
| INSERT | date_order | フォーム入力値 | 必須 |
| INSERT | payment_term_id | フォーム入力値 | 必須 |
| INSERT | user_id | フォーム入力値 | |
| INSERT | company_id | フォーム入力値 | |
| INSERT | currency_id | フォーム入力値 | 必須 |
| INSERT | state | 'draft' | 初期ステータス |
| INSERT | name | 'SO/' + id | 自動採番 |
| INSERT | amount_untaxed | 計算値 | 税抜合計 |
| INSERT | amount_tax | 計算値 | 税額合計 |
| INSERT | amount_total | 計算値 | 総合計 |
| INSERT | creator_id | Auth::id() | 作成者 |
| INSERT | created_at | now() | 作成日時 |

#### sales_order_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | order_id | 親レコードID | |
| INSERT | product_id | 明細入力値 | 必須 |
| INSERT | product_uom_qty | 明細入力値 | 必須 |
| INSERT | price_unit | 明細入力値 | |
| INSERT | discount | 明細入力値 | |
| INSERT | price_subtotal | 計算値 | |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 見積書が正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 必須項目を入力してください | バリデーションエラー時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 顧客が論理削除済み | 選択不可 | 選択肢に(Deleted)表示、選択不可 |

## 備考

- ProgressStepperでステータス進捗を視覚的に表示
- 顧客選択時にwithTrashedで削除済み顧客も表示（選択は不可）
- 有効期限のデフォルト日数はQuotationAndOrderSettingsから取得
- 商品設定（ProductSettings）により、単位・パッケージングの表示/非表示を制御
- 価格設定（PriceSettings）により、マージン・割引の表示/非表示を制御
- Summaryコンポーネント（Livewire）でリアルタイム金額計算
- 見積書番号（name）は'SO/' + IDで自動生成
