# 画面設計書 295-見積書編集

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「見積書編集」画面の設計仕様を定義するものです。

### 本画面の処理概要

見積書編集画面は、既存の見積書を編集・更新するための画面です。

**業務上の目的・背景**：顧客からのフィードバックや条件変更に基づき、見積書の内容を修正することは営業活動において頻繁に発生します。この画面により、見積書のヘッダー情報や明細を効率的に更新できます。

**画面へのアクセス方法**：見積書一覧画面または見積書詳細画面から「編集」アクションを選択することでアクセスできます。サブナビゲーションで他の関連画面と切り替えが可能です。

**主要な操作・処理内容**：
1. 見積書ヘッダー情報の編集
2. 商品明細の追加・編集・削除
3. オプション商品の管理
4. 追加情報の更新
5. 利用規約・備考の編集
6. 見積書の保存
7. 見積書の受注変換
8. 見積書のキャンセル
9. 見積書の確定

**画面遷移**：この画面はサブナビゲーションで見積書詳細画面、請求書管理画面、配送管理画面と切り替えできます。保存成功後は同じ画面に留まります。

**権限による表示制御**：販売管理の編集権限を持つユーザーがアクセス可能です。ロックまたはキャンセル状態の見積書は一部項目が編集不可になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-001 | 見積書管理 | 主機能 | 見積書の更新 |
| FN-SAL-002 | 受注変換 | 実行機能 | 見積書から受注への変換 |
| FN-SAL-003 | 請求書管理 | サブナビ | 関連請求書の管理 |
| FN-SAL-004 | 配送管理 | サブナビ | 関連配送の管理 |

## 画面種別

編集

## URL/ルーティング

`/sales/orders/quotations/{record}/edit`

## 画面構成

- ヘッダーエリア
  - 画面タイトル（見積書番号表示）
  - アクションボタン（確認、受注変換、キャンセル、プレビュー、メール送信など）
- サブナビゲーション
  - 詳細表示
  - 編集（現在画面）
  - 請求書
  - 配送
- ステータスエリア
  - ProgressStepperによる状態表示
- 基本情報セクション
  - 顧客選択（ロック/キャンセル時は非活性）
  - 有効期限（新規時のみ表示）
  - 見積日/受注日（ラベル動的変更）
  - 支払条件
- タブエリア
  - 商品明細タブ（キャンセル時は非活性）
  - オプション商品タブ（キャンセル時は非表示）
  - その他情報タブ
  - 利用規約タブ
- チャッターエリア
  - コメント・アクティビティログ
- フッターエリア
  - 保存ボタン
  - キャンセルリンク

## 入出力項目

基本的に作成画面と同じ項目を持ちますが、状態によって編集可否が制御されます。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 編集可否条件 | 備考 |
|--------|--------|-----------|----------|------|-------------|------|
| ステータス | state | 出力 | enum | - | 非活性 | 進捗表示 |
| 顧客 | partner_id | 入力 | integer | Yes | ロック/キャンセル時不可 | |
| 有効期限 | validity_date | 入力 | date | Yes | 新規のみ表示 | 編集時非表示 |
| 見積日/受注日 | date_order | 入力 | date | Yes | ロック/キャンセル時不可 | ラベル動的 |
| 支払条件 | payment_term_id | 入力 | integer | Yes | 常時編集可 | |
| 納期 | commitment_date | 入力 | date | No | キャンセル時不可 | |
| その他項目 | - | 入力 | - | - | 作成画面と同じ | |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| 見積書番号 | name | string | タイトル | ヘッダーに表示 |
| ステータス | state | enum | ProgressStepper | キャンセル時は非表示 |
| 商品明細 | lines | array | Repeater | サマリー付き |
| オプション商品 | optionalLines | array | Repeater | |

## イベント仕様

### 1-保存ボタン押下

変更内容を検証し、見積書を更新します。成功時は成功通知が表示されます。

### 2-確認（Confirm）アクション

見積書のステータスをSENT（送信済み）に変更します。

### 3-受注変換アクション

見積書をSALE（受注）ステータスに変換します。在庫オペレーションが自動生成される場合があります。

### 4-キャンセルアクション

見積書をCANCEL（キャンセル）ステータスに変更します。キャンセル後は多くの項目が編集不可になります。

### 5-プレビューアクション

見積書のPDFプレビューを表示します。

### 6-メール送信アクション

見積書を顧客にメールで送信します。

### 7-ロックアクション

見積書をロックし、特定の項目の編集を防止します。

### 8-アンロックアクション

ロックを解除し、編集を再び可能にします。

### 9-削除アクション

見積書を論理削除します（SALE状態では実行不可）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | sales_orders | UPDATE | 見積書ヘッダーの更新 |
| 保存 | sales_order_lines | INSERT/UPDATE/DELETE | 明細の同期 |
| 確認 | sales_orders | UPDATE | state = 'sent' |
| 受注変換 | sales_orders | UPDATE | state = 'sale' |
| 受注変換 | inventory_operations | INSERT | 在庫オペレーション作成 |
| キャンセル | sales_orders | UPDATE | state = 'cancel' |
| ロック | sales_orders | UPDATE | locked = true |
| アンロック | sales_orders | UPDATE | locked = false |

### テーブル別更新項目詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値 | |
| UPDATE | date_order | フォーム入力値 | |
| UPDATE | payment_term_id | フォーム入力値 | |
| UPDATE | state | アクションに応じた値 | |
| UPDATE | locked | true/false | |
| UPDATE | amount_untaxed | 再計算値 | |
| UPDATE | amount_tax | 再計算値 | |
| UPDATE | amount_total | 再計算値 | |
| UPDATE | updated_at | now() | |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 見積書が正常に更新されました | 保存成功時 |
| MSG-002 | 成功 | 見積書が確認されました | 確認アクション成功時 |
| MSG-003 | 成功 | 見積書が受注に変換されました | 受注変換成功時 |
| MSG-004 | 成功 | 見積書がキャンセルされました | キャンセル成功時 |
| MSG-005 | 成功 | 見積書がロックされました | ロック成功時 |
| MSG-006 | 成功 | 見積書のロックが解除されました | アンロック成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| ロック状態での編集試行 | 項目非活性 | 編集不可を視覚的に表示 |
| SALE状態での削除試行 | 削除ボタン非表示 | - |

## 備考

- サブナビゲーションで詳細表示、請求書管理、配送管理と切り替え可能
- ステータスに応じて編集可能な項目が動的に変化
- lockedフラグで追加のロック制御が可能
- CANCEL状態ではほとんどの項目が編集不可
- HasChatterトレイトでコメント・アクティビティログ機能を提供
- HasLogActivityトレイトで変更履歴を自動記録
- 見積書番号は編集不可（自動生成）
- 受注変換時に在庫オペレーション（出庫指示）が自動作成される場合がある
