# 画面設計書 296-見積書詳細

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「見積書詳細」画面の設計仕様を定義するものです。

### 本画面の処理概要

見積書詳細画面は、見積書の詳細情報を読み取り専用で表示するビュー画面です。

**業務上の目的・背景**：営業担当者や管理者が見積書の内容を確認するための画面です。編集せずに詳細情報を閲覧でき、必要に応じてアクション（受注変換、メール送信など）を実行できます。

**画面へのアクセス方法**：見積書一覧画面から「表示」アクションを選択、または見積書の行をクリックすることでアクセスできます。

**主要な操作・処理内容**：
1. 見積書ヘッダー情報の表示
2. 商品明細の表示
3. 見積書の受注変換
4. 見積書の確認（送信）
5. 見積書のキャンセル
6. PDFプレビュー
7. メール送信
8. コメント・アクティビティの表示

**画面遷移**：この画面はサブナビゲーションで見積書編集画面、請求書管理画面、配送管理画面と切り替えできます。

**権限による表示制御**：販売管理の閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-001 | 見積書管理 | 主機能 | 見積書の詳細表示 |
| FN-SAL-002 | 受注変換 | 実行機能 | 見積書から受注への変換 |
| FN-SAL-003 | 請求書管理 | サブナビ | 関連請求書の参照 |
| FN-SAL-004 | 配送管理 | サブナビ | 関連配送の参照 |

## 画面種別

詳細

## URL/ルーティング

`/sales/orders/quotations/{record}`

## 画面構成

- ヘッダーエリア
  - 画面タイトル（見積書番号表示）
  - アクションボタン（編集、確認、受注変換、キャンセル、プレビュー、メール送信など）
- サブナビゲーション
  - 詳細表示（現在画面）
  - 編集
  - 請求書
  - 配送
- ステータスセクション
  - ステータスバッジ表示
- 基本情報セクション
  - 見積書番号（太字・大サイズ）
  - 顧客名（アイコン付き）
  - 有効期限（日付形式、アイコン付き）
  - 見積日（日付形式、アイコン付き）
  - 支払条件（アイコン付き）
- タブエリア
  - 商品明細タブ
    - 商品名
    - 数量
    - 単位
    - リードタイム
    - パッケージング数量
    - パッケージング
    - 単価
    - 原価
    - マージン
    - マージン率
    - 税（バッジ）
    - 割引率
    - 小計
  - その他情報タブ
    - 営業情報（担当者、顧客参照番号、タグ）
    - 配送情報（納期）
    - トラッキング情報（ソースドキュメント、キャンペーン、メディア、ソース）
    - 追加情報（会社、通貨）
  - 利用規約タブ
    - 利用規約・備考
- チャッターエリア
  - コメント履歴
  - アクティビティログ

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| ステータス | state | enum | バッジ | コンパクト表示 |
| 見積書番号 | name | string | テキスト | 太字・大サイズ・アイコン付き |
| 顧客名 | partner.name | string | テキスト | アイコン付き |
| 有効期限 | validity_date | date | 日付 | アイコン付き |
| 見積日 | date_order | date | 日付 | アイコン付き |
| 支払条件 | paymentTerm.name | string | テキスト | アイコン付き |

### 商品明細表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 幅 | トグル | 条件 |
|--------|--------|----------|----------|-----|--------|------|
| 商品名 | name | string | テキスト | 250px | Yes | - |
| 数量 | product_uom_qty | decimal | 数値 | 150px | Yes | - |
| 単位 | uom | object | テキスト | 150px | Yes | enable_uom設定 |
| リードタイム | customer_lead | integer | 数値+日数 | 150px | Yes | - |
| パッケージング数量 | product_packaging_qty | decimal | 数値 | 180px | Yes | enable_packagings設定 |
| パッケージング | productPackaging | object | テキスト | 200px | Yes | enable_packagings設定 |
| 単価 | price_unit | decimal | 通貨 | 150px | Yes | - |
| 原価 | purchase_price | decimal | 通貨 | 150px | Yes | - |
| マージン | margin | decimal | 通貨 | 150px | Yes | enable_margin設定 |
| マージン率 | margin_percent | decimal | パーセント | 150px | Yes | enable_margin設定 |
| 税 | taxes | array | バッジ | 250px | Yes | - |
| 割引率 | discount | decimal | パーセント | 250px | Yes | enable_discount設定 |
| 小計 | price_subtotal | decimal | 通貨 | 150px | Yes | - |

## イベント仕様

### 1-編集アクション

ヘッダーの「編集」ボタンをクリックすると、見積書編集画面へ遷移します。

### 2-確認（Confirm）アクション

見積書のステータスをSENT（送信済み）に変更します。

### 3-受注変換アクション

見積書をSALE（受注）ステータスに変換します。

### 4-キャンセルアクション

見積書をCANCEL（キャンセル）ステータスに変更します。

### 5-プレビューアクション

見積書のPDFプレビューを表示します。

### 6-メール送信アクション

見積書を顧客にメールで送信します。

### 7-サブナビゲーション切替

サブナビゲーションから請求書管理画面または配送管理画面へ遷移します。

## データベース更新仕様

この画面は主に表示専用ですが、アクション実行時は以下の更新が発生します。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確認 | sales_orders | UPDATE | state = 'sent' |
| 受注変換 | sales_orders | UPDATE | state = 'sale' |
| キャンセル | sales_orders | UPDATE | state = 'cancel' |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 見積書が確認されました | 確認アクション成功時 |
| MSG-002 | 成功 | 見積書が受注に変換されました | 受注変換成功時 |
| MSG-003 | 成功 | 見積書がキャンセルされました | キャンセル成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 不正なステータス遷移 | 操作拒否 | ステータスエラーメッセージ表示 |

## 備考

- Infolist（情報リスト）形式で読み取り専用表示
- RepeatableEntryで商品明細を表形式で表示
- カラムマネージャーで表示カラムをカスタマイズ可能（2カラム）
- 設定（ProductSettings, PriceSettings）により一部項目の表示/非表示を制御
- 通貨表示はレコードごとのcurrency.codeを使用
- アイコン付きテキストエントリーで視認性を向上
- コンパクトセクションでステータスを目立たせて表示
- 商品名にはツールチップで商品詳細を表示
- 税はバッジ形式で複数表示可能
- HasChatterトレイトによりコメント・アクティビティログを表示
