# 画面設計書 297-受注一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「受注一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

受注一覧画面は、確定した受注（Sales Order）を一覧表示し、管理するための画面です。見積書が承認・変換されると受注として表示されます。

**業務上の目的・背景**：受注は販売プロセスの確定段階を表し、配送・請求の基礎となります。この画面により、営業担当者は確定した受注を効率的に管理し、フルフィルメントプロセスを追跡できます。

**画面へのアクセス方法**：サイドメニューから「販売」>「注文」>「受注」を選択することでアクセスできます。Ordersクラスターのメイン画面として配置されています。

**主要な操作・処理内容**：
1. 受注一覧の表示・検索・ソート
2. 多様な条件でのフィルタリング
3. 受注のグループ化表示
4. 新規受注の作成（見積書経由が推奨）
5. 受注の詳細表示・編集
6. 受注の一括操作
7. 金額サマリの表示

**画面遷移**：この画面から受注作成画面、受注詳細画面、受注編集画面へ遷移できます。また、請求書管理画面、配送管理画面へサブナビゲーションで移動できます。

**権限による表示制御**：販売管理の権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-002 | 受注管理 | 主機能 | 受注のCRUD操作 |
| FN-SAL-003 | 請求書管理 | 関連機能 | 受注から請求書生成 |
| FN-SAL-004 | 配送管理 | 関連機能 | 受注から配送指示生成 |
| FN-SAL-001 | 見積書管理 | 遷移元機能 | 見積書からの変換 |

## 画面種別

一覧

## URL/ルーティング

`/sales/orders/orders`

## 画面構成

- ヘッダーエリア
  - 画面タイトル「受注」
  - 新規作成ボタン
- フィルターエリア
  - QueryBuilderベースのフィルター（見積書一覧と同じ）
- グルーピングオプション
  - 見積書一覧と同じグルーピングオプション
- テーブルエリア
  - 見積書一覧と同じカラム構成
  - ただし、state = SALEのレコードのみ表示
- アクション列
  - 表示・編集・削除・完全削除・復元
- バルクアクションエリア
  - 一括削除・一括完全削除・一括復元

## 入出力項目

見積書一覧画面と同じ項目構成です。フィルター条件が主な入力項目となります。

## 表示項目

見積書一覧画面と同じ表示項目構成です。

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|----------|--------|------|--------|
| 受注番号 | name | string | テキスト | Yes | Yes | Yes |
| ステータス | state | enum | バッジ | Yes | No | Yes |
| 請求ステータス | invoice_status | enum | バッジ | Yes | No | No |
| 作成日 | created_at | datetime | 日付 | Yes | No | No |
| 税抜金額 | amount_untaxed | decimal | 通貨 | Yes | No | No |
| 税額 | amount_tax | decimal | 通貨 | Yes | No | No |
| 合計金額 | amount_total | decimal | 通貨 | Yes | No | No |
| 納期 | commitment_date | date | 日付 | Yes | No | No |
| 予定日 | expected_date | date | 日付 | Yes | No | No |
| 顧客名 | partner.name | string | テキスト | Yes | Yes | No |
| 担当者 | user.name | string | テキスト | Yes | No | No |
| 営業チーム | team.name | string | テキスト | Yes | No | No |
| 顧客参照番号 | client_order_ref | string | バッジ | Yes | Yes | No |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、受注作成画面（/sales/orders/orders/create）へ遷移します。

### 2-行クリック（表示アクション）

テーブル行のアクションメニューから「表示」を選択すると、該当受注の詳細画面へ遷移します。

### 3-編集アクション

テーブル行のアクションメニューから「編集」を選択すると、受注編集画面へ遷移します。

### 4-削除アクション

テーブル行のアクションメニューから「削除」を選択すると、論理削除が実行されます。受注は通常削除されませんが、特殊なケースで使用されます。

### 5-完全削除アクション

論理削除された受注に対して「完全削除」を選択すると、物理削除が実行されます。

### 6-復元アクション

論理削除された受注に対して「復元」を選択すると、削除が取り消されます。

### 7-一括操作

複数のレコードを選択した状態でバルクアクションを実行できます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | sales_orders | UPDATE | deleted_atにタイムスタンプを設定 |
| 完全削除 | sales_orders | DELETE | レコードの物理削除 |
| 復元 | sales_orders | UPDATE | deleted_atをnullに設定 |

### クエリ修正

テーブル表示時に以下のクエリ修正が適用されます：
- `WHERE state = 'sale'`
- これにより、SALEステータスの受注のみが表示されます

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 受注が正常に削除されました | 削除成功時 |
| MSG-002 | 成功 | 受注が正常に完全削除されました | 完全削除成功時 |
| MSG-003 | 成功 | 受注が正常に復元されました | 復元成功時 |
| MSG-004 | 成功 | 選択された受注が正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| 関連データが存在する場合の削除 | 削除処理中断 | 関連データ存在エラーメッセージ表示 |

## 備考

- OrderResourceはQuotationResourceを継承・再利用している
- table関数でmodifyQueryUsingによりstate = SALEでフィルタリング
- form/infolist関数はQuotationResource::form/infolistを再利用
- 削除アクションは見積書一覧と異なり、常に実行可能（見積書ではSALE状態で非表示）
- ナビゲーションソートは2（見積書は1）
- ナビゲーションアイコンはheroicon-o-shopping-bag
- ページ構成：一覧、作成、表示、編集、請求書管理、配送管理
