# 画面設計書 298-受注作成

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「受注作成」画面の設計仕様を定義するものです。

### 本画面の処理概要

受注作成画面は、新規の受注を直接作成するための入力フォーム画面です。

**業務上の目的・背景**：通常、受注は見積書から変換して作成されますが、既存顧客からの定型注文や電話注文など、見積書を経由せずに直接受注を作成するケースがあります。この画面により、そのような直接受注に対応できます。

**画面へのアクセス方法**：受注一覧画面の「新規作成」ボタン、またはサイドメニューから直接アクセスできます。

**主要な操作・処理内容**：
1. 顧客情報の選択
2. 受注日・支払条件の設定
3. 商品明細の入力
4. 追加情報の設定
5. 受注の保存

**画面遷移**：保存成功後は受注詳細画面へ遷移します。キャンセル時は受注一覧画面へ戻ります。

**権限による表示制御**：販売管理の作成権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-002 | 受注管理 | 主機能 | 受注の新規作成 |
| FN-PAR-001 | 顧客管理 | 参照機能 | 顧客マスタ参照 |
| FN-PRD-001 | 商品管理 | 参照機能 | 商品マスタ参照 |

## 画面種別

作成

## URL/ルーティング

`/sales/orders/orders/create`

## 画面構成

見積書作成画面（No.294）と同じ構成です。QuotationResource::formを再利用しています。

- ステータスエリア
  - ProgressStepperによる状態表示（初期状態はDraft）
- 基本情報セクション
  - 顧客選択（Select、必須、検索可能）
  - 有効期限（DatePicker、必須）
  - 受注日（DatePicker、必須）
  - 支払条件（Select、必須）
- タブエリア
  - 商品明細タブ
  - オプション商品タブ
  - その他情報タブ
  - 利用規約タブ
- フッターエリア
  - 作成ボタン
  - 作成して別のレコードを作成ボタン
  - キャンセルリンク

## 入出力項目

見積書作成画面（No.294）と同じ入出力項目です。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 備考 |
|--------|--------|-----------|----------|------|--------|------|
| ステータス | state | 出力 | enum | - | - | デフォルトDraft |
| 顧客 | partner_id | 入力 | integer | Yes | - | |
| 有効期限 | validity_date | 入力 | date | Yes | - | |
| 受注日 | date_order | 入力 | date | Yes | - | デフォルト今日 |
| 支払条件 | payment_term_id | 入力 | integer | Yes | - | |
| その他項目 | - | 入力 | - | - | 見積書と同じ | |

### 商品明細（products - Repeater）

見積書作成画面と同じ項目構成です。

## イベント仕様

### 1-顧客選択時

顧客を選択すると、担当者と支払条件が自動設定されます。

### 2-会社選択時

会社を選択すると、通貨が自動設定されます。

### 3-商品選択時

商品を選択すると、単価・税・単位等が自動設定されます。

### 4-作成ボタン押下

バリデーション通過後、受注が作成されます。成功時は受注詳細画面へ遷移し、成功通知が表示されます。

### 5-作成して別のレコードを作成

受注作成後、フォームがリセットされ新規作成状態になります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | sales_orders | INSERT | 受注ヘッダーの作成 |
| 作成 | sales_order_lines | INSERT | 受注明細の作成 |
| 作成 | sales_order_tags | INSERT | タグ関連の作成 |
| 作成 | sales_order_line_taxes | INSERT | 明細行の税関連作成 |

### テーブル別更新項目詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | partner_id | フォーム入力値 | 必須 |
| INSERT | date_order | フォーム入力値 | 必須 |
| INSERT | payment_term_id | フォーム入力値 | 必須 |
| INSERT | state | 'draft' | 初期ステータス |
| INSERT | name | 'SO/' + id | 自動採番 |
| INSERT | amount_untaxed | 計算値 | 税抜合計 |
| INSERT | amount_tax | 計算値 | 税額合計 |
| INSERT | amount_total | 計算値 | 総合計 |
| INSERT | creator_id | Auth::id() | 作成者 |
| INSERT | created_at | now() | 作成日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 受注が正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 必須項目を入力してください | バリデーションエラー時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |

## 備考

- QuotationResource::formを再利用しており、見積書作成画面と同じフォーム構成
- 受注として作成されても、初期ステータスはDraft
- 受注に変換するには別途確認アクションが必要
- 見積書経由での作成が推奨されるワークフロー
- 受注番号は'SO/' + IDで自動生成
