# 画面設計書 299-受注編集

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「受注編集」画面の設計仕様を定義するものです。

### 本画面の処理概要

受注編集画面は、既存の受注を編集・更新するための画面です。

**業務上の目的・背景**：受注確定後も、顧客からの変更要求や配送条件の変更など、受注内容を修正する必要が生じることがあります。この画面により、受注のヘッダー情報や明細を更新できます。

**画面へのアクセス方法**：受注一覧画面または受注詳細画面から「編集」アクションを選択することでアクセスできます。サブナビゲーションで他の関連画面と切り替えが可能です。

**主要な操作・処理内容**：
1. 受注ヘッダー情報の編集
2. 商品明細の追加・編集・削除
3. 追加情報の更新
4. 利用規約・備考の編集
5. 受注の保存
6. 受注のロック/アンロック

**画面遷移**：この画面はサブナビゲーションで受注詳細画面、請求書管理画面、配送管理画面と切り替えできます。保存成功後は同じ画面に留まります。

**権限による表示制御**：販売管理の編集権限を持つユーザーがアクセス可能です。ロック状態の受注は一部項目が編集不可になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-002 | 受注管理 | 主機能 | 受注の更新 |
| FN-SAL-003 | 請求書管理 | サブナビ | 関連請求書の管理 |
| FN-SAL-004 | 配送管理 | サブナビ | 関連配送の管理 |

## 画面種別

編集

## URL/ルーティング

`/sales/orders/orders/{record}/edit`

## 画面構成

見積書編集画面（No.295）と同じ構成です。QuotationResource::formを再利用しています。

- ヘッダーエリア
  - 画面タイトル（受注番号表示）
  - アクションボタン
- サブナビゲーション
  - 詳細表示
  - 編集（現在画面）
  - 請求書
  - 配送
- ステータスエリア
  - ProgressStepperによる状態表示
- 基本情報セクション
  - 顧客選択（ロック時は非活性）
  - 受注日（ロック時は非活性）
  - 支払条件
- タブエリア
  - 商品明細タブ
  - その他情報タブ
  - 利用規約タブ
- チャッターエリア
  - コメント・アクティビティログ
- フッターエリア
  - 保存ボタン
  - キャンセルリンク

## 入出力項目

見積書編集画面（No.295）と同じ項目構成です。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 編集可否条件 | 備考 |
|--------|--------|-----------|----------|------|-------------|------|
| ステータス | state | 出力 | enum | - | 非活性 | 進捗表示 |
| 顧客 | partner_id | 入力 | integer | Yes | ロック時不可 | |
| 受注日 | date_order | 入力 | date | Yes | ロック時不可 | |
| 支払条件 | payment_term_id | 入力 | integer | Yes | 常時編集可 | |
| その他項目 | - | 入力 | - | - | 見積書編集と同じ | |

## 表示項目

見積書編集画面と同じ表示項目です。

## イベント仕様

### 1-保存ボタン押下

変更内容を検証し、受注を更新します。成功時は成功通知が表示されます。

### 2-ロックアクション

受注をロックし、特定の項目の編集を防止します。

### 3-アンロックアクション

ロックを解除し、編集を再び可能にします。

### 4-削除アクション

受注を論理削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | sales_orders | UPDATE | 受注ヘッダーの更新 |
| 保存 | sales_order_lines | INSERT/UPDATE/DELETE | 明細の同期 |
| ロック | sales_orders | UPDATE | locked = true |
| アンロック | sales_orders | UPDATE | locked = false |

### テーブル別更新項目詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値 | |
| UPDATE | date_order | フォーム入力値 | |
| UPDATE | payment_term_id | フォーム入力値 | |
| UPDATE | locked | true/false | |
| UPDATE | amount_untaxed | 再計算値 | |
| UPDATE | amount_tax | 再計算値 | |
| UPDATE | amount_total | 再計算値 | |
| UPDATE | updated_at | now() | |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 受注が正常に更新されました | 保存成功時 |
| MSG-002 | 成功 | 受注がロックされました | ロック成功時 |
| MSG-003 | 成功 | 受注のロックが解除されました | アンロック成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| ロック状態での編集試行 | 項目非活性 | 編集不可を視覚的に表示 |

## 備考

- QuotationResource::formを再利用しており、見積書編集画面と同じフォーム構成
- サブナビゲーションで詳細表示、請求書管理、配送管理と切り替え可能
- ステータスに応じて編集可能な項目が動的に変化
- lockedフラグで追加のロック制御が可能
- HasChatterトレイトでコメント・アクティビティログ機能を提供
- HasLogActivityトレイトで変更履歴を自動記録
- 受注は通常SALE状態であり、見積書のようなステータス変更アクションは少ない
