# 画面設計書 3-勘定科目編集

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける勘定科目編集画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、既存の勘定科目情報を編集するためのフォーム画面です。勘定科目の各属性を変更し、データベースのレコードを更新します。

**業務上の目的・背景**：企業の事業環境や会計方針の変更に伴い、既存の勘定科目の属性を修正する必要が生じることがあります。本画面により、勘定科目名の変更、税設定の更新、非推奨フラグの設定など、勘定科目情報の柔軟な維持管理が可能となります。

**画面へのアクセス方法**：勘定科目一覧画面の行アクションから「編集」を選択、または勘定科目詳細画面のヘッダーにある「編集」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 既存の勘定科目情報の確認・修正
2. 勘定科目コード（code）の編集
3. 勘定科目名（name）の編集
4. 科目タイプ（account_type）の変更
5. 税設定、タグ、仕訳帳の関連付け変更
6. 通貨の変更
7. 各種フラグ（非推奨、消込対象、非取引）の変更
8. 保存ボタンによるデータ更新
9. 削除ボタンによるレコード削除

**画面遷移**：
- 本画面から遷移可能：勘定科目詳細画面（保存成功時）、勘定科目一覧画面（削除成功時）
- 本画面への遷移元：勘定科目一覧画面、勘定科目詳細画面

**権限による表示制御**：勘定科目の編集権限を持つユーザーのみアクセス可能です。削除操作は削除権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-020 | 勘定科目編集 | 主機能 | 既存勘定科目の編集 |
| FN-ACC-018 | 勘定科目一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

編集

## URL/ルーティング

`/accounts/accounts/{record}/edit`

## 画面構成

- ヘッダーエリア：画面タイトル、表示ボタン、削除ボタン
- フォームセクション：勘定科目情報入力エリア
  - 基本情報：コード、名称（2カラムレイアウト）
  - 会計設定フィールドセット：科目タイプ、税、タグ、仕訳帳、通貨、各種トグル

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 1 | コード | code | string | ○ | 既存値 | 勘定科目コード | テキスト入力（最大255文字） |
| 2 | 勘定科目名 | name | string | ○ | 既存値 | 勘定科目の名称 | テキスト入力（最大255文字） |
| 3 | 科目タイプ | account_type | enum | ○ | 既存値 | 勘定科目の種類 | セレクトボックス |
| 4 | デフォルト税 | invoices_account_tax | array | - | 既存値 | 関連する税 | 複数選択セレクト |
| 5 | タグ | invoices_account_account_tags | array | - | 既存値 | 勘定科目タグ | 複数選択セレクト |
| 6 | 仕訳帳 | invoices_account_journals | array | - | 既存値 | 関連仕訳帳 | 複数選択セレクト |
| 7 | 通貨 | currency_id | integer | - | 既存値 | 使用通貨 | セレクトボックス |
| 8 | 非推奨 | deprecated | boolean | - | 既存値 | 非推奨フラグ | トグルスイッチ |
| 9 | 消込対象 | reconcile | boolean | - | 既存値 | 消込可能フラグ | トグルスイッチ |
| 10 | 非取引 | non_trade | boolean | - | 既存値 | 非取引フラグ | トグルスイッチ |

## 表示項目

該当なし（編集画面のため入力項目と同一）

## イベント仕様

### 1-科目タイプ変更

科目タイプを変更すると、リアクティブに画面が更新されます。科目タイプが「OFF_BALANCE（オフバランス）」の場合、デフォルト税の入力欄が非表示になります。

### 2-保存ボタン押下

フォームのバリデーションを実行し、成功した場合はデータベースのレコードを更新します。更新成功後、勘定科目詳細画面（ViewAccount）へ自動遷移し、成功通知が表示されます。

### 3-表示ボタン押下

ヘッダーの「表示」ボタンを押下すると、該当レコードの詳細画面（ViewAccount）へ遷移します。

### 4-削除ボタン押下

ヘッダーの「削除」ボタンを押下すると、確認ダイアログ表示後、該当レコードを削除します。削除成功後は一覧画面へ遷移し、成功通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_accounts | UPDATE | 勘定科目レコードを更新 |
| 保存ボタン押下 | accounts_account_taxes | SYNC | 税との関連を同期 |
| 保存ボタン押下 | accounts_account_account_tags | SYNC | タグとの関連を同期 |
| 保存ボタン押下 | accounts_account_journals | SYNC | 仕訳帳との関連を同期 |
| 削除ボタン押下 | accounts_accounts | DELETE | 勘定科目レコードを削除 |

### テーブル別更新項目詳細

#### accounts_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | code | フォーム入力値 | 必須 |
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | account_type | フォーム選択値 | 必須 |
| UPDATE | currency_id | フォーム選択値 | 任意 |
| UPDATE | deprecated | フォーム入力値 | |
| UPDATE | reconcile | フォーム入力値 | |
| UPDATE | non_trade | フォーム入力値 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 勘定科目が更新されました | 保存成功時 |
| MSG-002 | 成功 | 勘定科目が削除されました | 削除成功時 |
| MSG-003 | エラー | 必須項目を入力してください | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| レコード未存在 | 404エラー表示 | 指定されたデータが見つかりません |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |
| 削除失敗（関連データあり） | エラー通知表示 | この勘定科目は使用中のため削除できません |

## 備考

- 本画面はFilament PHPのEditRecordを継承して実装されています
- 保存成功後は自動的に詳細画面（ViewAccount）へリダイレクトされます
- ヘッダーアクションにViewActionとDeleteActionが配置されています
- フォーム構成は作成画面（CreateAccount）と共通のAccountResource::form()を使用
