# 画面設計書 30-仕訳帳作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける仕訳帳作成画面の設計仕様を定義します。この画面では新規の仕訳帳（Journal）を作成し、会計取引を記録するための帳簿を設定します。

### 本画面の処理概要

**業務上の目的・背景**：
仕訳帳は会計システムの基盤となる構成要素であり、取引の種類に応じた適切な仕訳帳を設定することで、正確な会計記録と財務レポートの作成を可能にします。売上帳、仕入帳、銀行帳、現金出納帳、クレジットカード帳などの種類があり、それぞれの取引に応じた設定が必要です。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「仕訳帳」を選択して一覧画面へ遷移
3. ヘッダーの「作成」ボタンをクリック

**主要な操作・処理内容**：
1. 基本情報の入力（名称、種類、会社）
2. 仕訳帳エントリー設定（専用シーケンス、コード、通貨、色）
3. 銀行口座設定（銀行タイプの場合のみ）
4. 入金設定（銀行/現金/クレジットカードタイプの場合のみ）
5. 出金設定（銀行/現金/クレジットカードタイプの場合のみ）
6. 詳細設定（アクセス制御、支払コミュニケーション）
7. 保存して仕訳帳を作成

**画面遷移**：
- 遷移元：仕訳帳一覧画面
- 遷移先：仕訳帳詳細画面（作成成功時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-010 | 仕訳帳管理 | 主機能 | 仕訳帳の新規作成 |

## 画面種別

作成（Create）

## URL/ルーティング

`/admin/accounts/journals/create`

## 画面構成

- 3カラムレイアウト
  - 左側（2カラム幅）：タブ構成のメイン設定
    - 仕訳帳エントリータブ
    - 入金タブ（条件付き表示）
    - 出金タブ（条件付き表示）
    - 詳細設定タブ
  - 右側（1カラム幅）：基本情報セクション

## 入出力項目

### 基本情報（右サイドパネル）

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| 名称 | name | 入力 | string | ○ | - | 仕訳帳名 |
| 種類 | type | 入力 | enum | ○ | - | JournalType |
| 会社 | company_id | 入力 | integer | ○ | ユーザーのデフォルト会社 | 無効化 |
| 作成者ID | creator_id | 隠し | integer | ○ | 現在ユーザー | 自動設定 |

### 仕訳帳エントリータブ

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 表示条件 | 備考 |
|--------|--------|----------|----------|------|--------|---------|------|
| 専用クレジットノートシーケンス | refund_order | 入力 | boolean | - | false | 売上/仕入タイプ | - |
| 専用支払シーケンス | payment_order | 入力 | boolean | - | false | 銀行/現金/クレジットカードタイプ | - |
| ソートコード | code | 入力 | string | - | - | - | 短いコード |
| 通貨 | currency_id | 入力 | integer | - | null | - | 通貨選択 |
| 色 | color | 入力 | string | - | null | - | カラーピッカー（HEX） |

### 銀行口座番号フィールドセット

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 表示条件 | 備考 |
|--------|--------|----------|----------|------|--------|---------|------|
| 銀行口座 | bank_account_id | 入力 | integer | - | null | 銀行タイプ | 口座番号で選択 |

### 入金タブ

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 表示条件 | 備考 |
|--------|--------|----------|----------|------|--------|---------|------|
| 関連メモ | relation_notes | 入力 | text | - | null | 銀行/現金/クレジットカードタイプ | テキストエリア |

### 出金タブ

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 表示条件 | 備考 |
|--------|--------|----------|----------|------|--------|---------|------|
| 関連メモ | relation_notes | 入力 | text | - | null | 銀行/現金/クレジットカードタイプ | テキストエリア |

### 詳細設定タブ

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 表示条件 | 備考 |
|--------|--------|----------|----------|------|--------|---------|------|
| 許可された勘定科目 | invoices_journal_accounts | 入力 | array | - | [] | - | 複数選択 |
| 転記時に自動確認 | auto_check_on_post | 入力 | boolean | - | false | - | - |
| コミュニケーション種類 | invoice_reference_type | 入力 | enum | - | INVOICE | 売上タイプ | CommunicationType |
| コミュニケーション規格 | invoice_reference_model | 入力 | enum | - | AUREUS | 売上タイプ | CommunicationStandard |

## 表示項目

作成画面のため、入出力項目と同一。

## イベント仕様

### 1-種類（type）変更時

1. 選択された種類に応じてフォームの表示項目を動的に切り替え
   - 売上/仕入：refund_order表示、支払コミュニケーション表示
   - 銀行/現金/クレジットカード：payment_order表示、入金/出金タブ表示、銀行口座フィールドセット表示（銀行のみ）

### 2-保存ボタン押下

1. フォームバリデーション実行
2. `mutateFormDataBeforeCreate`で以下を処理：
   - creator_idに現在ユーザーIDを設定
   - invoice_reference_typeのデフォルト設定（未設定の場合）
   - invoice_reference_modelのデフォルト設定（未設定の場合）
3. データベースに新規レコードを挿入
4. 成功通知を表示
5. 詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | journals | INSERT | 仕訳帳の作成 |
| 保存ボタン押下 | journal_allowed_accounts | INSERT | 許可勘定科目の関連付け |

### テーブル別更新項目詳細

#### journals

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | type | フォーム入力値（JournalType） | 必須 |
| INSERT | company_id | フォーム入力値 | 必須 |
| INSERT | creator_id | Auth::user()->id | 自動設定 |
| INSERT | code | フォーム入力値 | nullable |
| INSERT | currency_id | フォーム入力値 | nullable |
| INSERT | color | フォーム入力値（HEX） | nullable |
| INSERT | refund_order | フォーム入力値 | boolean |
| INSERT | payment_order | フォーム入力値 | boolean |
| INSERT | bank_account_id | フォーム入力値 | nullable、銀行タイプのみ |
| INSERT | relation_notes | フォーム入力値 | nullable |
| INSERT | auto_check_on_post | フォーム入力値 | boolean |
| INSERT | invoice_reference_type | フォーム入力値またはINVOICE | enum |
| INSERT | invoice_reference_model | フォーム入力値またはAUREUS | enum |
| INSERT | created_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| create-journal.notification.title | 成功 | 作成成功タイトル | 作成処理成功時 |
| create-journal.notification.body | 成功 | 作成成功メッセージ本文 | 作成処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 権限不足 | 作成権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| バリデーションエラー | 必須項目未入力など | フォームにエラーメッセージを表示 |
| 重複エラー | 同一コードが既に存在する場合 | エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装されている
- 3カラムレイアウト（左2:右1）で構成
- 種類（type）の選択によりフォームが動的に変化
- タブはクエリストリングに永続化される（persistTabInQueryString）
- 会社選択は無効化されており、ユーザーのデフォルト会社が自動設定
- CommunicationTypeとCommunicationStandardは売上タイプ仕訳帳専用の設定
- 色設定はカラーピッカーでHEX形式を入力
