# 画面設計書 300-受注詳細

## 概要

本ドキュメントは、Aureus ERPシステムの販売管理モジュールにおける「受注詳細」画面の設計仕様を定義するものです。

### 本画面の処理概要

受注詳細画面は、受注の詳細情報を読み取り専用で表示するビュー画面です。

**業務上の目的・背景**：営業担当者や管理者が受注の内容を確認し、配送・請求の状況を把握するための画面です。編集せずに詳細情報を閲覧でき、関連する請求書や配送情報にもアクセスできます。

**画面へのアクセス方法**：受注一覧画面から「表示」アクションを選択、または受注の行をクリックすることでアクセスできます。

**主要な操作・処理内容**：
1. 受注ヘッダー情報の表示
2. 商品明細の表示
3. 請求書管理画面への遷移
4. 配送管理画面への遷移
5. PDFプレビュー
6. メール送信
7. コメント・アクティビティの表示

**画面遷移**：この画面はサブナビゲーションで受注編集画面、請求書管理画面、配送管理画面と切り替えできます。

**権限による表示制御**：販売管理の閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SAL-002 | 受注管理 | 主機能 | 受注の詳細表示 |
| FN-SAL-003 | 請求書管理 | サブナビ | 関連請求書の参照 |
| FN-SAL-004 | 配送管理 | サブナビ | 関連配送の参照 |

## 画面種別

詳細

## URL/ルーティング

`/sales/orders/orders/{record}`

## 画面構成

見積書詳細画面（No.296）と同じ構成です。QuotationResource::infolistを再利用しています。

- ヘッダーエリア
  - 画面タイトル（受注番号表示）
  - アクションボタン（編集、プレビュー、メール送信など）
- サブナビゲーション
  - 詳細表示（現在画面）
  - 編集
  - 請求書
  - 配送
- ステータスセクション
  - ステータスバッジ表示
- 基本情報セクション
  - 受注番号（太字・大サイズ）
  - 顧客名（アイコン付き）
  - 有効期限（日付形式、アイコン付き）
  - 受注日（日付形式、アイコン付き）
  - 支払条件（アイコン付き）
- タブエリア
  - 商品明細タブ
  - その他情報タブ
  - 利用規約タブ
- チャッターエリア
  - コメント履歴
  - アクティビティログ

## 表示項目

見積書詳細画面（No.296）と同じ表示項目です。

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| ステータス | state | enum | バッジ | コンパクト表示 |
| 受注番号 | name | string | テキスト | 太字・大サイズ・アイコン付き |
| 顧客名 | partner.name | string | テキスト | アイコン付き |
| 有効期限 | validity_date | date | 日付 | アイコン付き |
| 受注日 | date_order | date | 日付 | アイコン付き |
| 支払条件 | paymentTerm.name | string | テキスト | アイコン付き |

### 商品明細表示項目

見積書詳細画面と同じ項目構成です。

## イベント仕様

### 1-編集アクション

ヘッダーの「編集」ボタンをクリックすると、受注編集画面へ遷移します。

### 2-プレビューアクション

受注のPDFプレビューを表示します。

### 3-メール送信アクション

受注確認書を顧客にメールで送信します。

### 4-サブナビゲーション切替

サブナビゲーションから請求書管理画面または配送管理画面へ遷移します。

## データベース更新仕様

この画面は表示専用のため、データベース更新は発生しません。

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | メールが送信されました | メール送信成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| データベース接続エラー | - | システムエラーメッセージ表示 |
| 権限不足 | 操作拒否 | 権限エラーメッセージ表示 |
| レコード未検出 | 404表示 | レコードが見つかりませんメッセージ |

## 備考

- QuotationResource::infolistを再利用しており、見積書詳細画面と同じ表示構成
- Infolist（情報リスト）形式で読み取り専用表示
- RepeatableEntryで商品明細を表形式で表示
- カラムマネージャーで表示カラムをカスタマイズ可能
- 設定（ProductSettings, PriceSettings）により一部項目の表示/非表示を制御
- 通貨表示はレコードごとのcurrency.codeを使用
- アイコン付きテキストエントリーで視認性を向上
- 受注は通常SALE状態で固定されており、ステータスバッジはSALEを表示
- HasChatterトレイトによりコメント・アクティビティログを表示
- サブナビゲーションで請求書管理（ManageInvoices）、配送管理（ManageDeliveries）へ遷移可能
