# 画面設計書 301-顧客一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける顧客一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、販売活動において取引対象となる顧客（パートナー）の一覧表示・管理を行うための画面です。

**業務上の目的・背景**：
販売業務において、顧客情報の一元管理は不可欠です。本画面は、営業担当者が顧客情報を素早く検索・参照し、見積書や受注を作成する際のベースとなる顧客マスタを効率的に管理することを目的としています。顧客の連絡先、会社情報、タグによる分類など、営業活動に必要な情報を一目で確認できるよう設計されています。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「注文」クラスター → 「顧客」を選択してアクセスします。URLは `/sales/orders/customers` となります。

**主要な操作・処理内容**：
1. 顧客一覧をカード形式のグリッドレイアウトで表示（レスポンシブ対応）
2. 名前、メール、電話番号などで顧客を検索
3. アカウントタイプ、親会社、業種などの条件でフィルタリング
4. 個人/法人/アーカイブ済みのプリセットビュー切り替え
5. 新規顧客の作成
6. 既存顧客の詳細表示・編集・削除
7. 複数顧客の一括削除・復元

**画面遷移**：
- この画面から遷移できる画面：顧客作成画面、顧客詳細画面、顧客編集画面
- この画面に遷移してくる画面：販売ダッシュボード、見積書一覧、受注一覧

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示・作成・編集・削除権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-017 | 顧客一覧 | 主機能 | 顧客データの一覧表示と検索 |
| FN-SALES-018 | 顧客作成 | 遷移先機能 | ヘッダーの作成ボタンから遷移 |
| FN-SALES-019 | 顧客編集 | 遷移先機能 | 行アクションから遷移 |
| FN-SALES-020 | 顧客表示 | 遷移先機能 | 行アクションから遷移 |

## 画面種別

一覧（グリッドカード表示）

## URL/ルーティング

- URL: `/sales/orders/customers`
- ルート名: `filament.sales.resources.customers.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\Orders\Resources\CustomerResource\Pages\ListCustomers`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「顧客」
   - 新規作成ボタン（+アイコン付き）

2. **プリセットビュータブ**
   - 個人（Individuals）：個人顧客のみ表示
   - 法人（Companies）：法人顧客のみ表示
   - アーカイブ済み（Archived）：削除済み顧客を表示

3. **フィルタ・検索エリア**
   - 検索ボックス（名前、メール、電話で検索）
   - クエリビルダーフィルタ（モーダル形式）
   - グループ化セレクタ

4. **顧客カードグリッド**
   - レスポンシブグリッドレイアウト（sm:1列, md:2列, xl:3列）
   - 各カードにアバター、名前、会社、役職、メール、電話、タグを表示

5. **ページネーション**
   - 16/32/64/全件の切り替え

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| avatar | 画像 | 顧客のプロフィール画像 | 200x250px |
| name | テキスト | 顧客名 | 太字表示、検索・ソート可能 |
| parent.name | テキスト | 所属会社名 | 親パートナーがある場合のみ表示 |
| job_title | テキスト | 役職 | ブリーフケースアイコン付き |
| email | テキスト | メールアドレス | 封筒アイコン付き、20文字で切り詰め |
| phone | テキスト | 電話番号 | 電話アイコン付き |
| tags | バッジ | タグ一覧 | カラー付きバッジで表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、顧客作成画面（CreateCustomer）へ遷移します。

### 2-顧客カードクリック（表示）

顧客カードの「表示」アクションを選択すると、顧客詳細画面（ViewCustomer）へ遷移します。

### 3-顧客カード編集アクション

顧客カードの「編集」アクションを選択すると、顧客編集画面（EditCustomer）へ遷移します。削除済みの場合は非表示となります。

### 4-顧客削除アクション

顧客カードの「削除」アクションを選択すると、確認ダイアログ表示後にソフトデリートを実行します。

### 5-顧客復元アクション

アーカイブ済みビューで「復元」アクションを選択すると、ソフトデリートを解除します。

### 6-顧客完全削除アクション

アーカイブ済みビューで「完全削除」アクションを選択すると、物理削除を実行します。関連レコードがある場合はエラー通知を表示します。

### 7-一括削除

複数の顧客を選択し「一括削除」を実行すると、選択した顧客をまとめてソフトデリートします。

### 8-プリセットビュー切り替え

タブを切り替えることで、表示対象を個人/法人/アーカイブ済みにフィルタリングします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 顧客カードクリック | partners | SELECT | 顧客詳細情報の取得 |
| 削除アクション | partners | UPDATE | deleted_atカラムに日時を設定（ソフトデリート） |
| 復元アクション | partners | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除アクション | partners | DELETE | レコードの物理削除 |
| 一括削除 | partners | UPDATE | 複数レコードのソフトデリート |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | - | 物理削除（関連レコード確認必須） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification | 成功 | 顧客が正常に更新されました | 編集完了時 |
| delete.notification | 成功 | 顧客が正常に削除されました | 削除完了時 |
| restore.notification | 成功 | 顧客が正常に復元されました | 復元完了時 |
| force-delete.notification.success | 成功 | 顧客が完全に削除されました | 完全削除成功時 |
| force-delete.notification.error | エラー | 関連レコードがあるため削除できません | 完全削除失敗時 |
| bulk-delete.notification | 成功 | 選択した顧客が削除されました | 一括削除完了時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 関連レコードがある状態での完全削除 | QueryExceptionをキャッチし処理を中断 | エラー通知を表示 |
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はPartnerResourceを継承しており、基本的なCRUD機能はパートナー管理機能を流用しています
- 顧客作成時に `sub_type = 'customer'` が自動設定されます
- グリッドレイアウトはFilamentのcontentGrid機能を使用しており、画面サイズに応じて列数が自動調整されます
- 削除済み顧客は通常の一覧には表示されず、「アーカイブ済み」タブでのみ確認できます
