# 画面設計書 302-顧客作成

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける顧客作成画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、販売活動において新規顧客（パートナー）を登録するための画面です。

**業務上の目的・背景**：
新規顧客との取引を開始する際、顧客マスタへの登録が必要です。本画面は、営業担当者が新規顧客の基本情報（名前、連絡先、住所等）を効率的に入力し、顧客データベースに登録することを目的としています。個人顧客と法人顧客の両方に対応しており、顧客タイプに応じた入力フォームを提供します。

**画面へのアクセス方法**：
顧客一覧画面のヘッダーにある「新規作成」ボタンをクリック、またはURLに直接 `/sales/orders/customers/create` を入力してアクセスします。

**主要な操作・処理内容**：
1. アカウントタイプ（個人/法人）の選択
2. 顧客基本情報の入力（名前、メール、電話等）
3. 住所情報の入力
4. 販売関連情報の入力（担当者、業種等）
5. タグの設定
6. 顧客データの保存

**画面遷移**：
- この画面から遷移できる画面：顧客詳細画面（保存後）、顧客一覧画面（キャンセル時）
- この画面に遷移してくる画面：顧客一覧画面

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、作成権限がないユーザーはこの画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-018 | 顧客作成 | 主機能 | 新規顧客の登録処理 |
| FN-SALES-020 | 顧客表示 | 遷移先機能 | 保存後に詳細画面へ遷移 |

## 画面種別

登録（フォーム）

## URL/ルーティング

- URL: `/sales/orders/customers/create`
- ルート名: `filament.sales.resources.customers.create`
- コントローラ: `Webkul\Sale\Filament\Clusters\Orders\Resources\CustomerResource\Pages\CreateCustomer`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「顧客を作成」
   - サブナビゲーション（クラスター内の他画面へのリンク）

2. **基本情報セクション**
   - アカウントタイプラジオボタン（個人/法人）
   - 名前入力フィールド（必須）
   - 所属会社選択（個人の場合のみ表示）
   - アバター画像アップロード

3. **連絡先情報エリア**
   - Tax ID
   - 役職
   - 電話番号
   - 携帯電話
   - メールアドレス
   - Webサイト
   - 敬称選択
   - タグ選択（複数可）

4. **住所フィールドセット**
   - 住所1、住所2
   - 市区町村
   - 郵便番号
   - 国選択
   - 都道府県/州選択

5. **販売・購買タブ**
   - 担当者選択
   - 会社ID
   - 参照番号
   - 業種選択

6. **フッター部**
   - 作成ボタン
   - キャンセルボタン

## 入出力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 | 備考 |
|--------|-----|------|--------|------|------|
| account_type | ラジオ | ○ | - | アカウントタイプ | individual/company |
| name | テキスト | ○ | 255 | 顧客名 | プレースホルダーがタイプにより変化 |
| parent_id | 選択 | - | - | 所属会社 | 個人の場合のみ表示 |
| avatar | ファイル | - | - | プロフィール画像 | 画像ファイルのみ |
| tax_id | テキスト | - | 255 | 税ID | 例: 29ABCDE1234F1Z5 |
| job_title | テキスト | - | 255 | 役職 | 例: CEO |
| phone | テキスト | - | 255 | 電話番号 | tel形式 |
| mobile | テキスト | - | 255 | 携帯電話 | tel形式 |
| email | テキスト | - | 255 | メールアドレス | email形式、一意制約 |
| website | テキスト | - | 255 | Webサイト | URL形式 |
| title_id | 選択 | - | - | 敬称 | マスタから選択 |
| tags | 複数選択 | - | - | タグ | 複数選択可 |
| street1 | テキスト | - | 255 | 住所1 | - |
| street2 | テキスト | - | 255 | 住所2 | - |
| city | テキスト | - | 255 | 市区町村 | - |
| zip | テキスト | - | 255 | 郵便番号 | - |
| country_id | 選択 | - | - | 国 | 選択で州がリセット |
| state_id | 選択 | - | - | 都道府県/州 | 国に連動 |
| user_id | 選択 | - | - | 担当者 | ユーザーマスタから選択 |
| company_registry | テキスト | - | 255 | 会社ID | - |
| reference | テキスト | - | 255 | 参照番号 | - |
| industry_id | 選択 | - | - | 業種 | マスタから選択 |

## 表示項目

該当なし（入力フォームのため）

## イベント仕様

### 1-アカウントタイプ変更

アカウントタイプを変更すると、名前フィールドのプレースホルダーが変化し、個人の場合は所属会社選択フィールドが表示されます。

### 2-所属会社新規作成

所属会社選択のプラスボタンを押下すると、会社登録用のモーダルが表示されます。登録時にaccount_type=companyが自動設定されます。

### 3-国選択変更

国を選択すると、都道府県/州選択の選択肢が選択した国のものにフィルタリングされます。また、既に選択されていた州はリセットされます。

### 4-敬称新規作成

敬称選択のプラスボタンを押下すると、敬称登録用のモーダルが表示されます。

### 5-タグ新規作成

タグ選択のプラスボタンを押下すると、タグ登録用のモーダルが表示されます。タグ名とカラーを設定できます。

### 6-作成ボタン押下

入力内容を検証し、partnersテーブルにデータを登録します。成功時は顧客詳細画面へ遷移し、成功通知を表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | partners | INSERT | 顧客レコードの新規登録 |
| 敬称新規作成 | partners_titles | INSERT | 敬称マスタへの追加 |
| タグ新規作成 | partners_tags | INSERT | タグマスタへの追加 |
| 州新規作成 | states | INSERT | 州マスタへの追加 |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sub_type | 'customer' | 固定値で自動設定 |
| INSERT | account_type | フォーム入力値 | individual/company |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | parent_id | フォーム入力値 | 個人の場合のみ |
| INSERT | avatar | アップロードパス | partners/avatar配下 |
| INSERT | email | フォーム入力値 | 一意制約あり |
| INSERT | その他 | フォーム入力値 | 各フィールド対応 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create.notification | 成功 | 顧客が正常に作成されました | 登録成功時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.email | エラー | 有効なメールアドレスを入力してください | メール形式不正時 |
| validation.unique | エラー | このメールアドレスは既に使用されています | メール重複時 |
| validation.url | エラー | 有効なURLを入力してください | URL形式不正時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| バリデーションエラー | 処理中断、エラー箇所を赤枠で表示 | 各フィールドにエラーメッセージ表示 |
| メールアドレス重複 | 処理中断 | 重複エラーメッセージ表示 |
| ファイルアップロードエラー | 処理中断 | アップロードエラーメッセージ表示 |
| 権限不足 | 画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はCreatePartnerを継承しており、mutateFormDataBeforeCreateで `sub_type = 'customer'` を自動設定しています
- アバター画像は `partners/avatar` ディレクトリに保存され、公開アクセス可能です
- 保存成功後は自動的に顧客詳細画面（ViewCustomer）へリダイレクトされます
- 所属会社選択は法人アカウント（account_type=company または sub_type=company）のみがリストに表示されます
