# 画面設計書 303-顧客編集

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける顧客編集画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、既存の顧客（パートナー）情報を変更・更新するための画面です。

**業務上の目的・背景**：
顧客情報は、連絡先の変更、住所の変更、担当者の変更など、様々な理由で更新が必要になります。本画面は、営業担当者が既存顧客の情報を効率的に編集・更新できるよう設計されています。

**画面へのアクセス方法**：
顧客一覧画面の行アクション「編集」、または顧客詳細画面のサブナビゲーション「編集」タブをクリックしてアクセスします。URLは `/sales/orders/customers/{record}/edit` となります。

**主要な操作・処理内容**：
1. 既存顧客情報の表示・確認
2. 各フィールドの編集
3. 変更内容の保存
4. 関連ページ（連絡先、住所、銀行口座）への遷移

**画面遷移**：
- この画面から遷移できる画面：顧客詳細画面、連絡先管理画面、住所管理画面、銀行口座管理画面
- この画面に遷移してくる画面：顧客一覧画面、顧客詳細画面

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、編集権限がないユーザーはこの画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-019 | 顧客編集 | 主機能 | 既存顧客情報の更新 |
| FN-SALES-020 | 顧客表示 | 関連機能 | サブナビゲーションから遷移 |
| FN-SALES-021 | 連絡先管理 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-SALES-022 | 住所管理 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-SALES-023 | 銀行口座管理 | 遷移先機能 | サブナビゲーションから遷移 |

## 画面種別

編集（フォーム）

## URL/ルーティング

- URL: `/sales/orders/customers/{record}/edit`
- ルート名: `filament.sales.resources.customers.edit`
- コントローラ: `Webkul\Sale\Filament\Clusters\Orders\Resources\CustomerResource\Pages\EditCustomer`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「顧客を編集」
   - サブナビゲーションタブ
     - 詳細表示
     - 編集（現在のタブ）
     - 連絡先
     - 住所
     - 銀行口座

2. **基本情報セクション**
   - 顧客作成画面と同様のフィールド構成
   - 既存データがプリロードされている

3. **連絡先情報エリア**
   - 顧客作成画面と同様

4. **住所フィールドセット**
   - 顧客作成画面と同様

5. **販売・購買タブ**
   - 顧客作成画面と同様

6. **フッター部**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 | 備考 |
|--------|-----|------|--------|------|------|
| account_type | ラジオ | ○ | - | アカウントタイプ | individual/company |
| name | テキスト | ○ | 255 | 顧客名 | 既存値をプリロード |
| parent_id | 選択 | - | - | 所属会社 | 個人の場合のみ表示 |
| avatar | ファイル | - | - | プロフィール画像 | 既存画像がある場合表示 |
| tax_id | テキスト | - | 255 | 税ID | - |
| job_title | テキスト | - | 255 | 役職 | - |
| phone | テキスト | - | 255 | 電話番号 | - |
| mobile | テキスト | - | 255 | 携帯電話 | - |
| email | テキスト | - | 255 | メールアドレス | 一意制約（自身を除く） |
| website | テキスト | - | 255 | Webサイト | - |
| title_id | 選択 | - | - | 敬称 | - |
| tags | 複数選択 | - | - | タグ | - |
| street1 | テキスト | - | 255 | 住所1 | - |
| street2 | テキスト | - | 255 | 住所2 | - |
| city | テキスト | - | 255 | 市区町村 | - |
| zip | テキスト | - | 255 | 郵便番号 | - |
| country_id | 選択 | - | - | 国 | - |
| state_id | 選択 | - | - | 都道府県/州 | - |
| user_id | 選択 | - | - | 担当者 | - |
| company_registry | テキスト | - | 255 | 会社ID | - |
| reference | テキスト | - | 255 | 参照番号 | - |
| industry_id | 選択 | - | - | 業種 | - |

## 表示項目

該当なし（入力フォームのため）

## イベント仕様

### 1-サブナビゲーションタブ切り替え

サブナビゲーションのタブをクリックすると、対応する画面へ遷移します。HasRecordNavigationTabsトレイトにより、レコードIDを保持したまま遷移します。

### 2-アカウントタイプ変更

顧客作成画面と同様、アカウントタイプ変更で所属会社フィールドの表示/非表示が切り替わります。

### 3-保存ボタン押下

入力内容を検証し、partnersテーブルのデータを更新します。成功時は成功通知を表示します。

### 4-キャンセルボタン押下

編集をキャンセルし、顧客一覧画面へ戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | partners | UPDATE | 顧客レコードの更新 |
| タグ変更 | partner_tag (pivot) | INSERT/DELETE | 多対多関係の更新 |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | email | フォーム入力値 | 一意制約（自身除外） |
| UPDATE | その他 | フォーム入力値 | 各フィールド対応 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification | 成功 | 顧客が正常に更新されました | 更新成功時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.email | エラー | 有効なメールアドレスを入力してください | メール形式不正時 |
| validation.unique | エラー | このメールアドレスは既に使用されています | メール重複時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| バリデーションエラー | 処理中断、エラー箇所を赤枠で表示 | 各フィールドにエラーメッセージ表示 |
| レコード不存在 | 404エラー | 404ページ表示 |
| 権限不足 | 画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はBaseEditCustomerを継承しており、HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実現しています
- メールアドレスの一意制約は `ignoreRecord: true` オプションにより、自身のレコードは除外されます
- 親会社（parent_id）の選択肢に自身が存在しても、Filamentの処理により自己参照は防止されます
- フォーム構成は顧客作成画面と共通のPartnerResource::formを使用しています
