# 画面設計書 304-顧客詳細

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける顧客詳細画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、既存の顧客（パートナー）情報を閲覧・確認するための画面です。

**業務上の目的・背景**：
営業活動において、顧客の詳細情報を素早く確認することは重要です。本画面は、顧客の基本情報、連絡先、住所、販売関連情報を一覧形式で表示し、顧客との関係性を把握するための画面です。

**画面へのアクセス方法**：
顧客一覧画面の行アクション「表示」をクリック、または顧客作成後の自動遷移によりアクセスします。URLは `/sales/orders/customers/{record}` となります。

**主要な操作・処理内容**：
1. 顧客基本情報の閲覧
2. 連絡先情報の確認
3. 住所情報の確認
4. 販売関連情報の確認
5. 関連ページ（編集、連絡先、住所、銀行口座）への遷移

**画面遷移**：
- この画面から遷移できる画面：顧客編集画面、連絡先管理画面、住所管理画面、銀行口座管理画面
- この画面に遷移してくる画面：顧客一覧画面、顧客作成画面（保存後）

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、表示権限がないユーザーはこの画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-020 | 顧客表示 | 主機能 | 顧客詳細情報の表示 |
| FN-SALES-019 | 顧客編集 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-SALES-021 | 連絡先管理 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-SALES-022 | 住所管理 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-SALES-023 | 銀行口座管理 | 遷移先機能 | サブナビゲーションから遷移 |

## 画面種別

詳細表示（Infolist）

## URL/ルーティング

- URL: `/sales/orders/customers/{record}`
- ルート名: `filament.sales.resources.customers.view`
- コントローラ: `Webkul\Sale\Filament\Clusters\Orders\Resources\CustomerResource\Pages\ViewCustomer`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル（顧客名）
   - サブナビゲーションタブ
     - 詳細表示（現在のタブ）
     - 編集
     - 連絡先
     - 住所
     - 銀行口座

2. **基本情報セクション**
   - アカウントタイプ（バッジ表示）
   - 顧客名（太字・大きめのフォント）
   - 所属会社名（個人の場合）
   - アバター画像

3. **詳細情報グリッド（2カラム）**
   - Tax ID
   - 役職
   - 電話番号（アイコン付き）
   - 携帯電話（アイコン付き）
   - メールアドレス（アイコン付き）
   - Webサイト（アイコン付き）
   - 敬称
   - タグ（バッジ形式）

4. **住所フィールドセット**
   - 住所1
   - 住所2
   - 市区町村
   - 郵便番号
   - 国
   - 都道府県/州

5. **販売・購買タブ**
   - 担当者セクション
   - その他情報セクション（会社ID、参照番号、業種）

## 入出力項目

該当なし（閲覧専用画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| account_type | バッジ | アカウントタイプ | primary色 |
| name | テキスト | 顧客名 | 太字・大きめ表示 |
| parent.name | テキスト | 所属会社名 | 個人の場合のみ表示 |
| avatar | 画像 | プロフィール画像 | 円形、100x100px |
| tax_id | テキスト | 税ID | プレースホルダー「—」 |
| job_title | テキスト | 役職 | プレースホルダー「—」 |
| phone | テキスト | 電話番号 | 電話アイコン付き |
| mobile | テキスト | 携帯電話 | スマホアイコン付き |
| email | テキスト | メールアドレス | 封筒アイコン付き |
| website | テキスト | Webサイト | 地球アイコン付き |
| title.name | テキスト | 敬称 | プレースホルダー「—」 |
| tags.name | バッジ | タグ一覧 | カラー付きバッジ |
| street1 | テキスト | 住所1 | プレースホルダー「—」 |
| street2 | テキスト | 住所2 | プレースホルダー「—」 |
| city | テキスト | 市区町村 | プレースホルダー「—」 |
| zip | テキスト | 郵便番号 | プレースホルダー「—」 |
| country.name | テキスト | 国 | プレースホルダー「—」 |
| state.name | テキスト | 都道府県/州 | プレースホルダー「—」 |
| user.name | テキスト | 担当者 | プレースホルダー「—」 |
| company_registry | テキスト | 会社ID | プレースホルダー「—」 |
| reference | テキスト | 参照番号 | プレースホルダー「—」 |
| industry.name | テキスト | 業種 | プレースホルダー「—」 |

## イベント仕様

### 1-サブナビゲーションタブ切り替え

サブナビゲーションのタブをクリックすると、対応する画面へ遷移します。レコードIDを保持したまま遷移します。

### 2-タグクリック

タグをクリックすると、そのタグが設定された他の顧客を検索できます（将来的な拡張予定）。

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（閲覧専用画面のため更新処理なし）

## メッセージ仕様

該当なし（閲覧専用画面のため通知なし）

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| レコード不存在 | 404エラー | 404ページ表示 |
| 権限不足 | 画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はBaseViewCustomerを継承しており、PartnerResource::infolistで定義された表示構成を使用しています
- 値が未設定の項目は「—」（ダッシュ）がプレースホルダーとして表示されます
- タグはColor::generateV3Paletteを使用してカラーパレットを生成し、色付きバッジで表示されます
- 電話番号やメールアドレスにはHeroiconsのアイコンが付与され、視認性を向上させています
- サブナビゲーションはCustomerResource::getRecordSubNavigationで定義された5つの画面間を遷移できます
