# 画面設計書 305-請求対象注文一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける請求対象注文一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、請求書発行対象となる注文（受注）を一覧表示・管理するための画面です。

**業務上の目的・背景**：
販売業務において、商品の出荷やサービスの提供が完了した後、顧客への請求書発行処理が必要になります。本画面は、請求書の発行が必要な注文を一覧で確認し、請求処理への導線を提供することを目的としています。注文の請求ステータスが「要請求（To Invoice）」となっている注文のみが表示されます。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「請求対象」クラスター → 「請求対象注文」を選択してアクセスします。URLは `/sales/to-invoice/order-to-invoices` となります。

**主要な操作・処理内容**：
1. 請求対象注文の一覧表示
2. 自分の注文/アーカイブ済みのプリセットビュー切り替え
3. 注文の詳細表示・編集

**画面遷移**：
- この画面から遷移できる画面：請求対象注文詳細画面、請求対象注文編集画面
- この画面に遷移してくる画面：販売ダッシュボード、注文一覧

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-024 | 請求対象注文一覧 | 主機能 | 請求対象注文の一覧表示 |
| FN-SALES-025 | 請求対象注文詳細 | 遷移先機能 | 行アクションから遷移 |
| FN-SALES-026 | 請求対象注文編集 | 遷移先機能 | 行アクションから遷移 |

## 画面種別

一覧（テーブル）

## URL/ルーティング

- URL: `/sales/to-invoice/order-to-invoices`
- ルート名: `filament.sales.resources.order-to-invoices.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\ToInvoice\Resources\OrderToInvoiceResource\Pages\ListOrderToInvoices`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「請求対象注文」
   - （新規作成ボタンなし）

2. **プリセットビュータブ**
   - 自分の注文（My Orders）：ログインユーザーが担当の注文のみ表示
   - アーカイブ済み（Archived）：削除済み注文を表示

3. **テーブルエリア**
   - QuotationResourceのテーブル定義を継承
   - 請求ステータスが「To Invoice」の注文のみ表示

4. **ページネーション**
   - 標準のFilamentページネーション

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| name | テキスト | 注文番号 | SO/xxxx形式 |
| partner.name | テキスト | 顧客名 | - |
| date_order | 日付 | 注文日 | - |
| user.name | テキスト | 担当者 | - |
| team.name | テキスト | 営業チーム | - |
| amount_total | 通貨 | 合計金額 | - |
| state | バッジ | 注文ステータス | - |
| invoice_status | バッジ | 請求ステータス | 常に「To Invoice」 |

※ QuotationResourceから継承された列を表示

## イベント仕様

### 1-注文行クリック（表示）

テーブルの「表示」アクションを選択すると、請求対象注文詳細画面（ViewOrderToInvoice）へ遷移します。

### 2-注文編集アクション

テーブルの「編集」アクションを選択すると、請求対象注文編集画面（EditOrderToInvoice）へ遷移します。

### 3-プリセットビュー切り替え

- 「自分の注文」タブ：user_idがログインユーザーIDと一致する注文のみ表示
- 「アーカイブ済み」タブ：ソフトデリートされた注文のみ表示

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（一覧表示のみでこの画面から直接の更新処理なし）

## メッセージ仕様

該当なし（一覧表示専用画面のため）

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はQuotationResourceのテーブル定義を継承し、modifyQueryUsingで請求ステータスが「TO_INVOICE」のレコードのみにフィルタリングしています
- フォームとInfolistもQuotationResourceの定義を継承しています
- サブナビゲーションにはViewOrderToInvoice、EditOrderToInvoiceが含まれます
- データはID降順（最新順）でソートされます
- ヘッダーに新規作成アクションはありません（この画面から注文を直接作成することはできません）
