# 画面設計書 306-アップセル対象注文一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおけるアップセル対象注文一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、アップセル（追加販売）の機会がある注文を一覧表示・管理するための画面です。

**業務上の目的・背景**：
販売業務において、既存の注文に対して追加商品やサービスを提案するアップセル活動は、売上向上に重要な役割を果たします。本画面は、アップセルの機会がある注文（請求ステータスが「Up Selling」の注文）を一覧で確認し、営業担当者が追加提案を行うための情報を提供することを目的としています。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「請求対象」クラスター → 「アップセル対象注文」を選択してアクセスします。URLは `/sales/to-invoice/order-to-upsells` となります。

**主要な操作・処理内容**：
1. アップセル対象注文の一覧表示
2. 自分の注文/アーカイブ済みのプリセットビュー切り替え
3. 注文の詳細確認

**画面遷移**：
- この画面から遷移できる画面：注文詳細画面
- この画面に遷移してくる画面：販売ダッシュボード

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-027 | アップセル対象注文一覧 | 主機能 | アップセル対象注文の一覧表示 |

## 画面種別

一覧（テーブル）

## URL/ルーティング

- URL: `/sales/to-invoice/order-to-upsells`
- ルート名: `filament.sales.resources.order-to-upsells.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\ToInvoice\Resources\OrderToUpsellResource\Pages\ListOrderToUpsells`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「アップセル対象注文」
   - （新規作成ボタンなし）

2. **プリセットビュータブ**
   - 自分の注文（My Orders）：ログインユーザーが担当の注文のみ表示
   - アーカイブ済み（Archived）：削除済み注文を表示

3. **テーブルエリア**
   - QuotationResourceのテーブル定義を継承
   - 請求ステータスが「Up Selling」の注文のみ表示

4. **ページネーション**
   - 標準のFilamentページネーション

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| name | テキスト | 注文番号 | SO/xxxx形式 |
| partner.name | テキスト | 顧客名 | - |
| date_order | 日付 | 注文日 | - |
| user.name | テキスト | 担当者 | - |
| team.name | テキスト | 営業チーム | - |
| amount_total | 通貨 | 合計金額 | - |
| state | バッジ | 注文ステータス | - |
| invoice_status | バッジ | 請求ステータス | 常に「Up Selling」 |

※ QuotationResourceから継承された列を表示

## イベント仕様

### 1-プリセットビュー切り替え

- 「自分の注文」タブ：user_idがログインユーザーIDと一致する注文のみ表示
- 「アーカイブ済み」タブ：ソフトデリートされた注文のみ表示

### 2-注文行クリック

テーブルの行をクリックすると、注文の詳細情報を確認できます。

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（一覧表示のみでこの画面から直接の更新処理なし）

## メッセージ仕様

該当なし（一覧表示専用画面のため）

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はQuotationResourceのテーブル定義を継承し、modifyQueryUsingで請求ステータスが「UP_SELLING」のレコードのみにフィルタリングしています
- フォームとInfolistもQuotationResourceの定義を継承しています
- OrderToInvoiceResourceと異なり、サブナビゲーション（View/Edit）は定義されていません
- ルーティングは `index` ページのみで、詳細・編集画面へのルートは定義されていません
- ヘッダーに新規作成アクションはありません
- 請求対象注文一覧（OrderToInvoiceResource）と同じクラスター（ToInvoice）に属しています
