# 画面設計書 307-商品一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける商品一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、販売可能な商品の一覧表示・管理を行うための画面です。

**業務上の目的・背景**：
販売業務において、商品マスタの管理は不可欠です。本画面は、見積書や受注で選択する商品の一覧を表示し、商品の新規登録、編集、検索を効率的に行うことを目的としています。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「商品」クラスター → 「商品」を選択してアクセスします。URLは `/sales/products/products` となります。

**主要な操作・処理内容**：
1. 商品一覧の表示
2. 商品の検索・フィルタリング
3. 新規商品の作成
4. 既存商品の詳細表示・編集
5. プリセットビューによる絞り込み

**画面遷移**：
- この画面から遷移できる画面：商品作成画面、商品詳細画面、商品編集画面
- この画面に遷移してくる画面：販売ダッシュボード

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示・作成・編集・削除権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-028 | 商品一覧 | 主機能 | 商品データの一覧表示 |
| FN-SALES-029 | 商品作成 | 遷移先機能 | ヘッダーの作成ボタンから遷移 |
| FN-SALES-030 | 商品編集 | 遷移先機能 | 行アクションから遷移 |
| FN-SALES-031 | 商品表示 | 遷移先機能 | 行アクションから遷移 |

## 画面種別

一覧（テーブル）

## URL/ルーティング

- URL: `/sales/products/products`
- ルート名: `filament.sales.resources.products.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\Products\Resources\ProductResource\Pages\ListProducts`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「商品」
   - 新規作成ボタン

2. **フィルタ・検索エリア**
   - QueryBuilderフィルタ
   - ※ responsibleフィルタは除外されている

3. **テーブルエリア**
   - BaseProductResourceのテーブル定義を継承

4. **ページネーション**
   - 標準のFilamentページネーション

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| name | テキスト | 商品名 | 検索・ソート可能 |
| internal_reference | テキスト | 内部参照コード | - |
| type | バッジ | 商品タイプ | - |
| category.name | テキスト | カテゴリ | - |
| sales_price | 通貨 | 販売価格 | - |
| cost | 通貨 | 原価 | - |
| barcode | テキスト | バーコード | - |

※ BaseProductResourceから継承された列を表示

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、商品作成画面（CreateProduct）へ遷移します。

### 2-商品行クリック（表示）

テーブルの「表示」アクションを選択すると、商品詳細画面（ViewProduct）へ遷移します。

### 3-商品編集アクション

テーブルの「編集」アクションを選択すると、商品編集画面（EditProduct）へ遷移します。

### 4-商品削除アクション

テーブルの「削除」アクションを選択すると、確認ダイアログ表示後に削除を実行します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | products | DELETE/UPDATE | 商品の削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification | 成功 | 商品が正常に削除されました | 削除完了時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- 本画面はBaseProductResource（Invoice\Filament\Clusters\Vendors\Resources\ProductResource）を継承しています
- モデルはSale\Models\Productを使用しており、これはInvoice\Models\Productを継承しています
- フィルタのQueryBuilderから `responsible` 制約が除外されています（販売モジュールでは不要なため）
- サブナビゲーションにはView、Edit、Attributes、Variantsが含まれます
- Productsクラスターに属しており、ナビゲーションアイコンは `heroicon-o-shopping-bag` です
