# 画面設計書 308-チーム一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおけるチーム一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、営業チーム（セールスチーム）の一覧表示・管理を行うための画面です。

**業務上の目的・背景**：
販売組織において、営業チームの編成と管理は重要です。本画面は、営業チームの作成、編集、メンバー管理、目標設定などを行い、チーム単位での営業活動を支援することを目的としています。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「設定」クラスター → 「チーム」を選択してアクセスします。URLは `/sales/configuration/teams` となります。

**主要な操作・処理内容**：
1. チーム一覧の表示
2. チームの検索・フィルタリング・グループ化
3. 新規チームの作成
4. 既存チームの詳細表示・編集・削除
5. チームの復元・完全削除（アーカイブ済み）

**画面遷移**：
- この画面から遷移できる画面：チーム作成画面、チーム詳細画面、チーム編集画面
- この画面に遷移してくる画面：設定ダッシュボード

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示・作成・編集・削除権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-032 | チーム一覧 | 主機能 | チームデータの一覧表示 |
| FN-SALES-033 | チーム作成 | 遷移先機能 | ヘッダーの作成ボタンから遷移 |
| FN-SALES-034 | チーム編集 | 遷移先機能 | 行アクションから遷移 |
| FN-SALES-035 | チーム表示 | 遷移先機能 | 行アクションから遷移 |

## 画面種別

一覧（テーブル）

## URL/ルーティング

- URL: `/sales/configuration/teams`
- ルート名: `filament.sales.resources.teams.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\Configuration\Resources\TeamResource\Pages\ListTeams`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「チーム」
   - 新規作成ボタン（+アイコン付き）

2. **タブ**
   - すべて（All）：全チームを表示（件数バッジ付き）
   - アーカイブ済み（Archived）：削除済みチームを表示（件数バッジ付き）

3. **フィルタ・検索エリア**
   - QueryBuilderフィルタ（2カラム）
   - グループ化セレクタ

4. **テーブルエリア**
   - ドラッグ＆ドロップで並び替え可能（sortカラム）
   - 列の表示/非表示切り替え可能

5. **ページネーション**
   - 標準のFilamentページネーション

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| id | 数値 | ID | デフォルト非表示 |
| company.name | テキスト | 会社名 | ソート可能 |
| user.name | テキスト | チームリーダー | ソート可能 |
| color | カラー | チームカラー | 検索可能 |
| createdBy.name | テキスト | 作成者 | ソート可能 |
| name | テキスト | チーム名 | 検索可能 |
| is_active | アイコン | ステータス | 真偽値アイコン |
| invoiced_target | 数値 | 請求目標額 | ソート可能 |
| created_at | 日時 | 作成日時 | デフォルト非表示 |
| updated_at | 日時 | 更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、チーム作成画面（CreateTeam）へ遷移します。

### 2-チーム行クリック（表示）

テーブルの「表示」アクションを選択すると、チーム詳細画面（ViewTeam）へ遷移します。

### 3-チーム編集アクション

テーブルの「編集」アクションを選択すると、チーム編集画面（EditTeam）へ遷移します。

### 4-チーム削除アクション

テーブルの「削除」アクションを選択すると、確認ダイアログ表示後にソフトデリートを実行します。

### 5-チーム復元アクション

アーカイブ済みタブで「復元」アクションを選択すると、ソフトデリートを解除します。

### 6-チーム完全削除アクション

アーカイブ済みタブで「完全削除」アクションを選択すると、物理削除を実行します。

### 7-一括削除/復元/完全削除

複数のチームを選択し、一括アクションを実行できます。

### 8-行の並び替え

テーブル行をドラッグ＆ドロップで並び替えできます（sortカラムを更新）。

### 9-タブ切り替え

- 「すべて」タブ：全チームを表示
- 「アーカイブ済み」タブ：ソフトデリートされたチームのみ表示

### 10-グループ化

以下の条件でグループ化が可能：
- チーム名
- 会社
- チームリーダー
- 作成日
- 更新日

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | sales_teams | UPDATE | deleted_atカラムに日時を設定 |
| 復元アクション | sales_teams | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除アクション | sales_teams | DELETE | レコードの物理削除 |
| 行の並び替え | sales_teams | UPDATE | sortカラムの更新 |

### テーブル別更新項目詳細

#### sales_teams

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| UPDATE（並替） | sort | 新しい順序値 | ドラッグ＆ドロップ |
| DELETE | - | - | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification | 成功 | チームが正常に削除されました | 削除完了時 |
| restore.notification | 成功 | チームが正常に復元されました | 復元完了時 |
| force-delete.notification | 成功 | チームが完全に削除されました | 完全削除成功時 |
| bulk-delete.notification | 成功 | 選択したチームが削除されました | 一括削除完了時 |
| bulk-restore.notification | 成功 | 選択したチームが復元されました | 一括復元完了時 |
| bulk-force-delete.notification | 成功 | 選択したチームが完全に削除されました | 一括完全削除完了時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- モデルはSale\Models\Teamを使用しており、SoftDeletesとSortableTraitを使用しています
- フィルタはQueryBuilderで構築され、名前、チームリーダー、会社、作成者、作成日、更新日で絞り込みが可能です
- テーブルは `reorderable('sort', 'desc')` により、ドラッグ＆ドロップでの並び替えが可能です
- Configurationクラスターに属していますが、ナビゲーションへの登録は無効（shouldRegisterNavigation=false）です
- タブにはTeam::count()とTeam::onlyTrashed()->count()でバッジ件数が表示されます
