# 画面設計書 309-タグ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおけるタグ一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、販売注文に付与するタグの一覧表示・管理を行うための画面です。

**業務上の目的・背景**：
販売業務において、注文を分類・整理するためのタグ機能は重要です。本画面は、注文に付与できるタグの作成、編集、削除を管理し、効率的な注文分類を支援することを目的としています。

**画面へのアクセス方法**：
サイドナビゲーションから「販売」モジュール → 「設定」クラスター → 「タグ」を選択してアクセスします。URLは `/sales/configuration/tags` となります。

**主要な操作・処理内容**：
1. タグ一覧の表示
2. 新規タグの作成（モーダル）
3. 既存タグの詳細表示・編集・削除

**画面遷移**：
- この画面から遷移できる画面：なし（モーダルで操作完結）
- この画面に遷移してくる画面：設定ダッシュボード

**権限による表示制御**：
Filament Shieldによる権限管理が適用されており、ユーザーのロールに応じて表示・作成・編集・削除権限が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-036 | タグ一覧 | 主機能 | タグデータの一覧表示 |
| FN-SALES-037 | タグ作成 | 関連機能 | ヘッダーの作成ボタンからモーダル表示 |
| FN-SALES-038 | タグ編集 | 関連機能 | 行アクションからモーダル表示 |

## 画面種別

一覧（テーブル）

## URL/ルーティング

- URL: `/sales/configuration/tags`
- ルート名: `filament.sales.resources.tags.index`
- コントローラ: `Webkul\Sale\Filament\Clusters\Configuration\Resources\TagResource\Pages\ListTags`

## 画面構成

1. **ヘッダー部**
   - 画面タイトル「タグ」
   - 新規作成ボタン（+アイコン付き）

2. **テーブルエリア**
   - シンプルな3列テーブル
   - インライン編集・削除

3. **ページネーション**
   - 標準のFilamentページネーション

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| name | テキスト | タグ名 | 検索・ソート可能 |
| color | カラー | タグカラー | 色コードを表示 |
| createdBy.name | テキスト | 作成者 | - |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、タグ作成モーダルが表示されます。作成時にcreator_idが自動設定されます。

### 2-タグ行クリック（表示）

テーブルの「表示」アクションを選択すると、タグ詳細モーダルが表示されます。

### 3-タグ編集アクション

テーブルの「編集」アクションを選択すると、タグ編集モーダルが表示されます。

### 4-タグ削除アクション

テーブルの「削除」アクションを選択すると、確認ダイアログ表示後に削除を実行します。

### 5-一括削除

複数のタグを選択し、一括削除を実行できます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | sales_tags | INSERT | タグの新規登録 |
| 編集保存 | sales_tags | UPDATE | タグ情報の更新 |
| 削除アクション | sales_tags | DELETE | タグの削除 |
| 一括削除 | sales_tags | DELETE | 複数タグの削除 |

### テーブル別更新項目詳細

#### sales_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | color | フォーム入力値 | 16進数カラーコード |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | color | フォーム入力値 | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification | 成功 | タグが正常に更新されました | 編集完了時 |
| delete.notification | 成功 | タグが正常に削除されました | 削除完了時 |
| bulk-delete.notification | 成功 | 選択したタグが削除されました | 一括削除完了時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | Filament Shieldにより画面アクセス拒否 | 403エラーページへリダイレクト |

## 備考

- モデルはSale\Models\Tagを使用しています
- ナビゲーショングループは翻訳キー `sales::filament/clusters/configurations/resources/tag.navigation.group` で定義されています
- フォームはシンプルで、名前（必須）とカラー（16進数）の2フィールドのみです
- 作成時にmutateDataUsingでcreator_idがログインユーザーIDに設定されます
- 詳細表示（infolist）ではTextEntryとColorEntryが使用されます
- ルーティングは `index` ページのみで、作成・編集・詳細はモーダルで処理されます
- Configurationクラスターに属しています
