# 画面設計書 31-仕訳帳編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける仕訳帳編集画面の設計仕様を定義するものです。この画面は会計モジュールの仕訳帳リソースの一部として、既存の仕訳帳データの編集機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：仕訳帳は企業会計において取引を記録するための基本的な帳簿であり、売上、購入、銀行取引、現金取引などの財務活動を分類・管理するために使用されます。この編集画面は、既に登録された仕訳帳の情報（名称、タイプ、通貨、銀行口座連携、会計設定など）を修正する必要がある場合に利用されます。例えば、仕訳帳のコード変更、通貨設定の修正、関連口座の変更などの業務ニーズに対応します。

**画面へのアクセス方法**：仕訳帳一覧画面から該当レコードの「編集」ボタンをクリック、または仕訳帳詳細画面のヘッダーにある「編集」ボタンをクリックしてアクセスします。URLパターンは `/journals/{record}/edit` です。

**主要な操作・処理内容**：
1. 仕訳帳の基本情報（名称、タイプ、会社）の編集
2. 会計情報（専用クレジットノートシーケンス、専用支払シーケンス、ソートコード、通貨、色）の編集
3. 仕訳帳タイプに応じた銀行口座の関連付け
4. 入金・出金に関するリレーションノートの編集
5. 詳細設定（許可勘定科目、自動チェック、請求書参照タイプ・モデル）の編集
6. 保存時のバリデーションとデータ更新処理

**画面遷移**：
- 遷移元：仕訳帳一覧画面、仕訳帳詳細画面
- 遷移先：保存成功時は仕訳帳詳細画面、ヘッダーの「表示」ボタンで仕訳帳詳細画面へ、「削除」ボタンで削除確認後に一覧画面へ

**権限による表示制御**：システムの権限設定に基づき、仕訳帳リソースへの編集権限を持つユーザーのみがこの画面にアクセス・操作可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-017 | 仕訳帳編集 | 主機能 | 仕訳帳データの更新処理 |
| FN-ACC-015 | 仕訳帳一覧 | 遷移元機能 | 一覧からの編集画面への遷移 |
| FN-ACC-016 | 仕訳帳作成 | 補助機能 | 類似のフォーム構造を共有 |

## 画面種別

編集

## URL/ルーティング

- パス: `/journals/{record}/edit`
- ルート名: `filament.accounts.resources.journals.edit`
- HTTPメソッド: GET（表示）, POST（更新）

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  [表示] [削除]                                                    |
+------------------------------------------------------------------+
| 3カラムレイアウト                                                  |
+----------------------------------+-------------------------------+
|                                  | 一般情報セクション              |
| タブパネル（2カラム幅）           |  - 名称 *                      |
|  ┌─────────────────────────────┐ |  - タイプ *                    |
|  │ 仕訳エントリ | 入金 | 出金 |  |  - 会社 *                      |
|  │ 詳細設定                    | +-------------------------------+
|  └─────────────────────────────┘ |                                 |
|                                  |                                 |
| [仕訳エントリ]タブ                |                                 |
|  会計情報フィールドセット          |                                 |
|   - 専用クレジットノートシーケンス |                                 |
|   - 専用支払シーケンス            |                                 |
|   - ソートコード                  |                                 |
|   - 通貨                          |                                 |
|   - 色                            |                                 |
|  銀行口座番号フィールドセット      |                                 |
|   - 銀行口座                      |                                 |
+----------------------------------+-------------------------------+
| フッター                                                          |
|  [保存] [キャンセル]                                              |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 備考 |
|--------|--------|--------|----------|------|------|
| 名称 | name | 入力 | string | ○ | 仕訳帳の名称 |
| タイプ | type | 入力 | enum | ○ | JournalType列挙型（sale, purchase, cash, bank, credit_card, general） |
| 会社 | company_id | 入力 | integer | ○ | 現在のユーザーのデフォルト会社で固定（disabled） |
| 専用クレジットノートシーケンス | refund_order | 入力 | boolean | - | タイプがsaleまたはpurchaseの場合のみ表示 |
| 専用支払シーケンス | payment_order | 入力 | boolean | - | タイプがbank, cash, credit_cardの場合のみ表示 |
| ソートコード | code | 入力 | string | - | 仕訳帳のソートコード |
| 通貨 | currency_id | 入力 | integer | - | 通貨マスタからの選択 |
| 色 | color | 入力 | string | - | 16進カラーコード |
| 銀行口座 | bank_account_id | 入力 | integer | - | タイプがbankの場合のみ表示 |
| リレーションノート | relation_notes | 入力 | text | - | 入金・出金タブで表示 |
| 許可勘定科目 | invoices_journal_accounts | 入力 | array | - | 複数選択可 |
| 自動チェック | auto_check_on_post | 入力 | boolean | - | 投稿時の自動チェック |
| 請求書参照タイプ | invoice_reference_type | 入力 | enum | - | タイプがsaleの場合のみ表示 |
| 請求書参照モデル | invoice_reference_model | 入力 | enum | - | タイプがsaleの場合のみ表示 |

## 表示項目

編集画面のため、入出力項目と同様です。フォームフィールドとして表示されます。

## イベント仕様

### 1-保存ボタン押下

**トリガー**: 保存ボタンのクリック

**処理フロー**:
1. フォームバリデーションの実行
2. `mutateFormDataBeforeSave`メソッドによるデータ変換
   - `creator_id`に現在のログインユーザーIDを設定
   - `invoice_reference_type`が未設定の場合、`CommunicationType::INVOICE`をデフォルト値として設定
   - `invoice_reference_model`が未設定の場合、`CommunicationStandard::AUREUS`をデフォルト値として設定
3. データベースへのUPDATE処理
4. 成功通知の表示
5. 仕訳帳詳細画面へのリダイレクト

### 2-削除ボタン押下

**トリガー**: ヘッダーの削除ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、該当レコードの削除処理
3. 一覧画面へのリダイレクト

### 3-表示ボタン押下

**トリガー**: ヘッダーの表示ボタンをクリック

**処理フロー**:
1. 仕訳帳詳細画面への遷移

### 4-タイプ変更

**トリガー**: タイプフィールドの値変更（Live/Reactive）

**処理フロー**:
1. タイプ値に基づいて関連フィールドの表示/非表示を切り替え
   - sale/purchase: 専用クレジットノートシーケンスを表示
   - bank/cash/credit_card: 専用支払シーケンス、入金/出金タブを表示
   - bank: 銀行口座フィールドセットを表示
   - sale: 請求書参照設定フィールドセットを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_journals | UPDATE | 仕訳帳情報の更新 |
| 保存ボタン押下 | accounts_journal_accounts | DELETE/INSERT | 許可勘定科目の関連更新 |
| 削除ボタン押下 | accounts_journals | DELETE | 仕訳帳の削除 |

### テーブル別更新項目詳細

#### accounts_journals

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | type | フォーム入力値 | 必須、JournalType列挙型 |
| UPDATE | code | フォーム入力値 | - |
| UPDATE | currency_id | フォーム入力値 | 通貨ID |
| UPDATE | color | フォーム入力値 | 16進カラーコード |
| UPDATE | bank_account_id | フォーム入力値 | タイプがbankの場合のみ |
| UPDATE | refund_order | フォーム入力値 | boolean |
| UPDATE | payment_order | フォーム入力値 | boolean |
| UPDATE | relation_notes | フォーム入力値 | - |
| UPDATE | auto_check_on_post | フォーム入力値 | boolean |
| UPDATE | invoice_reference_type | フォーム入力値またはデフォルト | CommunicationType列挙型 |
| UPDATE | invoice_reference_model | フォーム入力値またはデフォルト | CommunicationStandard列挙型 |
| UPDATE | creator_id | Auth::user()->id | ログインユーザーID |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 仕訳帳が正常に更新されました | 保存成功時 |
| notification.body | 成功 | 仕訳帳のデータが正常に保存されました | 保存成功時 |
| delete.notification.title | 成功 | 仕訳帳が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 仕訳帳のデータが正常に削除されました | 削除成功時 |
| validation.required | エラー | このフィールドは必須です | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面表示 | 指定された仕訳帳が見つかりません |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |
| バリデーションエラー | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |

## 備考

- 本画面はFilament PHPのEditRecordページクラスを継承して実装されています
- タイプフィールドはライブ（リアクティブ）設定されており、値変更時に関連フィールドの表示が動的に切り替わります
- 会社フィールドは現在のユーザーのデフォルト会社に固定され、変更不可（disabled）となっています
- 通貨と銀行口座は関連テーブルからの選択式で、検索可能・プリロード対応です
- タブはクエリストリングで永続化されます（persistTabInQueryString）
