# 画面設計書 310-価格設定

## 概要

本ドキュメントは、Aureus ERPシステムの販売モジュールにおける価格設定画面の設計仕様を記述したものです。

### 本画面の処理概要

本画面は、販売における価格関連の設定を管理するための画面です。

**業務上の目的・背景**：
販売業務において、割引やマージンの表示設定は、見積書や注文画面での操作性に影響を与えます。本画面は、販売価格に関する全社的な設定（割引機能の有効/無効、マージン表示の有効/無効）を一元管理することを目的としています。

**画面へのアクセス方法**：
サイドナビゲーションから「設定」モジュール → 「販売」グループ → 「価格設定」を選択してアクセスします。URLは `/settings/sale/manage-pricing` となります。

**主要な操作・処理内容**：
1. 割引機能の有効/無効の切り替え
2. マージン表示の有効/無効の切り替え
3. 設定の保存

**画面遷移**：
- この画面から遷移できる画面：なし（設定保存後も同じ画面に留まる）
- この画面に遷移してくる画面：設定一覧

**権限による表示制御**：
Filament Shieldによる権限管理（HasPageShield）が適用されており、設定変更権限がないユーザーはこの画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-039 | 価格設定 | 主機能 | 販売価格設定の管理 |

## 画面種別

設定（SettingsPage）

## URL/ルーティング

- URL: `/settings/sale/manage-pricing`
- ルート名: `filament.sales.pages.manage-pricing`
- コントローラ: `Webkul\Sale\Filament\Clusters\Settings\Pages\ManagePricing`

## 画面構成

1. **ヘッダー部**
   - パンくずリスト
   - 画面タイトル「価格設定」

2. **設定フォームエリア**
   - 割引設定トグル
   - マージン設定トグル

3. **フッター部**
   - 保存ボタン

## 入出力項目

| 項目名 | 型 | 必須 | デフォルト | 説明 | 備考 |
|--------|-----|------|----------|------|------|
| enable_discount | トグル | - | false | 割引機能の有効/無効 | ヘルパーテキスト付き |
| enable_margin | トグル | - | false | マージン表示の有効/無効 | ヘルパーテキスト付き |

## 表示項目

| 項目名 | 型 | 説明 | 備考 |
|--------|-----|------|------|
| enable_discount | トグル | 割引設定 | ラベルとヘルパーテキスト付き |
| enable_margin | トグル | マージン設定 | ラベルとヘルパーテキスト付き |

## イベント仕様

### 1-割引トグル変更

割引機能の有効/無効を切り替えます。有効にすると、見積書や注文画面で割引フィールドが表示されるようになります。

### 2-マージントグル変更

マージン表示の有効/無効を切り替えます。有効にすると、注文明細にマージン（原価との差額）が表示されるようになります。

### 3-保存ボタン押下

入力内容をsettingsテーブルに保存します。成功時は成功通知を表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新 |

### テーブル別更新項目詳細

#### settings（spatie/laravel-settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_discount | フォーム入力値（true/false） | グループ: sales_price |
| UPDATE | enable_margin | フォーム入力値（true/false） | グループ: sales_price |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| save.notification | 成功 | 設定が正常に保存されました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|---------|---------|-----------------|
| 権限不足 | HasPageShieldにより画面アクセス拒否 | 403エラーページへリダイレクト |
| 保存エラー | 処理中断 | エラーメッセージ表示 |

## 備考

- 本画面はFilamentのSettingsPageを継承しており、spatie/laravel-settingsパッケージと連携しています
- 設定クラスはPriceSettings（グループ: sales_price）を使用しています
- ナビゲーショングループは「Sales」で、Settings（設定）クラスターに属しています
- ナビゲーションソート順は2です
- パンくずリストは翻訳キー `sales::filament/clusters/settings/pages/manage-pricing.breadcrumb` で定義されています
- 各トグルにはヘルパーテキストが設定されており、設定の意味をユーザーに説明しています
- この設定は見積書作成画面や注文編集画面の表示内容に影響を与えます
