# 画面設計書 311-見積書・注文設定

## 概要

本ドキュメントは、Aureus ERPシステムにおける「見積書・注文設定」画面の設計仕様を定義します。この画面はシステム設定クラスターに属する設定画面であり、販売モジュールにおける見積書と注文に関するシステム全体の動作設定を管理します。

### 本画面の処理概要

**業務上の目的・背景**：見積書・注文設定画面は、販売業務における見積書の有効期限管理や受注確定後の編集制御など、業務プロセスに直接影響を与える重要な設定を一元管理するために必要です。この画面により、見積書の有効期限のデフォルト値設定や受注確定後のロック機能を適切に制御することで、組織のビジネスルールに沿った販売業務フローを実現できます。

**画面へのアクセス方法**：ダッシュボードのナビゲーションメニューから「設定」クラスターを選択し、「Sales」グループ内の「見積書・注文」を選択することでアクセスします。URL直接アクセスの場合は `/sale/manage-quotation-and-order` でアクセス可能です。

**主要な操作・処理内容**：
1. 見積書のデフォルト有効日数の設定（数値入力）
2. 受注確定後のロック機能の有効化・無効化（トグル操作）
3. 設定値の保存（保存ボタン押下）

**画面遷移**：この画面は設定クラスター内のスタンドアロン画面であり、主にナビゲーションメニューから直接アクセスします。設定保存後も同一画面に留まります。他の設定画面（商品設定、請求書設定、価格設定）とは同一クラスター内でナビゲーション可能です。

**権限による表示制御**：HasPageShieldトレイトによる権限制御が実装されており、適切な権限を持つユーザーのみがこの設定画面にアクセス・編集可能です。管理者権限または販売設定権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-QOS-001 | 見積有効日数設定 | 主機能 | デフォルト見積有効日数の設定・保存 |
| FN-SALES-QOS-002 | 受注ロック設定 | 主機能 | 受注確定後のロック機能切り替え |
| FN-SALES-001 | 見積一覧 | 遷移先機能 | 設定値が見積作成時に適用される |
| FN-SALES-011 | 注文一覧 | 遷移先機能 | ロック設定が受注編集に影響 |

## 画面種別

設定（Settings Page）

## URL/ルーティング

- **URL**: `/sale/manage-quotation-and-order`
- **ルート名**: `filament.pages.sale.manage-quotation-and-order`

## 画面構成

```
+--------------------------------------------------+
|  パンくずリスト                                    |
|  見積書・注文設定                                  |
+--------------------------------------------------+
|                                                  |
|  [見積書設定セクション]                            |
|  ┌──────────────────────────────────────────────┐|
|  │ デフォルト見積有効日数                          │|
|  │ [    30    ] 日                              │|
|  │ ヘルパーテキスト：見積書作成時のデフォルト...    │|
|  └──────────────────────────────────────────────┘|
|                                                  |
|  [受注設定セクション]                              |
|  ┌──────────────────────────────────────────────┐|
|  │ 受注確定後のロック                             │|
|  │ [トグルスイッチ]                               │|
|  │ ヘルパーテキスト：有効にすると受注確定後の...   │|
|  └──────────────────────────────────────────────┘|
|                                                  |
|              [保存ボタン]                         |
+--------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | 初期値 | 説明 |
|----|--------|--------|-----------|---------|------|-------|------|
| 1 | デフォルト見積有効日数 | default_quotation_validity | 入力 | integer | Yes | 30 | 見積書作成時のデフォルト有効日数（0以上） |
| 2 | 受注確定後のロック | enable_lock_confirm_sales | 入力 | boolean | No | false | 受注確定後の編集ロック機能の有効/無効 |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|---------|------|
| 1 | パンくずリスト | テキストリンク | 現在位置を示すナビゲーション |
| 2 | 画面タイトル | 見出し | 「見積書・注文設定」 |
| 3 | 有効日数フィールド | 数値入力（suffix: 「日」） | 数値入力ボックス |
| 4 | ロックトグル | スイッチ | ON/OFF切替スイッチ |
| 5 | ヘルパーテキスト | 小文字テキスト | 各項目の説明文 |

## イベント仕様

### 1-保存ボタン押下

- **トリガー**: 保存ボタンをクリック
- **処理内容**:
  1. 入力値のバリデーション実行（有効日数が0以上の数値かチェック）
  2. バリデーション成功時、QuotationAndOrderSettingsの値を更新
  3. 成功通知を表示
- **遷移先**: 同一画面（リフレッシュ）

### 2-有効日数入力

- **トリガー**: 数値入力欄への入力
- **バリデーション**:
  - 必須入力
  - 数値型
  - 最小値: 0

### 3-ロックトグル切替

- **トリガー**: トグルスイッチの切替操作
- **処理内容**: 即座には保存されず、保存ボタン押下時に反映

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新（spatie/laravel-settings使用） |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | group='sales_quotation_and_orders', name='default_quotation_validity' | フォーム入力値 | 見積有効日数 |
| UPDATE | group='sales_quotation_and_orders', name='enable_lock_confirm_sales' | フォーム入力値（true/false） | ロック設定 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | 設定が保存されました | 設定保存成功時 |
| 2 | エラー | 入力値を確認してください | バリデーションエラー時 |
| 3 | エラー | 保存に失敗しました | データベース更新失敗時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | データベースエラー | エラーログ出力、エラー通知表示 | 保存に失敗しました |
| 3 | 無効な数値入力 | バリデーションエラー表示 | 有効な数値を入力してください |

## 備考

- この設定画面はSpatie Laravel Settingsパッケージを使用して設定値を永続化しています
- 設定グループ名は「sales_quotation_and_orders」です
- HasPageShieldトレイトによりFilament Shieldの権限管理と統合されています
- ナビゲーションアイコンは「heroicon-o-shopping-cart」が使用されています
- ナビゲーショングループは「Sales」、ソート順は2番目に設定されています
