# 画面設計書 312-商品設定

## 概要

本ドキュメントは、Aureus ERPシステムにおける「商品設定」画面の設計仕様を定義します。この画面はシステム設定クラスターに属する設定画面であり、販売モジュールにおける商品管理機能の動作設定を管理します。

### 本画面の処理概要

**業務上の目的・背景**：商品設定画面は、販売業務における商品管理の高度な機能（バリエーション、単位、パッケージング）の有効化・無効化を制御するために必要です。この画面により、組織の商品管理ポリシーに応じて必要な機能のみを有効化し、ユーザーインターフェースの複雑さを適切に管理できます。シンプルな商品構成の場合は機能を無効化して操作を簡素化し、複雑な商品ラインナップを扱う場合はバリエーションやパッケージングを有効化できます。

**画面へのアクセス方法**：ダッシュボードのナビゲーションメニューから「設定」クラスターを選択し、「Sales」グループ内の「商品」を選択することでアクセスします。URL直接アクセスの場合は `/sale/manage-products` でアクセス可能です。

**主要な操作・処理内容**：
1. 商品バリエーション機能の有効化・無効化（トグル操作）
2. 単位（UoM）機能の有効化・無効化（トグル操作）
3. パッケージング機能の有効化・無効化（トグル操作）
4. 設定値の保存（保存ボタン押下）

**画面遷移**：この画面は設定クラスター内のスタンドアロン画面であり、主にナビゲーションメニューから直接アクセスします。設定保存後も同一画面に留まります。他の設定画面（見積書・注文設定、請求書設定、価格設定）とは同一クラスター内でナビゲーション可能です。

**権限による表示制御**：HasPageShieldトレイトによる権限制御が実装されており、適切な権限を持つユーザーのみがこの設定画面にアクセス・編集可能です。管理者権限または販売設定権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-PRD-001 | バリエーション設定 | 主機能 | 商品バリエーション機能の切り替え |
| FN-SALES-PRD-002 | 単位設定 | 主機能 | 単位（UoM）機能の切り替え |
| FN-SALES-PRD-003 | パッケージング設定 | 主機能 | パッケージング機能の切り替え |
| FN-SALES-021 | 商品一覧 | 遷移先機能 | 設定値が商品画面の表示に影響 |
| FN-PRD-011 | バリエーション管理 | 遷移先機能 | バリエーション設定で有効化/無効化 |

## 画面種別

設定（Settings Page）

## URL/ルーティング

- **URL**: `/sale/manage-products`
- **ルート名**: `filament.pages.sale.manage-products`

## 画面構成

```
+--------------------------------------------------+
|  パンくずリスト                                    |
|  商品設定                                          |
+--------------------------------------------------+
|                                                  |
|  [商品オプションセクション]                         |
|  ┌──────────────────────────────────────────────┐|
|  │ バリエーション                                  │|
|  │ [トグルスイッチ]                               │|
|  │ ヘルパーテキスト：商品にサイズや色などの...      │|
|  │                                              │|
|  │ 単位                                          │|
|  │ [トグルスイッチ]                               │|
|  │ ヘルパーテキスト：異なる単位での商品販売を...    │|
|  │                                              │|
|  │ パッケージング                                 │|
|  │ [トグルスイッチ]                               │|
|  │ ヘルパーテキスト：商品のパッケージング管理を...  │|
|  └──────────────────────────────────────────────┘|
|                                                  |
|              [保存ボタン]                         |
+--------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | 初期値 | 説明 |
|----|--------|--------|-----------|---------|------|-------|------|
| 1 | バリエーション | enable_variants | 入力 | boolean | No | false | 商品バリエーション機能の有効/無効 |
| 2 | 単位 | enable_uom | 入力 | boolean | No | false | 単位（UoM）機能の有効/無効 |
| 3 | パッケージング | enable_packagings | 入力 | boolean | No | false | パッケージング機能の有効/無効 |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|---------|------|
| 1 | パンくずリスト | テキストリンク | 現在位置を示すナビゲーション |
| 2 | 画面タイトル | 見出し | 「商品設定」 |
| 3 | バリエーショントグル | スイッチ | ON/OFF切替スイッチ |
| 4 | 単位トグル | スイッチ | ON/OFF切替スイッチ |
| 5 | パッケージングトグル | スイッチ | ON/OFF切替スイッチ |
| 6 | ヘルパーテキスト | 小文字テキスト | 各項目の説明文 |

## イベント仕様

### 1-保存ボタン押下

- **トリガー**: 保存ボタンをクリック
- **処理内容**:
  1. ProductSettingsの値を更新
  2. 成功通知を表示
- **遷移先**: 同一画面（リフレッシュ）

### 2-バリエーショントグル切替

- **トリガー**: トグルスイッチの切替操作
- **処理内容**: 即座には保存されず、保存ボタン押下時に反映
- **影響範囲**: 有効化時に商品画面でバリエーション管理機能が表示される

### 3-単位トグル切替

- **トリガー**: トグルスイッチの切替操作
- **処理内容**: 即座には保存されず、保存ボタン押下時に反映
- **影響範囲**: 有効化時に商品画面で単位選択が表示される

### 4-パッケージングトグル切替

- **トリガー**: トグルスイッチの切替操作
- **処理内容**: 即座には保存されず、保存ボタン押下時に反映
- **影響範囲**: 有効化時にパッケージング管理機能が利用可能になる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新（spatie/laravel-settings使用） |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | group='sales_product', name='enable_variants' | フォーム入力値（true/false） | バリエーション設定 |
| UPDATE | group='sales_product', name='enable_uom' | フォーム入力値（true/false） | 単位設定 |
| UPDATE | group='sales_product', name='enable_packagings' | フォーム入力値（true/false） | パッケージング設定 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | 設定が保存されました | 設定保存成功時 |
| 2 | エラー | 保存に失敗しました | データベース更新失敗時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | データベースエラー | エラーログ出力、エラー通知表示 | 保存に失敗しました |

## 備考

- この設定画面はSpatie Laravel Settingsパッケージを使用して設定値を永続化しています
- 設定グループ名は「sales_product」です
- HasPageShieldトレイトによりFilament Shieldの権限管理と統合されています
- ナビゲーションアイコンは「heroicon-o-cube」が使用されています
- ナビゲーショングループは「Sales」、ソート順は1番目に設定されています
- コード内にコメントアウトされた「enable_deliver_content_by_email」フィールドが存在しますが、現在は無効化されています
- ProductSettingsクラスには4つのプロパティ（enable_variants, enable_uom, enable_packagings, enable_deliver_content_by_email）が定義されていますが、UIでは3つのみ表示されます
