# 画面設計書 313-請求書設定

## 概要

本ドキュメントは、Aureus ERPシステムにおける「請求書設定」画面の設計仕様を定義します。この画面はシステム設定クラスターに属する設定画面であり、販売モジュールにおける請求書発行ポリシーの設定を管理します。

### 本画面の処理概要

**業務上の目的・背景**：請求書設定画面は、販売業務における請求書発行のタイミングを制御するために必要です。組織のビジネスモデルに応じて、注文時点で請求書を発行するか、商品の配送完了後に請求書を発行するかを選択できます。サービス業では注文時請求が適切な場合が多く、物販業では配送後請求が一般的です。この設定により、会計処理のタイミングと売上認識のルールを適切に管理できます。

**画面へのアクセス方法**：ダッシュボードのナビゲーションメニューから「設定」クラスターを選択し、「Sales」グループ内の「請求書」を選択することでアクセスします。URL直接アクセスの場合は `/sale/manage-invoicing` でアクセス可能です。

**主要な操作・処理内容**：
1. 請求ポリシーの選択（ラジオボタン操作）
   - 注文数量での請求
   - 配送数量での請求
2. 設定値の保存（保存ボタン押下）

**画面遷移**：この画面は設定クラスター内のスタンドアロン画面であり、主にナビゲーションメニューから直接アクセスします。設定保存後も同一画面に留まります。他の設定画面（見積書・注文設定、商品設定、価格設定）とは同一クラスター内でナビゲーション可能です。

**権限による表示制御**：HasPageShieldトレイトによる権限制御が実装されており、適切な権限を持つユーザーのみがこの設定画面にアクセス・編集可能です。管理者権限または販売設定権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SALES-INV-001 | 請求ポリシー設定 | 主機能 | 請求書発行タイミングの設定 |
| FN-SALES-009 | 請求書管理 | 遷移先機能 | 設定値が請求書発行処理に影響 |
| FN-SALES-015 | 配送管理 | 遷移先機能 | 配送完了後請求の場合に関連 |
| FN-ACC-001 | 請求書一覧 | 遷移先機能 | 発行された請求書の管理 |

## 画面種別

設定（Settings Page）

## URL/ルーティング

- **URL**: `/sale/manage-invoicing`
- **ルート名**: `filament.pages.sale.manage-invoicing`

## 画面構成

```
+--------------------------------------------------+
|  パンくずリスト                                    |
|  請求書設定                                        |
+--------------------------------------------------+
|                                                  |
|  [請求ポリシーセクション]                           |
|  ┌──────────────────────────────────────────────┐|
|  │ 請求ポリシー                                   │|
|  │ ( ) 注文数量で請求                             │|
|  │     受注時点の数量に基づいて請求書を発行        │|
|  │ (●) 配送数量で請求                             │|
|  │     配送完了数量に基づいて請求書を発行          │|
|  │                                              │|
|  │ ヘルパーテキスト：請求書発行のタイミングを...   │|
|  └──────────────────────────────────────────────┘|
|                                                  |
|              [保存ボタン]                         |
+--------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | 初期値 | 説明 |
|----|--------|--------|-----------|---------|------|-------|------|
| 1 | 請求ポリシー | invoice_policy | 入力 | InvoicePolicy(Enum) | Yes | delivery | 請求書発行タイミングの選択 |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|---------|------|
| 1 | パンくずリスト | テキストリンク | 現在位置を示すナビゲーション |
| 2 | 画面タイトル | 見出し | 「請求書設定」 |
| 3 | 請求ポリシーラジオ | ラジオボタングループ | 請求ポリシーの選択 |
| 4 | ヘルパーテキスト | 小文字テキスト | 設定の説明文 |

## 選択肢仕様

### 請求ポリシー（InvoicePolicy Enum）

| 値 | 表示ラベル | 説明 |
|----|----------|------|
| order | 注文数量で請求 | 受注時点の数量で請求書発行 |
| delivery | 配送数量で請求 | 配送完了数量で請求書発行（デフォルト） |

## イベント仕様

### 1-保存ボタン押下

- **トリガー**: 保存ボタンをクリック
- **処理内容**:
  1. 選択された請求ポリシーでInvoiceSettingsを更新
  2. 成功通知を表示
- **遷移先**: 同一画面（リフレッシュ）

### 2-請求ポリシー選択

- **トリガー**: ラジオボタンの選択変更
- **処理内容**: 即座には保存されず、保存ボタン押下時に反映
- **影響範囲**: 販売注文からの請求書発行処理に影響

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新（spatie/laravel-settings使用） |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | group='sales_invoicing', name='invoice_policy' | フォーム入力値（order/delivery） | InvoicePolicy Enum値 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | 設定が保存されました | 設定保存成功時 |
| 2 | エラー | 保存に失敗しました | データベース更新失敗時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | データベースエラー | エラーログ出力、エラー通知表示 | 保存に失敗しました |
| 3 | 無効なEnum値 | バリデーションエラー | 有効な選択肢を選んでください |

## 備考

- この設定画面はSpatie Laravel Settingsパッケージを使用して設定値を永続化しています
- 設定グループ名は「sales_invoicing」です
- HasPageShieldトレイトによりFilament Shieldの権限管理と統合されています
- ナビゲーションアイコンは「heroicon-o-document-text」が使用されています
- ナビゲーショングループは「Sales」、ソート順は2番目に設定されています
- 請求ポリシーはWebkul\Invoice\Enums\InvoicePolicyというEnumクラスで定義されています
- デフォルト値は「delivery」（配送数量での請求）に設定されています
