# 画面設計書 314-ユーザー一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ユーザー一覧」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、システムにアクセスするユーザーの一覧表示、検索、フィルタリング、およびユーザー管理操作を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー一覧画面は、システム管理者がERPシステムにアクセスするユーザーを効率的に管理するために必要です。この画面により、全ユーザーの概要把握、新規ユーザーの追加、既存ユーザーの編集・削除、ユーザー招待メール送信など、包括的なユーザー管理機能を提供します。マルチテナント環境での会社別ユーザー管理やロールベースのアクセス制御もこの画面から管理できます。

**画面へのアクセス方法**：ダッシュボードのナビゲーションメニューから「セキュリティ」グループ内の「ユーザー」を選択することでアクセスします。URL直接アクセスの場合は `/users` でアクセス可能です。

**主要な操作・処理内容**：
1. ユーザー一覧の表示（ページネーション付き）
2. ユーザーの検索（名前、メールアドレス）
3. フィルタリング（権限タイプ、会社、チーム、ロール）
4. 新規ユーザー作成画面への遷移
5. ユーザー招待メール送信
6. 個別ユーザーの表示・編集・削除
7. 一括削除・復元操作
8. アーカイブ済みユーザーの表示切替

**画面遷移**：
- 一覧画面 → 作成画面（新規ユーザー作成ボタン押下）
- 一覧画面 → 詳細画面（レコードクリック）
- 一覧画面 → 編集画面（編集アクションクリック）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ユーザー管理権限を持つユーザーのみがアクセス可能です。デフォルトユーザー（is_default=true）は削除できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-001 | ユーザー一覧 | 主機能 | ユーザーデータの一覧表示と検索 |
| FN-SEC-002 | ユーザー作成 | 遷移先機能 | 新規ユーザー作成画面への遷移 |
| FN-SEC-003 | ユーザー編集 | 遷移先機能 | ユーザー編集画面への遷移 |
| FN-SEC-004 | ユーザー表示 | 遷移先機能 | ユーザー詳細画面への遷移 |
| FN-SEC-005 | ユーザー削除 | 主機能 | 個別ユーザーの削除 |
| FN-SEC-006 | 一括削除 | 主機能 | 複数ユーザーの一括削除 |
| FN-SEC-007 | 復元 | 主機能 | 削除済みユーザーの復元 |
| FN-SEC-008 | 完全削除 | 主機能 | ユーザーの完全削除 |
| FN-SEC-INV | ユーザー招待 | 主機能 | メールによるユーザー招待 |

## 画面種別

一覧（List）

## URL/ルーティング

- **URL**: `/users`
- **ルート名**: `filament.resources.users.index`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ユーザー                                      [新規作成] [招待]   |
+------------------------------------------------------------------+
|  タブ: [すべて (123)] [アーカイブ済み (5)]                          |
+------------------------------------------------------------------+
|  [検索ボックス]                         [フィルター] [カラム管理]    |
+------------------------------------------------------------------+
|  | □ | アバター | 名前 | メール | チーム | ロール | 権限 | 会社 |   |
|  |---|---------|------|-------|-------|-------|------|-----|---|
|  | □ | [img]   | 山田 | a@b.c | 開発  | Admin | 全体 | ABC |...|
|  | □ | [img]   | 鈴木 | d@e.f | 営業  | User  | 個人 | XYZ |...|
|  |   |    ...    |                                              |
+------------------------------------------------------------------+
|  一括操作: [削除] [完全削除] [復元]                                  |
+------------------------------------------------------------------+
|  ページネーション: < 1 2 3 ... >                                   |
+------------------------------------------------------------------+
```

## 表示項目

| No | 項目名 | 項目ID | 表示形式 | ソート | 検索 | 説明 |
|----|--------|--------|---------|-------|------|------|
| 1 | アバター | partner.avatar | 画像（50px） | - | - | ユーザーのプロフィール画像 |
| 2 | 名前 | name | テキスト（50文字制限） | ○ | ○ | ユーザー名 |
| 3 | メール | email | テキスト | ○ | ○ | メールアドレス |
| 4 | チーム | teams.name | バッジ（複数行） | - | - | 所属チーム |
| 5 | ロール | roles.name | テキスト | ○ | - | 割り当てられたロール |
| 6 | リソース権限 | resource_permission | テキスト | ○ | - | 権限タイプ（全体/個人/グループ） |
| 7 | デフォルト会社 | defaultCompany.name | テキスト | ○ | - | デフォルトの所属会社 |
| 8 | 許可された会社 | allowedCompanies.name | バッジ（複数行） | - | - | アクセス可能な会社 |
| 9 | 作成日時 | created_at | 日時 | ○ | - | 初期非表示 |
| 10 | 更新日時 | updated_at | 日時 | ○ | - | 初期非表示 |

## フィルタ仕様

| No | フィルタ名 | 項目ID | フィルタ種別 | 複数選択 |
|----|-----------|--------|-------------|---------|
| 1 | リソース権限 | resource_permission | セレクト | No |
| 2 | デフォルト会社 | default_company | リレーション | No |
| 3 | 許可された会社 | allowed_companies | リレーション | Yes |
| 4 | チーム | teams | リレーション | Yes |
| 5 | ロール | roles | リレーション | Yes |

## タブ仕様

| タブ名 | フィルタ条件 | バッジ表示 |
|-------|------------|----------|
| すべて | deleted_at IS NULL | 総ユーザー数 |
| アーカイブ済み | deleted_at IS NOT NULL | アーカイブ済みユーザー数 |

## イベント仕様

### 1-新規作成ボタン押下

- **トリガー**: ヘッダーの新規作成ボタンをクリック
- **処理内容**: ユーザー作成画面へ遷移
- **遷移先**: `/users/create`

### 2-ユーザー招待ボタン押下

- **トリガー**: ヘッダーの招待ボタンをクリック（設定で有効化されている場合のみ表示）
- **処理内容**:
  1. モーダルダイアログを表示
  2. メールアドレス入力を受付
  3. 招待メール送信処理を実行
- **条件**: UserSettings.enable_user_invitation が true の場合のみ表示

### 3-レコードクリック（表示）

- **トリガー**: テーブル行のViewアクションをクリック
- **処理内容**: ユーザー詳細画面へ遷移
- **遷移先**: `/users/{id}`

### 4-編集アクション

- **トリガー**: 行メニューの編集アクションをクリック
- **処理内容**: ユーザー編集画面へ遷移
- **遷移先**: `/users/{id}/edit`

### 5-削除アクション

- **トリガー**: 行メニューの削除アクションをクリック
- **処理内容**: 確認後、ユーザーをソフトデリート
- **条件**: デフォルトユーザー（is_default=true）以外のみ削除可能

### 6-復元アクション

- **トリガー**: アーカイブタブで復元アクションをクリック
- **処理内容**: ソフトデリートされたユーザーを復元

### 7-一括削除

- **トリガー**: チェックボックスで選択後、一括削除アクションを実行
- **処理内容**: 選択されたユーザーをソフトデリート
- **条件**: デフォルトユーザーは選択不可

### 8-完全削除

- **トリガー**: 一括完全削除アクションを実行
- **処理内容**: 選択されたユーザーを物理削除
- **注意**: 関連データがある場合はエラー

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | users | UPDATE | deleted_atを現在時刻に更新（ソフトデリート） |
| 復元アクション | users | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | users | DELETE | レコードの物理削除 |
| ユーザー招待 | invitations | INSERT | 招待レコードの作成 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在時刻 | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | id = 対象ユーザーID | 物理削除 |

#### invitations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | email | フォーム入力値 | 招待メールアドレス |
| INSERT | created_at | 現在時刻 | 作成日時 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | ユーザーを編集しました | 編集成功時 |
| 2 | 成功 | ユーザーを削除しました | 削除成功時 |
| 3 | 成功 | ユーザーを復元しました | 復元成功時 |
| 4 | 成功 | ユーザーを完全に削除しました | 完全削除成功時 |
| 5 | 成功 | 招待メールを送信しました | 招待メール送信成功時 |
| 6 | エラー | デフォルト会社が設定されていません | 招待時にデフォルト会社未設定 |
| 7 | エラー | 招待メールの送信に失敗しました | メール送信失敗時 |
| 8 | エラー | このユーザーは削除できません | デフォルトユーザー削除試行時 |
| 9 | エラー | 関連データがあるため削除できません | 完全削除時に外部キー制約エラー |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | デフォルトユーザー削除 | 削除アクションを非表示/無効化 | - |
| 3 | 外部キー制約違反 | エラーログ出力、エラー通知表示 | 関連データがあるため削除できません |
| 4 | メール送信失敗 | 例外をログ出力、エラー通知表示 | 招待メールの送信に失敗しました |

## 備考

- ユーザーモデルはソフトデリートに対応しており、削除済みユーザーは「アーカイブ済み」タブで確認可能
- グローバル検索で名前とメールアドレスでの検索が可能
- テーブルはカラムの順序変更（reorderableColumns）に対応
- カラムマネージャーで表示カラムをカスタマイズ可能（columnManagerColumns: 2）
- デフォルトソートはcreated_atの降順
- ユーザー招待機能はUserSettings.enable_user_invitationで制御
- リソース権限はPermissionType Enumで定義（GLOBAL/INDIVIDUAL/GROUP）
