# 画面設計書 315-ユーザー作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ユーザー作成」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、新規ユーザーの登録機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー作成画面は、システム管理者が新規ユーザーを登録するために必要です。この画面により、ユーザーの基本情報（名前、メールアドレス、パスワード）、権限設定（ロール、チーム、リソース権限）、マルチカンパニー設定（所属会社、デフォルト会社）を一括で設定し、新規ユーザーアカウントを作成できます。アバター画像のアップロードや言語設定も可能です。

**画面へのアクセス方法**：ユーザー一覧画面の「新規作成」ボタンをクリック、またはURL直接アクセス（`/users/create`）でアクセス可能です。

**主要な操作・処理内容**：
1. 基本情報の入力（名前、メール、パスワード）
2. 権限の設定（ロール選択、チーム選択、リソース権限）
3. アバター画像のアップロード
4. 言語・ステータスの設定
5. マルチカンパニー設定（許可会社、デフォルト会社）
6. ユーザー登録の実行

**画面遷移**：
- 一覧画面 → 作成画面（新規作成ボタン押下）
- 作成画面 → 詳細画面（登録成功後に自動遷移）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ユーザー作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-002 | ユーザー作成 | 主機能 | 新規ユーザーの登録処理 |
| FN-SEC-001 | ユーザー一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-SEC-004 | ユーザー表示 | 遷移先機能 | 登録成功後の遷移先 |

## 画面種別

作成（Create）

## URL/ルーティング

- **URL**: `/users/create`
- **ルート名**: `filament.resources.users.create`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ユーザー作成                                                      |
+------------------------------------------------------------------+
|  +------------------------+  +------------------------------+     |
|  | 基本情報               |  | アバター                     |     |
|  | ┌────────────────────┐|  | ┌──────────────────────────┐|     |
|  | │ 名前 *              │|  | │ [画像アップロード]        │|     |
|  | │ [________________]  │|  | └──────────────────────────┘|     |
|  | │ メール *            │|  +------------------------------+     |
|  | │ [________________]  │|  | 言語・ステータス             |     |
|  | │ パスワード *        │|  | ┌──────────────────────────┐|     |
|  | │ [________________]  │|  | │ 言語: [English ▼]        │|     |
|  | │ パスワード確認 *    │|  | │ ステータス: [ON/OFF]      │|     |
|  | │ [________________]  │|  | └──────────────────────────┘|     |
|  | └────────────────────┘|  +------------------------------+     |
|  +------------------------+  | マルチカンパニー             |     |
|  | 権限                   |  | ┌──────────────────────────┐|     |
|  | ┌────────────────────┐|  | │ 許可会社: [複数選択 ▼]    │|     |
|  | │ ロール: [複数選択▼]│|  | │ デフォルト会社 *: [選択▼] │|     |
|  | │ 権限: [選択 ▼]     │|  | └──────────────────────────┘|     |
|  | │ チーム: [複数選択▼]│|  +------------------------------+     |
|  | └────────────────────┘|                                       |
|  +------------------------+                                       |
+------------------------------------------------------------------+
|                                [キャンセル] [作成]                 |
+------------------------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | 初期値 | バリデーション |
|----|--------|--------|-----------|---------|------|-------|---------------|
| 1 | 名前 | name | 入力 | string | Yes | - | 最大255文字 |
| 2 | メール | email | 入力 | string | Yes | - | メール形式、一意、最大255文字 |
| 3 | パスワード | password | 入力 | string | Yes | - | 最小8文字、最大255文字 |
| 4 | パスワード確認 | password_confirmation | 入力 | string | Yes | - | passwordと一致 |
| 5 | ロール | roles | 入力 | array | No | - | 複数選択可 |
| 6 | リソース権限 | resource_permission | 入力 | PermissionType | Yes | - | PermissionType Enum |
| 7 | チーム | teams | 入力 | array | No | - | 複数選択可 |
| 8 | アバター | avatar | 入力 | image | No | - | 画像ファイル |
| 9 | 言語 | language | 入力 | string | No | - | 現在はEnglishのみ |
| 10 | ステータス | is_active | 入力 | boolean | No | true | - |
| 11 | 許可会社 | allowed_companies | 入力 | array | No | - | 複数選択可 |
| 12 | デフォルト会社 | default_company_id | 入力 | integer | Yes | - | 会社マスタから選択 |

## イベント仕様

### 1-作成ボタン押下

- **トリガー**: フォームの作成ボタンをクリック
- **処理内容**:
  1. 入力値のバリデーション実行
  2. バリデーション成功時、ユーザーレコードを作成
  3. パートナーレコードを作成（アバター保存）
  4. ロール・チーム・会社の関連付け
  5. 成功通知を表示
  6. ユーザー詳細画面へリダイレクト
- **遷移先**: `/users/{id}`

### 2-キャンセルボタン押下

- **トリガー**: キャンセルボタンをクリック
- **処理内容**: ユーザー一覧画面へ戻る
- **遷移先**: `/users`

### 3-会社作成アクション

- **トリガー**: デフォルト会社選択でインラインの「新規作成」をクリック
- **処理内容**: モーダルで会社作成フォームを表示
- **備考**: CompanyResourceのフォームを使用

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | users | INSERT | ユーザーレコード作成 |
| 作成ボタン押下 | partners | INSERT | パートナーレコード作成（アバター保存） |
| 作成ボタン押下 | model_has_roles | INSERT | ロール割当 |
| 作成ボタン押下 | team_user | INSERT | チーム割当 |
| 作成ボタン押下 | company_user | INSERT | 許可会社割当 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ユーザー名 |
| INSERT | email | フォーム入力値 | メールアドレス |
| INSERT | password | bcryptハッシュ化された値 | パスワード |
| INSERT | resource_permission | フォーム入力値 | 権限タイプ |
| INSERT | default_company_id | フォーム入力値 | デフォルト会社ID |
| INSERT | language | フォーム入力値 | 言語コード |
| INSERT | is_active | フォーム入力値 | アクティブ状態 |
| INSERT | created_at | 現在時刻 | 作成日時 |
| INSERT | updated_at | 現在時刻 | 更新日時 |

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | avatar | アップロードファイルパス | アバター画像 |
| INSERT | user_id | 作成されたユーザーID | ユーザー関連 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | ユーザーが正常に作成されました | 登録成功時 |
| 2 | エラー | このメールアドレスは既に使用されています | メール重複時 |
| 3 | エラー | パスワードが一致しません | パスワード確認不一致時 |
| 4 | エラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | メール重複 | バリデーションエラー表示 | このメールアドレスは既に使用されています |
| 3 | パスワード要件不足 | バリデーションエラー表示 | パスワードは8文字以上必要です |
| 4 | データベースエラー | エラーログ出力、エラー通知表示 | 登録に失敗しました |

## 備考

- 作成成功後は自動的にユーザー詳細画面（View）へリダイレクトされます
- パスワードフィールドは作成画面でのみ表示され、編集画面では非表示です
- アバター画像は`users/avatars`ディレクトリに保存されます
- 画像はリサイズモード「cover」で処理され、画像エディタが利用可能です
- リソース権限はPermissionType Enum（GLOBAL/INDIVIDUAL/GROUP）から選択
- デフォルト会社選択では削除済み会社も表示されますが、選択は無効化されています
- ユーザー作成時にログインユーザーのIDがuser_idとしてセットされます（会社作成時）
