# 画面設計書 316-ユーザー編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ユーザー編集」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、既存ユーザーの情報更新機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー編集画面は、システム管理者が既存ユーザーの情報を更新するために必要です。この画面により、ユーザーの基本情報（名前、メールアドレス）、権限設定（ロール、チーム、リソース権限）、マルチカンパニー設定（所属会社、デフォルト会社）の変更が可能です。パスワード変更機能は別途ヘッダーアクションとして提供されており、セキュリティを考慮した設計になっています。

**画面へのアクセス方法**：ユーザー一覧画面または詳細画面から「編集」ボタンをクリック、またはURL直接アクセス（`/users/{id}/edit`）でアクセス可能です。

**主要な操作・処理内容**：
1. 基本情報の変更（名前、メール）
2. 権限の変更（ロール、チーム、リソース権限）
3. アバター画像の変更
4. 言語・ステータスの変更
5. マルチカンパニー設定の変更
6. パスワード変更（ヘッダーアクション）
7. ユーザー削除（ヘッダーアクション）

**画面遷移**：
- 一覧画面/詳細画面 → 編集画面
- 編集画面 → 詳細画面（更新成功後に自動遷移）
- 編集画面 → 詳細画面（Viewアクションクリック）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ユーザー編集権限を持つユーザーのみがアクセス可能です。パスワード変更機能はUserSettings.enable_reset_passwordで制御されます。デフォルトユーザー（is_default=true）は削除できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-003 | ユーザー編集 | 主機能 | ユーザー情報の更新処理 |
| FN-SEC-001 | ユーザー一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-SEC-004 | ユーザー表示 | 遷移先機能 | 更新成功後の遷移先 |
| FN-SEC-005 | ユーザー削除 | 補助機能 | ヘッダーからの削除操作 |
| FN-SEC-PWD | パスワード変更 | 補助機能 | パスワードリセット機能 |

## 画面種別

編集（Edit）

## URL/ルーティング

- **URL**: `/users/{record}/edit`
- **ルート名**: `filament.resources.users.edit`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ユーザー編集            [パスワード変更] [表示] [削除]              |
+------------------------------------------------------------------+
|  +------------------------+  +------------------------------+     |
|  | 基本情報               |  | アバター                     |     |
|  | ┌────────────────────┐|  | ┌──────────────────────────┐|     |
|  | │ 名前 *              │|  | │ [現在の画像/アップロード]  │|     |
|  | │ [山田太郎_________] │|  | └──────────────────────────┘|     |
|  | │ メール *            │|  +------------------------------+     |
|  | │ [yamada@example.com]│|  | 言語・ステータス             |     |
|  | │                     │|  | ┌──────────────────────────┐|     |
|  | │ ※パスワードは非表示  │|  | │ 言語: [English ▼]        │|     |
|  | │                     │|  | │ ステータス: [ON]          │|     |
|  | └────────────────────┘|  | └──────────────────────────┘|     |
|  +------------------------+  +------------------------------+     |
|  | 権限                   |  | マルチカンパニー             |     |
|  | ┌────────────────────┐|  | ┌──────────────────────────┐|     |
|  | │ ロール: [Admin ▼]   │|  | │ 許可会社: [ABC, XYZ]      │|     |
|  | │ 権限: [全体 ▼]      │|  | │ デフォルト会社: [ABC ▼]   │|     |
|  | │ チーム: [開発 ▼]    │|  | └──────────────────────────┘|     |
|  | └────────────────────┘|  +------------------------------+     |
|  +------------------------+                                       |
+------------------------------------------------------------------+
|                                [キャンセル] [保存]                 |
+------------------------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | バリデーション |
|----|--------|--------|-----------|---------|------|---------------|
| 1 | 名前 | name | 入力 | string | Yes | 最大255文字 |
| 2 | メール | email | 入力 | string | Yes | メール形式、一意（自レコード除外）、最大255文字 |
| 3 | ロール | roles | 入力 | array | No | 複数選択可 |
| 4 | リソース権限 | resource_permission | 入力 | PermissionType | Yes | PermissionType Enum |
| 5 | チーム | teams | 入力 | array | No | 複数選択可 |
| 6 | アバター | avatar | 入力 | image | No | 画像ファイル |
| 7 | 言語 | language | 入力 | string | No | - |
| 8 | ステータス | is_active | 入力 | boolean | No | - |
| 9 | 許可会社 | allowed_companies | 入力 | array | No | 複数選択可 |
| 10 | デフォルト会社 | default_company_id | 入力 | integer | Yes | 会社マスタから選択 |

## ヘッダーアクション

| No | アクション名 | アイコン | 表示条件 | 説明 |
|----|------------|---------|---------|------|
| 1 | パスワード変更 | heroicon-o-key | enable_reset_password=true | パスワード変更モーダル表示 |
| 2 | 表示 | - | 常時 | 詳細画面へ遷移 |
| 3 | 削除 | - | is_default=false | ユーザーの削除 |

## イベント仕様

### 1-保存ボタン押下

- **トリガー**: フォームの保存ボタンをクリック
- **処理内容**:
  1. 入力値のバリデーション実行
  2. バリデーション成功時、ユーザーレコードを更新
  3. パートナーレコードを更新（アバター更新）
  4. ロール・チーム・会社の関連付けを更新
  5. 成功通知を表示
  6. ユーザー詳細画面へリダイレクト
- **遷移先**: `/users/{id}`

### 2-パスワード変更アクション

- **トリガー**: ヘッダーのパスワード変更ボタンをクリック
- **処理内容**:
  1. モーダルダイアログを表示
  2. 新しいパスワードと確認入力を受付
  3. パスワードをbcryptハッシュ化して更新
  4. 成功通知を表示
- **バリデーション**: Laravel標準のパスワードルール

### 3-削除アクション

- **トリガー**: ヘッダーの削除ボタンをクリック
- **処理内容**: 確認後、ユーザーをソフトデリート
- **条件**: デフォルトユーザー（is_default=true）の場合は非表示
- **遷移先**: `/users`（一覧画面）

### 4-表示アクション

- **トリガー**: ヘッダーの表示ボタンをクリック
- **処理内容**: ユーザー詳細画面へ遷移
- **遷移先**: `/users/{id}`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | users | UPDATE | ユーザーレコード更新 |
| 保存ボタン押下 | partners | UPDATE | パートナーレコード更新（アバター） |
| 保存ボタン押下 | model_has_roles | DELETE/INSERT | ロール割当更新 |
| 保存ボタン押下 | team_user | DELETE/INSERT | チーム割当更新 |
| 保存ボタン押下 | company_user | DELETE/INSERT | 許可会社割当更新 |
| パスワード変更 | users | UPDATE | パスワードフィールド更新 |
| 削除アクション | users | UPDATE | deleted_atを更新（ソフトデリート） |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | ユーザー名 |
| UPDATE | email | フォーム入力値 | メールアドレス |
| UPDATE | password | bcryptハッシュ化された値 | パスワード変更時のみ |
| UPDATE | resource_permission | フォーム入力値 | 権限タイプ |
| UPDATE | default_company_id | フォーム入力値 | デフォルト会社ID |
| UPDATE | language | フォーム入力値 | 言語コード |
| UPDATE | is_active | フォーム入力値 | アクティブ状態 |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------|
| 1 | 成功 | ユーザーが正常に更新されました | 更新成功時 |
| 2 | 成功 | パスワードが正常に変更されました | パスワード変更成功時 |
| 3 | 成功 | ユーザーが正常に削除されました | 削除成功時 |
| 4 | エラー | このメールアドレスは既に使用されています | メール重複時 |
| 5 | エラー | パスワードが一致しません | パスワード確認不一致時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | メール重複 | バリデーションエラー表示 | このメールアドレスは既に使用されています |
| 3 | デフォルトユーザー削除 | 削除アクションを非表示 | - |
| 4 | データベースエラー | エラーログ出力、エラー通知表示 | 更新に失敗しました |

## 備考

- 編集画面ではパスワードフィールドは表示されません（hiddenOn('edit')）
- パスワード変更は別途ヘッダーアクションとして提供されます
- パスワード変更機能の表示はUserSettings.enable_reset_passwordで制御されます
- mutateFormDataBeforeFillでパートナー情報がフォームにマージされます
- 更新成功後は自動的にユーザー詳細画面（View）へリダイレクトされます
- デフォルトユーザーは削除アクションが非表示になります
