# 画面設計書 317-ユーザー詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ユーザー詳細」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、ユーザー情報の詳細表示機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー詳細画面は、システム管理者が登録済みユーザーの詳細情報を確認するために必要です。この画面により、ユーザーの基本情報（名前、メールアドレス）、権限設定（ロール、チーム、リソース権限）、マルチカンパニー設定（所属会社、デフォルト会社）、アバター画像、ステータスを一覧表示形式で確認できます。

**画面へのアクセス方法**：ユーザー一覧画面からレコードをクリック、または「表示」アクションを選択、あるいはURL直接アクセス（`/users/{id}`）でアクセス可能です。

**主要な操作・処理内容**：
1. ユーザー基本情報の確認（名前、メール、言語）
2. 権限情報の確認（ロール、チーム、リソース権限）
3. アバター画像の確認
4. マルチカンパニー設定の確認（許可会社、デフォルト会社）
5. ステータスの確認
6. 編集画面への遷移（ヘッダーアクション）
7. ユーザー削除（ヘッダーアクション）

**画面遷移**：
- 一覧画面 → 詳細画面（レコードクリック/表示アクション）
- 詳細画面 → 編集画面（編集アクションクリック）
- 詳細画面 → 一覧画面（削除実行後）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ユーザー表示権限を持つユーザーのみがアクセス可能です。デフォルトユーザー（is_default=true）は削除できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-004 | ユーザー表示 | 主機能 | ユーザー詳細情報の表示 |
| FN-SEC-001 | ユーザー一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-SEC-003 | ユーザー編集 | 遷移先機能 | 編集アクションからの遷移 |
| FN-SEC-005 | ユーザー削除 | 補助機能 | ヘッダーからの削除操作 |

## 画面種別

詳細（View）

## URL/ルーティング

- **URL**: `/users/{record}`
- **ルート名**: `filament.resources.users.view`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ユーザー詳細                               [編集] [削除]           |
+------------------------------------------------------------------+
|  +------------------------------------------+  +----------------+ |
|  | 基本情報                                 |  | アバター       | |
|  | ┌──────────────────────────────────────┐|  | ┌────────────┐| |
|  | │ [user] 名前: 山田太郎                 │|  | │ [画像]     │| |
|  | │ [mail] メール: yamada@example.com    │|  | └────────────┘| |
|  | │ [lang] 言語: English                 │|  +----------------+ |
|  | └──────────────────────────────────────┘|  | マルチカンパニー| |
|  +------------------------------------------+  | ┌────────────┐| |
|  | 権限                                     |  | │ [bldg] 許可:│| |
|  | ┌──────────────────────────────────────┐|  | │ ・ABC Corp │| |
|  | │ [key] ロール:                         │|  | │ ・XYZ Inc  │| |
|  | │   ・Admin                             │|  | │ [bldg] デフォルト:│
|  | │   ・Manager                           │|  | │ ABC Corp   │| |
|  | │ [group] チーム:                       │|  | └────────────┘| |
|  | │   ・開発チーム                        │|  +----------------+ |
|  | │   ・営業チーム                        │|  | ステータス     | |
|  | │ [globe] リソース権限: 全体            │|  | ┌────────────┐| |
|  | └──────────────────────────────────────┘|  | │ [check] ON │| |
|  +------------------------------------------+  | └────────────┘| |
|                                                +----------------+ |
+------------------------------------------------------------------+
```

## 表示項目

| No | 項目名 | 項目ID | データ型 | アイコン | 説明 |
|----|--------|--------|---------|---------|------|
| 1 | 名前 | name | string | heroicon-o-user | ユーザー名 |
| 2 | メール | email | string | heroicon-o-envelope | メールアドレス |
| 3 | 言語 | language | string | heroicon-o-language | 使用言語 |
| 4 | ロール | roles.name | array | heroicon-o-key | 割り当てられたロール一覧 |
| 5 | チーム | teams.name | array | heroicon-o-user-group | 所属チーム一覧 |
| 6 | リソース権限 | resource_permission | PermissionType | 動的アイコン | 権限タイプ |
| 7 | アバター | partner.avatar | image | - | プロフィール画像（円形表示） |
| 8 | 許可会社 | allowedCompanies.name | array | heroicon-o-building-office | アクセス可能な会社一覧 |
| 9 | デフォルト会社 | defaultCompany.name | string | heroicon-o-building-office-2 | デフォルト会社 |
| 10 | ステータス | is_active | boolean | - | アクティブ状態（アイコン表示） |

## リソース権限の動的アイコン

| 権限タイプ | アイコン |
|-----------|---------|
| GLOBAL | heroicon-o-globe-alt |
| INDIVIDUAL | heroicon-o-user |
| GROUP | heroicon-o-user-group |

## ヘッダーアクション

| No | アクション名 | 表示条件 | 説明 |
|----|------------|---------|------|
| 1 | 編集 | 常時 | 編集画面へ遷移 |
| 2 | 削除 | is_default=false | ユーザーの削除 |

## イベント仕様

### 1-編集アクション

- **トリガー**: ヘッダーの編集ボタンをクリック
- **処理内容**: ユーザー編集画面へ遷移
- **遷移先**: `/users/{id}/edit`

### 2-削除アクション

- **トリガー**: ヘッダーの削除ボタンをクリック
- **処理内容**:
  1. 確認ダイアログを表示
  2. 確認後、ユーザーをソフトデリート
  3. 成功通知を表示
- **条件**: デフォルトユーザー（is_default=true）の場合は非表示
- **遷移先**: `/users`（一覧画面）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | users | UPDATE | deleted_atを更新（ソフトデリート） |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在時刻 | ソフトデリート |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------:|
| 1 | 成功 | ユーザーが正常に削除されました | 削除成功時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | レコード未存在 | 404エラーページを表示 | ユーザーが見つかりません |
| 3 | デフォルトユーザー削除 | 削除アクションを非表示 | - |

## 画面レイアウト詳細

### セクション構成

1. **基本情報セクション**（左側、2カラム幅）
   - 名前、メール、言語を表示
   - 2カラムレイアウト

2. **権限セクション**（左側、2カラム幅）
   - ロール、チーム、リソース権限を表示
   - 箇条書き形式で一覧表示
   - 2カラムレイアウト

3. **アバターセクション**（右側、1カラム幅）
   - プロフィール画像を円形で表示

4. **マルチカンパニーセクション**（右側、1カラム幅）
   - 許可会社を箇条書きで表示
   - デフォルト会社を表示

5. **ステータスセクション**（右側、1カラム幅）
   - アクティブ状態をアイコンで表示（boolean型）

## 備考

- ViewRecordを継承した詳細表示画面です
- Infolistを使用してデータを表示しています
- ロール名は先頭文字が大文字に変換されて表示されます
- リソース権限の表示値はPermissionType Enumのoptions()から取得されます
- アバター画像は円形（circular）で表示されます
- 値が空の場合は「-」がプレースホルダーとして表示されます
- 削除アクションはcanDeleteUserメソッドでis_defaultフラグをチェックして制御されます
