# 画面設計書 318-ロール一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ロール一覧」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、システムのロール（役割）を一覧表示・管理する機能を提供します。Filament Shieldパッケージを拡張して実装されています。

### 本画面の処理概要

**業務上の目的・背景**：ロール一覧画面は、システム管理者がシステム内のロール（役割）を管理するために必要です。この画面により、登録されているロールの一覧表示、各ロールに割り当てられた権限数の確認、ロールの編集・削除が可能です。ロールベースアクセス制御（RBAC）の中核となる管理機能です。

**画面へのアクセス方法**：セキュリティモジュールのナビゲーションから「ロール」を選択、またはURL直接アクセス（`/roles`）でアクセス可能です。

**主要な操作・処理内容**：
1. ロール一覧の表示
2. ロール名での検索
3. 新規ロール作成（ヘッダーアクション）
4. ロールの編集（行アクション）
5. ロールの削除（行アクション）
6. ロールの一括削除（ツールバーアクション）

**画面遷移**：
- 一覧画面 → 作成画面（新規作成ボタン押下）
- 一覧画面 → 編集画面（編集アクション選択）
- 一覧画面 → 詳細画面（行クリック）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ロール管理権限を持つユーザーのみがアクセス可能です。panel_userロールは削除できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-ROLE-001 | ロール一覧 | 主機能 | ロール一覧の表示・管理 |
| FN-SEC-ROLE-002 | ロール作成 | 遷移先機能 | 新規ロール作成への遷移 |
| FN-SEC-ROLE-003 | ロール編集 | 遷移先機能 | ロール編集への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

- **URL**: `/roles`
- **ルート名**: `filament.resources.roles.index`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ロール                                    [+ 新規作成]            |
+------------------------------------------------------------------+
|  [検索...]                                                        |
+------------------------------------------------------------------+
|  ロール名        | ガード名    | 権限数     | 更新日時            |
+------------------------------------------------------------------+
|  [Admin]        | [web]      | [25]       | 2024-01-15 10:30   |
|              [...] [編集] [削除]                                  |
+------------------------------------------------------------------+
|  [Panel User]   | [web]      | [10]       | 2024-01-14 09:00   |
|              [...] [編集]                                         |
+------------------------------------------------------------------+
|  [Manager]      | [web]      | [15]       | 2024-01-13 14:20   |
|              [...] [編集] [削除]                                  |
+------------------------------------------------------------------+
|                          [一括削除]                               |
+------------------------------------------------------------------+
|  ページネーション: < 1 2 3 ... >                                   |
+------------------------------------------------------------------+
```

## 表示項目（テーブルカラム）

| No | 項目名 | 項目ID | データ型 | ソート | 検索 | 説明 |
|----|--------|--------|---------|-------|------|------|
| 1 | ロール名 | name | string | - | Yes | バッジ表示、ヘッドライン形式 |
| 2 | ガード名 | guard_name | string | - | - | バッジ表示 |
| 3 | 権限数 | permissions_count | integer | - | - | バッジ表示（成功色） |
| 4 | 更新日時 | updated_at | datetime | - | - | 日時形式で表示 |

## ヘッダーアクション

| No | アクション名 | アイコン | 説明 |
|----|------------|---------|------|
| 1 | 新規作成 | heroicon-o-plus-circle | ロール作成画面へ遷移 |

## 行アクション

| No | アクション名 | 表示条件 | 説明 |
|----|------------|---------|------|
| 1 | 編集 | 常時 | ロール編集画面へ遷移 |
| 2 | 削除 | ロール名がpanel_user以外 | ロールの削除 |

## ツールバーアクション

| No | アクション名 | 説明 |
|----|------------|------|
| 1 | 一括削除 | 選択したロールを一括削除 |

## イベント仕様

### 1-新規作成ボタン押下

- **トリガー**: ヘッダーの新規作成ボタンをクリック
- **処理内容**: ロール作成画面へ遷移
- **遷移先**: `/roles/create`

### 2-編集アクション

- **トリガー**: 行の編集ボタンをクリック
- **処理内容**: 該当ロールの編集画面へ遷移
- **遷移先**: `/roles/{id}/edit`

### 3-削除アクション

- **トリガー**: 行の削除ボタンをクリック
- **処理内容**:
  1. 確認ダイアログを表示
  2. 確認後、ロールを削除
  3. 関連する権限割当も削除
- **条件**: panel_userロールの場合は削除ボタン非表示
- **遷移先**: 一覧画面に留まる（リロード）

### 4-一括削除アクション

- **トリガー**: ツールバーの一括削除ボタンをクリック
- **処理内容**:
  1. 選択されたロールを確認
  2. 確認ダイアログを表示
  3. 確認後、選択されたロールを一括削除
- **遷移先**: 一覧画面に留まる（リロード）

### 5-検索

- **トリガー**: 検索ボックスに入力
- **処理内容**: ロール名で部分一致検索
- **対象カラム**: name

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | roles | DELETE | ロールレコード削除 |
| 削除アクション | role_has_permissions | DELETE | 権限割当削除 |
| 削除アクション | model_has_roles | DELETE | ユーザー割当削除 |
| 一括削除 | roles | DELETE | 複数ロール削除 |
| 一括削除 | role_has_permissions | DELETE | 関連権限割当削除 |
| 一括削除 | model_has_roles | DELETE | 関連ユーザー割当削除 |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------:|
| 1 | 成功 | ロールが正常に削除されました | 削除成功時 |
| 2 | 成功 | 選択したロールが正常に削除されました | 一括削除成功時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | panel_user削除試行 | 削除アクションを非表示 | - |
| 3 | 使用中ロール削除 | エラー通知表示 | このロールは使用中のため削除できません |

## ソート・フィルタ仕様

### デフォルトソート
- カラム: `created_at`
- 方向: `ASC`（昇順）

### カラム別設定

| カラム | ソート可能 | 検索可能 | バッジ表示 | バッジ色 |
|--------|-----------|---------|----------|---------|
| name | - | Yes | Yes | primary |
| guard_name | - | - | Yes | - |
| permissions_count | - | - | Yes | success |
| updated_at | - | - | - | - |

## 備考

- BezhanSalleh\FilamentShield\Resources\Roles\RoleResourceを継承しています
- ロール名はStr::headline()で整形されて表示されます
- panel_userロール（設定ファイルで定義）は削除できないよう保護されています
- 権限数はpermissionsリレーションのカウントで表示されます
- ナビゲーションソートは1に設定されており、セキュリティメニューの最初に表示されます
- ナビゲーションアイコンはnullに設定されています（デフォルトアイコンを使用）
- テナンシー機能が有効な場合、チーム選択フィールドが表示されます
