# 画面設計書 319-ロール作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ロール作成」画面の設計仕様を定義します。この画面はセキュリティモジュールに属する管理画面であり、新規ロール（役割）の作成と権限割当機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ロール作成画面は、システム管理者が新しいロール（役割）を作成し、そのロールに権限を割り当てるために必要です。この画面により、ロール名の設定と、リソース別・機能別の詳細な権限設定が可能です。作成したロールはユーザーに割り当てることで、アクセス制御を実現します。

**画面へのアクセス方法**：ロール一覧画面の「新規作成」ボタンをクリック、またはURL直接アクセス（`/roles/create`）でアクセス可能です。

**主要な操作・処理内容**：
1. ロール名の入力
2. ガード名の設定（オプション）
3. 全権限選択（select_all）
4. リソース別権限の選択
5. ロールの登録

**画面遷移**：
- 一覧画面 → 作成画面（新規作成ボタン押下）
- 作成画面 → 一覧画面（登録成功後）

**権限による表示制御**：Filament Shieldによる権限制御が実装されており、ロール作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-ROLE-002 | ロール作成 | 主機能 | 新規ロールの登録処理 |
| FN-SEC-ROLE-001 | ロール一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

作成（Create）

## URL/ルーティング

- **URL**: `/roles/create`
- **ルート名**: `filament.resources.roles.create`

## 画面構成

```
+------------------------------------------------------------------+
|  ナビゲーションバー                                                 |
+------------------------------------------------------------------+
|  ロール作成                                                        |
+------------------------------------------------------------------+
|  +------------------------------------------------------------+  |
|  | 基本情報                                                    |  |
|  | ┌──────────────┐ ┌──────────────┐ ┌──────────────┐         |  |
|  | │ ロール名 *   │ │ ガード名     │ │ チーム       │         |  |
|  | │ [_________] │ │ [web______] │ │ [選択_____] │         |  |
|  | └──────────────┘ └──────────────┘ └──────────────┘         |  |
|  |                                                             |  |
|  | [x] すべて選択                                               |  |
|  +------------------------------------------------------------+  |
|                                                                   |
|  +------------------------------------------------------------+  |
|  | リソース権限                                                 |  |
|  | ┌─────────────────────────────────────────────────────────┐|  |
|  | │ Support                                          [折畳] │|  |
|  | │  ┌───────────────┐  ┌───────────────┐                   │|  |
|  | │  │ Company       │  │ Currency      │                   │|  |
|  | │  │ [x] view      │  │ [x] view      │                   │|  |
|  | │  │ [x] view_any  │  │ [x] view_any  │                   │|  |
|  | │  │ [x] create    │  │ [x] create    │                   │|  |
|  | │  │ [x] update    │  │ [x] update    │                   │|  |
|  | │  │ [x] delete    │  │ [x] delete    │                   │|  |
|  | │  │ [x] delete_any│  │ [x] delete_any│                   │|  |
|  | │  └───────────────┘  └───────────────┘                   │|  |
|  | └─────────────────────────────────────────────────────────┘|  |
|  | ┌─────────────────────────────────────────────────────────┐|  |
|  | │ Security                                         [折畳] │|  |
|  | │  ┌───────────────┐  ┌───────────────┐                   │|  |
|  | │  │ User          │  │ Role          │                   │|  |
|  | │  │ [x] view      │  │ [x] view      │                   │|  |
|  | │  │ ...           │  │ ...           │                   │|  |
|  | │  └───────────────┘  └───────────────┘                   │|  |
|  | └─────────────────────────────────────────────────────────┘|  |
|  +------------------------------------------------------------+  |
+------------------------------------------------------------------+
|                                [キャンセル] [作成]                 |
+------------------------------------------------------------------+
```

## 入出力項目

| No | 項目名 | 項目ID | 入出力種別 | データ型 | 必須 | 初期値 | バリデーション |
|----|--------|--------|-----------|---------|------|-------|---------------|
| 1 | ロール名 | name | 入力 | string | Yes | - | 最大255文字、一意制約 |
| 2 | ガード名 | guard_name | 入力 | string | No | web | 最大255文字 |
| 3 | チーム | team_id | 入力 | integer | No | 現在のテナント | テナンシー有効時のみ表示 |
| 4 | すべて選択 | select_all | 入力 | boolean | No | false | - |
| 5 | リソース権限 | [動的] | 入力 | array | No | - | リソース別にチェックボックスリスト |

## 権限プレフィックス

| No | プレフィックス | 説明 |
|----|---------------|------|
| 1 | view | 個別レコードの表示権限 |
| 2 | view_any | 一覧表示権限 |
| 3 | create | 作成権限 |
| 4 | update | 更新権限 |
| 5 | delete | 削除権限 |
| 6 | delete_any | 一括削除権限 |

## イベント仕様

### 1-作成ボタン押下

- **トリガー**: フォームの作成ボタンをクリック
- **処理内容**:
  1. 入力値のバリデーション実行
  2. mutateFormDataBeforeCreateで権限データを抽出
  3. ロールレコードを作成（name, guard_name）
  4. afterCreateで権限同期処理を実行
     - DBトランザクション内で処理
     - 権限名を500件ずつチャンク処理
     - 存在しない権限は自動作成
     - role_has_permissionsテーブルに1000件ずつ挿入
  5. 権限キャッシュをクリア
  6. ロール一覧画面へリダイレクト
- **遷移先**: `/roles`

### 2-すべて選択チェック

- **トリガー**: すべて選択チェックボックスをクリック
- **処理内容**: 全リソースの全権限をチェック/アンチェック

### 3-キャンセルボタン押下

- **トリガー**: キャンセルボタンをクリック
- **処理内容**: ロール一覧画面へ戻る
- **遷移先**: `/roles`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | roles | INSERT | ロールレコード作成 |
| 作成ボタン押下 | permissions | INSERT | 不足権限の自動作成 |
| 作成ボタン押下 | role_has_permissions | INSERT | 権限割当 |

### テーブル別更新項目詳細

#### roles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ロール名 |
| INSERT | guard_name | Utils::getFilamentAuthGuard() | 認証ガード名 |
| INSERT | created_at | 現在時刻 | 作成日時 |
| INSERT | updated_at | 現在時刻 | 更新日時 |

#### permissions（不足時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 権限名 | 選択された権限名 |
| INSERT | guard_name | guard_name | 認証ガード名 |
| INSERT | created_at | 現在時刻 | 作成日時 |
| INSERT | updated_at | 現在時刻 | 更新日時 |

#### role_has_permissions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | role_id | 作成されたロールID | ロールID |
| INSERT | permission_id | 権限ID | 権限ID |

## メッセージ仕様

| No | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|---------------|---------------|---------:|
| 1 | 成功 | ロールが正常に作成されました | 登録成功時 |
| 2 | エラー | このロール名は既に使用されています | ロール名重複時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|---------|---------|---------------|
| 1 | 権限不足 | 画面へのアクセスを拒否 | アクセス権限がありません |
| 2 | ロール名重複 | バリデーションエラー表示 | このロール名は既に使用されています |
| 3 | データベースエラー | トランザクションロールバック、エラー通知表示 | 登録に失敗しました |

## 権限同期の技術的詳細

### チャンク処理

```
権限名取得 → 500件ずつ処理
  ↓
既存権限確認 → 不足権限を特定
  ↓
不足権限があれば → permissionsテーブルにINSERT
  ↓
全権限IDを収集
  ↓
role_has_permissions同期 → 1000件ずつINSERT
  ↓
キャッシュクリア → forgetCachedPermissions()
```

### トランザクション

- 権限同期処理はDBトランザクション内で実行
- エラー発生時は自動ロールバック
- 処理完了後にレコードをrefresh

## 備考

- CreateRecordを継承した作成画面です
- Filament Shieldパッケージの機能を拡張しています
- 権限はプラグイン（モジュール）別にグループ化されて表示されます
- 各リソースのFieldsetは折り畳み可能（collapsible）です
- テナンシー機能が有効な場合、チーム選択フィールドが表示されます
- 権限同期はチャンク処理で大量の権限を効率的に処理します
- insertOrIgnoreを使用して既存権限との競合を回避しています
- ガード名はUtils::getFilamentAuthGuard()から自動取得されます
