# 画面設計書 32-仕訳帳詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける仕訳帳詳細画面の設計仕様を定義するものです。この画面は会計モジュールの仕訳帳リソースの一部として、仕訳帳の詳細情報を閲覧するための読み取り専用ビューを提供します。

### 本画面の処理概要

**業務上の目的・背景**：仕訳帳は企業会計における取引記録の基本単位であり、売上、購入、銀行、現金、クレジットカードなど様々な財務取引を分類管理します。この詳細画面は、登録された仕訳帳の全情報（基本情報、会計設定、銀行口座連携、詳細設定など）を一目で確認できるビューを提供し、会計担当者や管理者が仕訳帳の設定内容を検証・確認する際に使用されます。

**画面へのアクセス方法**：仕訳帳一覧画面から該当レコードの「表示」ボタンをクリック、または一覧の行をクリックしてアクセスします。URLパターンは `/journals/{record}` です。

**主要な操作・処理内容**：
1. 仕訳帳の基本情報（名称、タイプ、会社）の表示
2. 会計情報（専用シーケンス設定、ソートコード、通貨、色）の表示
3. 銀行口座情報の表示（タイプがbankの場合）
4. 入金・出金のリレーションノートの表示（該当タイプの場合）
5. 詳細設定（許可勘定科目、自動チェック設定、請求書参照設定）の表示
6. ヘッダーアクションからの編集・削除操作

**画面遷移**：
- 遷移元：仕訳帳一覧画面、仕訳帳編集画面（保存成功時）
- 遷移先：「編集」ボタンで編集画面へ、「削除」ボタンで削除後一覧画面へ

**権限による表示制御**：システムの権限設定に基づき、仕訳帳リソースへの表示権限を持つユーザーがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-015 | 仕訳帳一覧 | 遷移元機能 | 一覧から詳細画面への遷移 |
| FN-ACC-017 | 仕訳帳編集 | 遷移先機能 | 詳細から編集画面への遷移 |
| - | 仕訳帳削除 | 関連機能 | 詳細画面からの削除操作 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/journals/{record}`
- ルート名: `filament.accounts.resources.journals.view`
- HTTPメソッド: GET

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  [編集] [削除]                                                    |
+------------------------------------------------------------------+
| 3カラムグリッドレイアウト                                          |
+----------------------------------+-------------------------------+
|                                  | 一般情報セクション              |
| タブパネル（2カラム幅）           |  - 名称                        |
|  ┌─────────────────────────────┐ |  - タイプ                      |
|  │ 仕訳エントリ | 入金 | 出金 |  |  - 会社                        |
|  │ 詳細設定                    | +-------------------------------+
|  └─────────────────────────────┘ |                                 |
|                                  |                                 |
| [仕訳エントリ]タブ                |                                 |
|  会計情報フィールドセット          |                                 |
|   ○ 専用クレジットノートシーケンス |                                 |
|   ○ 専用支払シーケンス            |                                 |
|   ソートコード: XXX               |                                 |
|   通貨: JPY                       |                                 |
|   色: [■]                         |                                 |
|  銀行口座セクション                |                                 |
|   口座番号: XXXX-XXXX             |                                 |
+----------------------------------+-------------------------------+
```

## 入出力項目

本画面は読み取り専用のため、入力項目はありません。

## 表示項目

| 項目名 | 項目ID | データ型 | 表示条件 | 備考 |
|--------|--------|----------|---------|------|
| 名称 | name | string | 常時 | アイコン: document-text |
| タイプ | type | enum | 常時 | アイコン: tag |
| 会社 | company.name | string | 常時 | アイコン: building-office |
| 専用クレジットノートシーケンス | refund_order | boolean | タイプがsale/purchase | IconEntry（○/×） |
| 専用支払シーケンス | payment_order | boolean | タイプがbank/cash/credit_card | IconEntry（○/×） |
| ソートコード | code | string | 常時 | プレースホルダー: - |
| 通貨 | currency.name | string | 常時 | プレースホルダー: - |
| 色 | color | string | 常時 | ColorEntry |
| 銀行口座番号 | bankAccount.account_number | string | タイプがbank | プレースホルダー: - |
| リレーションノート | relation_notes | text | タイプがbank/cash/credit_card | Markdown形式 |
| 許可勘定科目 | allowedAccounts.name | array | 常時 | 改行区切りリスト |
| 自動チェック | auto_check_on_post | boolean | 常時 | IconEntry（○/×） |
| 請求書参照タイプ | invoice_reference_type | enum | タイプがsale | プレースホルダー: - |
| 請求書参照モデル | invoice_reference_model | enum | タイプがsale | プレースホルダー: - |

## イベント仕様

### 1-編集ボタン押下

**トリガー**: ヘッダーの「編集」ボタンをクリック

**処理フロー**:
1. 仕訳帳編集画面への遷移
2. URLは `/journals/{record}/edit`

### 2-削除ボタン押下

**トリガー**: ヘッダーの「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、該当レコードの削除処理
3. 成功通知の表示（タイトル・本文は多言語ファイルから取得）
4. 一覧画面へのリダイレクト

### 3-タブ切り替え

**トリガー**: タブヘッダーのクリック

**処理フロー**:
1. 選択したタブのコンテンツを表示
2. 仕訳帳タイプに応じて特定のタブは非表示
   - 入金/出金タブ: bank, cash, credit_cardタイプのみ表示
   - 詳細設定タブ: 常時表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | accounts_journals | DELETE | 仕訳帳の削除 |
| 削除ボタン押下 | accounts_journal_accounts | DELETE | 関連する許可勘定科目の削除（CASCADE） |

### テーブル別更新項目詳細

#### accounts_journals

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record} | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 仕訳帳が削除されました | 削除成功時 |
| notification.body | 成功 | 仕訳帳のデータが正常に削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面表示 | 指定された仕訳帳が見つかりません |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| 削除時の外部キー制約違反 | エラー通知表示 | この仕訳帳は使用中のため削除できません |

## 備考

- 本画面はFilament PHPのViewRecordページクラスを継承して実装されています
- 表示はInfolist（情報リスト）コンポーネントを使用しており、読み取り専用です
- タブの表示/非表示は仕訳帳のタイプに応じて動的に制御されます
- IconEntryはboolean値を○/×アイコンで視覚的に表示します
- ColorEntryは色を視覚的なカラーボックスで表示します
- 許可勘定科目は`listWithLineBreaks()`で改行区切りリストとして表示されます
- リレーションノートはMarkdown形式でレンダリングされます
