# 画面設計書 321-ロール詳細

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「ロール詳細」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システムに登録されているロール（役割）の詳細情報を閲覧するための画面である。ロールに設定された権限情報や基本情報を確認し、必要に応じて編集画面への遷移を行うことができる。

**業務上の目的・背景**：システム管理者がユーザーに割り当てるロールの内容を確認し、適切な権限設定がなされているかを検証するために必要な画面である。権限管理はセキュリティの根幹であり、ロールに付与された権限を可視化することで、セキュリティポリシーの遵守状況を確認できる。

**画面へのアクセス方法**：メインナビゲーションから「セキュリティ」 > 「ロール管理」を選択し、ロール一覧画面でロール名をクリックするか、行アクションから「表示」を選択することでアクセスする。

**主要な操作・処理内容**：
1. ロールの基本情報（名前、ガード名、権限数）の確認
2. ロールに付与されている権限の詳細確認
3. 編集ボタンによる編集画面への遷移

**画面遷移**：ロール一覧画面からの遷移で表示される。本画面から編集ボタンをクリックするとロール編集画面へ遷移する。ただし、パネルユーザーロール（設定で定義）の場合は編集ボタンが非表示となる。

**権限による表示制御**：「view」権限を持つユーザーのみがアクセス可能。パネルユーザーロールの場合、編集ボタンが非表示となり、ロールの変更を防止する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-012 | ロール表示 | 主機能 | ロール詳細情報の表示 |
| FN-SEC-011 | ロール編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細表示

## URL/ルーティング

`/admin/roles/{record}`

## 画面構成

- ヘッダーアクション領域
  - 編集ボタン（パネルユーザーロールの場合は非表示）
- 基本情報セクション
  - ロール名
  - ガード名
- 権限情報セクション
  - プラグインごとにグループ化された権限一覧

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| ロールID | id | integer | 出力 | - | URLパラメータとして使用 |
| ロール名 | name | string | 出力 | - | ロールの表示名 |
| ガード名 | guard_name | string | 出力 | - | 認証ガード名 |
| 権限一覧 | permissions | array | 出力 | - | ロールに付与された権限 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ロール名 | テキスト | ロールの名称を表示 |
| ガード名 | バッジ | 認証ガード名をバッジ形式で表示 |
| 権限数 | バッジ | 付与されている権限の総数を表示 |
| 更新日時 | 日時 | 最終更新日時を表示 |

## イベント仕様

### 01-編集ボタン押下

編集ボタンをクリックすると、該当ロールの編集画面（/admin/roles/{record}/edit）へ遷移する。パネルユーザーロール（config('filament-shield.panel_user.name')で設定）の場合、このボタンは非表示となる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | roles | SELECT | ロール情報の取得 |
| 画面表示 | role_has_permissions | SELECT | ロールに付与された権限の取得 |
| 画面表示 | permissions | SELECT | 権限マスタ情報の取得 |

### テーブル別更新項目詳細

#### roles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, guard_name, updated_at | URLパラメータのrecordで指定されたID | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | - | - | 本画面では特にメッセージ表示はない |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 指定されたロールが存在しない | 404エラーページへリダイレクト |
| 権限不足 | アクセス拒否画面へリダイレクト |

## 備考

- 本画面はFilament PHPのViewRecordを継承して実装されている
- Filament Shieldプラグインによる権限管理機能を使用
- ロールはSpatie/laravel-permissionパッケージのRoleモデルを継承
