# 画面設計書 322-会社一覧

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「会社一覧」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システムに登録されている会社情報を一覧形式で表示・管理するための画面である。会社データの検索、フィルタリング、ソート、グループ化機能を提供し、会社の新規作成、編集、削除、復元といった操作を行うことができる。

**業務上の目的・背景**：マルチ会社対応のERPシステムにおいて、複数の会社（企業・支社・子会社）を一元管理する必要がある。本画面により、システム管理者は組織構造を把握し、会社ごとの設定を管理できる。会社情報は通貨設定やパートナー情報と連携し、取引や会計処理の基盤となる。

**画面へのアクセス方法**：メインナビゲーションから「セキュリティ」 > 「会社」を選択することでアクセスする。

**主要な操作・処理内容**：
1. 会社データの一覧表示（ロゴ、会社名、支社、メール、都市、国、通貨、ステータス等）
2. タブ切り替えによる全件/アーカイブ済みの切り替え
3. 会社名・メール・都市・国での検索
4. ステータス・国でのフィルタリング
5. 各種項目でのグループ化・ソート
6. 会社の新規作成、表示、編集、削除、復元操作
7. 一括削除・完全削除・復元操作
8. テーブルビューのカスタマイズ

**画面遷移**：本画面から会社作成画面、会社詳細画面、会社編集画面へ遷移できる。

**権限による表示制御**：ログインユーザーが作成した会社のみが表示される（creator_idによるフィルタ）。親会社のみ表示され、支社は表示されない（parent_id IS NULL）。デフォルト会社として使用中の会社は削除不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-013 | 会社一覧 | 主機能 | 会社データの一覧表示・検索・フィルタ |
| FN-SEC-014 | 会社作成 | 遷移先機能 | 新規会社作成画面への遷移 |
| FN-SEC-015 | 会社編集 | 遷移先機能 | 会社編集画面への遷移 |
| FN-SEC-016 | 会社表示 | 遷移先機能 | 会社詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`/admin/companies`

## 画面構成

- ヘッダーアクション領域
  - 新規作成ボタン
- タブ領域
  - 全件タブ（件数バッジ付き）
  - アーカイブ済みタブ（件数バッジ付き）
- テーブル領域
  - カラム管理機能
  - フィルタ機能
  - グループ化機能
  - 検索機能
  - 一括アクション機能
  - 行アクション機能
  - ドラッグ&ドロップによる並び替え

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 検索キーワード | search | string | 入力 | - | 会社名・メールで検索 |
| ステータスフィルタ | is_active | boolean | 入力 | - | アクティブ/非アクティブ |
| 国フィルタ | country_id | integer | 入力 | - | 国でフィルタ |

## 表示項目

| 項目名 | カラムID | 表示形式 | 説明 |
|--------|----------|----------|------|
| ロゴ | partner.avatar | 画像（円形50px） | 会社ロゴ |
| 会社名 | name | テキスト | 会社名（検索・ソート可） |
| 支社 | branches.name | バッジ | 支社一覧 |
| メール | email | テキスト | メールアドレス（検索・ソート可） |
| 都市 | city | テキスト | 都市名（検索・ソート可、デフォルト非表示） |
| 国 | country.name | テキスト | 国名（検索・ソート可、デフォルト非表示） |
| 通貨 | currency.full_name | テキスト | 通貨名（検索・ソート可） |
| ステータス | is_active | アイコン（真偽値） | アクティブ状態 |
| 作成日時 | created_at | 日時 | 作成日時（デフォルト非表示） |
| 更新日時 | updated_at | 日時 | 更新日時（デフォルト非表示） |

## イベント仕様

### 01-新規作成ボタン押下

新規作成ボタンをクリックすると、会社作成画面（/admin/companies/create）へ遷移する。

### 02-行アクション（表示）

表示アクションをクリックすると、該当会社の詳細画面（/admin/companies/{record}）へ遷移する。

### 03-行アクション（編集）

編集アクションをクリックすると、該当会社の編集画面（/admin/companies/{record}/edit）へ遷移する。編集完了時に成功通知が表示される。

### 04-行アクション（削除）

削除アクションをクリックすると、会社を論理削除する。デフォルト会社として使用中の場合は削除ボタンが非表示となる。削除完了時に成功通知が表示される。

### 05-行アクション（復元）

アーカイブ済みタブでのみ表示。復元アクションをクリックすると、論理削除された会社を復元する。

### 06-一括削除

チェックボックスで選択した会社を一括で論理削除する。デフォルト会社として使用中の会社は選択不可。

### 07-一括完全削除

チェックボックスで選択した会社を一括で物理削除する。

### 08-一括復元

チェックボックスで選択した論理削除済み会社を一括で復元する。

### 09-並び替え

ドラッグ&ドロップにより会社の表示順序（sort列）を変更する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | companies | SELECT | 会社一覧の取得 |
| 削除 | companies | UPDATE | deleted_atへの日時設定（論理削除） |
| 完全削除 | companies | DELETE | レコードの物理削除 |
| 復元 | companies | UPDATE | deleted_atのNULL設定 |
| 並び替え | companies | UPDATE | sort列の更新 |

### テーブル別更新項目詳細

#### companies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | creator_id = ログインユーザーID AND parent_id IS NULL | ログインユーザー作成の親会社のみ |
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除 |
| UPDATE（復元） | deleted_at | NULL | 復元 |
| UPDATE（並び替え） | sort | 新しい順序値 | ドラッグ&ドロップ時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification | 成功 | 会社が更新されました | 編集完了時 |
| delete.notification | 成功 | 会社が削除されました | 削除完了時 |
| restore.notification | 成功 | 会社が復元されました | 復元完了時 |
| bulk-delete.notification | 成功 | 会社が一括削除されました | 一括削除完了時 |
| force-delete.notification | 成功 | 会社が完全に削除されました | 完全削除完了時 |
| bulk-restore.notification | 成功 | 会社が一括復元されました | 一括復元完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| デフォルト会社の削除試行 | 削除ボタンを非表示、チェックボックスを無効化 |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されている
- HasTableViewsトレイトによりテーブルビューのカスタマイズが可能
- HasCustomFieldsトレイトによりカスタムフィールドの表示・フィルタに対応
- 会社作成時にパートナーレコードが自動生成される
- 会社はSpatie/eloquent-sortableパッケージによる並び替えに対応
