# 画面設計書 323-会社作成

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「会社作成」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、新しい会社情報を登録するための画面である。会社の基本情報、住所情報、追加情報、ブランディング、連絡先情報を入力し、システムに会社を登録することができる。

**業務上の目的・背景**：マルチ会社対応のERPシステムにおいて、新規会社・子会社・支社を登録する必要がある。会社情報は取引先管理、会計処理、在庫管理など多くの業務機能の基盤となるため、正確かつ完全な情報を登録することが重要である。

**画面へのアクセス方法**：会社一覧画面のヘッダーにある「新規作成」ボタンをクリックすることでアクセスする。

**主要な操作・処理内容**：
1. 会社基本情報（会社名、登録番号、会社ID、税ID、ウェブサイト）の入力
2. 住所情報（住所1、住所2、都市、郵便番号、国、都道府県）の入力
3. 追加情報（デフォルト通貨、設立日、ステータス）の設定
4. ブランディング情報（ロゴ、ブランドカラー）の設定
5. 連絡先情報（電話、携帯、メール）の入力
6. 保存ボタンによる会社データの登録

**画面遷移**：会社一覧画面から遷移する。保存成功後は該当会社の詳細画面へ自動遷移する。

**権限による表示制御**：「create」権限を持つユーザーのみがアクセス可能。カスタムフィールドが設定されている場合は追加情報セクションに動的に表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-014 | 会社作成 | 主機能 | 新規会社の登録処理 |
| FN-SEC-016 | 会社表示 | 遷移先機能 | 登録後の詳細画面表示 |

## 画面種別

登録

## URL/ルーティング

`/admin/companies/create`

## 画面構成

- 3カラムレイアウト（左2カラム＋右1カラム）
- 左側セクション群
  - 会社情報セクション
  - 住所情報セクション
  - 追加情報セクション
- 右側セクション群
  - ブランディングセクション
  - 連絡先情報セクション
- フッターアクション
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

### 会社情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 会社名 | name | string(255) | 入力 | ○ | - |
| 登録番号 | registration_number | string(255) | 入力 | - | 法人登記番号等 |
| 会社ID | company_id | string(255) | 入力 | - | ユニーク制約、ヒントアイコン付き |
| 税ID | tax_id | string(255) | 入力 | - | ユニーク制約、ヒントアイコン付き |
| ウェブサイト | website | string(255) | 入力 | - | URL形式、ユニーク制約、プレフィックスアイコン付き |

### 住所情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 住所1 | street1 | string(255) | 入力 | - | - |
| 住所2 | street2 | string(255) | 入力 | - | - |
| 都市 | city | string(255) | 入力 | - | - |
| 郵便番号 | zip | string(255) | 入力 | - | - |
| 国 | country_id | integer | 入力 | - | 国マスタから選択、検索可能 |
| 都道府県 | state_id | integer | 入力 | - | 都道府県マスタから選択、国に連動、新規作成可能 |

### 追加情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| デフォルト通貨 | currency_id | integer | 入力 | ○ | 通貨マスタから選択、新規作成可能 |
| 設立日 | founded_date | date | 入力 | - | 日付ピッカー |
| ステータス | is_active | boolean | 入力 | - | デフォルト: true |

### ブランディングセクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 会社ロゴ | partner.avatar | file | 入力 | - | 画像ファイル、company-logosディレクトリに保存 |
| ブランドカラー | color | string | 入力 | - | カラーピッカー（16進数） |

### 連絡先情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 電話番号 | phone | string(255) | 入力 | - | 電話形式 |
| 携帯番号 | mobile | string(255) | 入力 | - | 電話形式 |
| メールアドレス | email | string(255) | 入力 | - | メール形式 |

## 表示項目

該当なし（登録画面のため）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーション実行
2. creator_idにログインユーザーIDを設定
3. companiesテーブルへデータ挿入
4. パートナーレコード自動作成（Companyモデルのcreatingイベント）
5. 成功通知表示
6. 会社詳細画面へリダイレクト

### 02-国選択変更

国を変更すると、都道府県選択肢がクリアされ、選択した国に属する都道府県のみが選択可能となる。

### 03-都道府県新規作成

都道府県選択で「新規作成」を選択すると、モーダルが開き、都道府県名、コード、国を入力して新規都道府県を登録できる。

### 04-通貨新規作成

通貨選択で「新規作成」を選択すると、モーダルが開き、通貨名、フル名、シンボル、ISOコード、小数点桁数、丸め設定を入力して新規通貨を登録できる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | companies | INSERT | 会社レコードの新規作成 |
| 保存 | partners | INSERT | パートナーレコードの自動作成 |
| 都道府県作成 | states | INSERT | 都道府県マスタへの登録 |
| 通貨作成 | currencies | INSERT | 通貨マスタへの登録 |

### テーブル別更新項目詳細

#### companies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | name | 入力値 | 必須 |
| INSERT | registration_number | 入力値 | - |
| INSERT | company_id | 入力値 | ユニーク |
| INSERT | tax_id | 入力値 | ユニーク |
| INSERT | website | 入力値 | ユニーク |
| INSERT | street1, street2 | 入力値 | - |
| INSERT | city, zip | 入力値 | - |
| INSERT | country_id, state_id | 入力値 | - |
| INSERT | currency_id | 入力値 | 必須 |
| INSERT | founded_date | 入力値 | - |
| INSERT | is_active | 入力値 | デフォルトtrue |
| INSERT | phone, mobile, email | 入力値 | - |
| INSERT | color | 入力値 | - |
| INSERT | partner_id | 自動生成パートナーID | creatingイベントで設定 |

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | creator_id | ログインユーザーID | - |
| INSERT | sub_type | 'company' | 固定値 |
| INSERT | name, email, website, tax_id, phone, mobile | companiesと同値 | - |
| INSERT | street1, street2, city, zip, state_id, country_id | companiesと同値 | - |
| INSERT | avatar | アップロード画像パス | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create.notification.title | 成功 | 会社が作成されました | 保存成功時 |
| create.notification.body | 成功 | 会社情報が正常に登録されました | 保存成功時 |
| validation.error | エラー | 必須項目を入力してください | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| 一意性制約違反（company_id, tax_id, website） | バリデーションエラー表示 |
| データベースエラー | エラー通知表示、画面に留まる |

## 備考

- 本画面はFilament PHPのCreateRecordを継承して実装されている
- HasCustomFieldsトレイトによりカスタムフィールドの追加が可能
- 会社作成時にCompanyモデルのcreatingイベントでパートナーレコードが自動生成される
- 通貨のデフォルト値は最初に登録された通貨（Currency::first()）が設定される
