# 画面設計書 324-会社編集

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「会社編集」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、既存の会社情報を更新するための画面である。会社の基本情報、住所情報、追加情報、ブランディング、連絡先情報を編集し、システムに反映することができる。

**業務上の目的・背景**：会社情報は事業環境の変化に応じて更新が必要となる。社名変更、本社移転、連絡先変更、ブランドカラーの変更など、様々な状況に対応するために会社情報の編集機能が必要である。正確な会社情報を維持することは、取引先との適切なコミュニケーションや法的コンプライアンスにおいて重要である。

**画面へのアクセス方法**：会社一覧画面または会社詳細画面から「編集」ボタンをクリックすることでアクセスする。

**主要な操作・処理内容**：
1. 既存の会社情報の表示・確認
2. 会社基本情報の編集
3. 住所情報の編集
4. 追加情報の編集
5. ブランディング情報の編集
6. 連絡先情報の編集
7. 保存ボタンによる更新内容の反映
8. 表示ボタンによる詳細画面への遷移
9. 削除ボタンによる会社の論理削除

**画面遷移**：会社一覧画面または会社詳細画面から遷移する。保存成功後は該当会社の詳細画面へ自動遷移する。

**権限による表示制御**：「update」権限を持つユーザーのみがアクセス可能。デフォルト会社として使用中の会社は削除ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-015 | 会社編集 | 主機能 | 会社情報の更新処理 |
| FN-SEC-016 | 会社表示 | 遷移先機能 | 詳細画面への遷移 |

## 画面種別

編集

## URL/ルーティング

`/admin/companies/{record}/edit`

## 画面構成

- ヘッダーアクション領域
  - 表示ボタン
  - 削除ボタン（デフォルト会社の場合は非表示）
- 3カラムレイアウト（左2カラム＋右1カラム）
- 左側セクション群
  - 会社情報セクション
  - 住所情報セクション
  - 追加情報セクション
- 右側セクション群
  - ブランディングセクション
  - 連絡先情報セクション
- フッターアクション
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

### 会社情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 会社名 | name | string(255) | 入出力 | ○ | - |
| 登録番号 | registration_number | string(255) | 入出力 | - | 法人登記番号等 |
| 会社ID | company_id | string(255) | 入出力 | - | ユニーク制約（自レコード除外） |
| 税ID | tax_id | string(255) | 入出力 | - | ユニーク制約（自レコード除外） |
| ウェブサイト | website | string(255) | 入出力 | - | URL形式、ユニーク制約（自レコード除外） |

### 住所情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 住所1 | street1 | string(255) | 入出力 | - | - |
| 住所2 | street2 | string(255) | 入出力 | - | - |
| 都市 | city | string(255) | 入出力 | - | - |
| 郵便番号 | zip | string(255) | 入出力 | - | - |
| 国 | country_id | integer | 入出力 | - | 国マスタから選択 |
| 都道府県 | state_id | integer | 入出力 | - | 都道府県マスタから選択 |

### 追加情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| デフォルト通貨 | currency_id | integer | 入出力 | ○ | 通貨マスタから選択 |
| 設立日 | founded_date | date | 入出力 | - | - |
| ステータス | is_active | boolean | 入出力 | - | - |

### ブランディングセクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 会社ロゴ | partner.avatar | file | 入出力 | - | 画像ファイル |
| ブランドカラー | color | string | 入出力 | - | 16進数カラーコード |

### 連絡先情報セクション

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 電話番号 | phone | string(255) | 入出力 | - | 電話形式 |
| 携帯番号 | mobile | string(255) | 入出力 | - | 電話形式 |
| メールアドレス | email | string(255) | 入出力 | - | メール形式 |

## 表示項目

該当なし（既存データは入力フィールドに表示）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーション実行
2. creator_idにログインユーザーIDを設定（更新者として）
3. companiesテーブルのデータ更新
4. パートナーレコード自動更新（Companyモデルのsavedイベント）
5. 成功通知表示
6. 会社詳細画面へリダイレクト

### 02-表示ボタン押下

会社詳細画面（/admin/companies/{record}）へ遷移する。

### 03-削除ボタン押下

1. 確認ダイアログ表示
2. 確認後、会社の論理削除（deleted_atに日時設定）
3. 成功通知表示
4. 会社一覧画面へリダイレクト

デフォルト会社として使用中の場合はボタン自体が非表示。

### 04-国選択変更

国を変更すると、都道府県選択肢がリセットされ、選択した国に属する都道府県のみが選択可能となる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | companies | UPDATE | 会社レコードの更新 |
| 保存 | partners | UPDATE | パートナーレコードの自動更新 |
| 削除 | companies | UPDATE | deleted_atへの日時設定 |

### テーブル別更新項目詳細

#### companies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | creator_id | ログインユーザーID | 更新者として設定 |
| UPDATE | name | 入力値 | 必須 |
| UPDATE | registration_number | 入力値 | - |
| UPDATE | company_id | 入力値 | ユニーク |
| UPDATE | tax_id | 入力値 | ユニーク |
| UPDATE | website | 入力値 | ユニーク |
| UPDATE | street1, street2, city, zip | 入力値 | - |
| UPDATE | country_id, state_id | 入力値 | - |
| UPDATE | currency_id | 入力値 | 必須 |
| UPDATE | founded_date | 入力値 | - |
| UPDATE | is_active | 入力値 | - |
| UPDATE | phone, mobile, email | 入力値 | - |
| UPDATE | color | 入力値 | - |
| UPDATE | deleted_at | 現在日時 | 削除操作時 |

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 全フィールド | companiesと同期 | savedイベントで自動更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification.title | 成功 | 会社が更新されました | 保存成功時 |
| edit.notification.body | 成功 | 会社情報が正常に更新されました | 保存成功時 |
| delete.notification.title | 成功 | 会社が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 会社が正常に削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| レコード不存在 | 404エラーページ表示 |
| 一意性制約違反 | バリデーションエラー表示 |
| データベースエラー | エラー通知表示 |

## 備考

- 本画面はFilament PHPのEditRecordを継承して実装されている
- フォーム定義は会社作成画面と共通（CompanyResource::form()）
- HasCustomFieldsトレイトによりカスタムフィールドの編集が可能
- 会社更新時にCompanyモデルのsavedイベントでパートナーレコードが自動更新される
- デフォルト会社かどうかの判定はUser::where('default_company_id', $record->id)->exists()で行う
