# 画面設計書 325-会社詳細

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「会社詳細」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、登録されている会社の詳細情報を閲覧するための画面である。会社の基本情報、住所、追加情報、ブランディング、連絡先情報を確認し、必要に応じて編集画面への遷移や会社の削除を行うことができる。また、支社（ブランチ）のリレーション管理も可能である。

**業務上の目的・背景**：システム管理者や担当者が会社の詳細情報を確認するために必要な画面である。取引先への連絡や請求書発行時の確認、組織情報の把握など、様々な業務シーンで会社情報の参照が必要となる。

**画面へのアクセス方法**：会社一覧画面でレコードをクリックするか、行アクションから「表示」を選択することでアクセスする。

**主要な操作・処理内容**：
1. 会社基本情報（会社名、登録番号、会社ID、税ID、ウェブサイト）の確認
2. 住所情報の確認
3. 追加情報（通貨、設立日、ステータス）の確認
4. ブランディング情報（ロゴ、カラー）の確認
5. 連絡先情報の確認
6. 編集ボタンによる編集画面への遷移
7. 削除ボタンによる会社の論理削除
8. 支社リレーションの管理

**画面遷移**：会社一覧画面から遷移する。編集ボタンで編集画面へ遷移。

**権限による表示制御**：「view」権限を持つユーザーのみがアクセス可能。デフォルト会社として使用中の場合、削除ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-016 | 会社表示 | 主機能 | 会社詳細情報の表示 |
| FN-SEC-015 | 会社編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細表示

## URL/ルーティング

`/admin/companies/{record}`

## 画面構成

- ヘッダーアクション領域
  - 編集ボタン
  - 削除ボタン（デフォルト会社の場合は非表示）
- 3カラムレイアウト（左2カラム＋右1カラム）
- 左側セクション群
  - 会社情報セクション
  - 住所情報セクション
  - 追加情報セクション
- 右側セクション群
  - ブランディングセクション
  - 連絡先情報セクション
- リレーションマネージャー
  - 支社（ブランチ）一覧

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 会社情報セクション

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 会社名 | name | テキスト（アイコン付き） | 建物アイコン付き |
| 登録番号 | registration_number | テキスト（アイコン付き） | 文書アイコン付き |
| 会社ID | company_id | テキスト（アイコン付き） | 識別アイコン付き |
| 税ID | tax_id | テキスト（アイコン付き） | 通貨アイコン付き |
| ウェブサイト | website | テキスト（アイコン付き） | 地球アイコン付き |

### 住所情報セクション

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 住所1 | street1 | テキスト（アイコン付き） | 地図ピンアイコン付き |
| 住所2 | street2 | テキスト | - |
| 都市 | city | テキスト（アイコン付き） | 建物アイコン付き |
| 郵便番号 | zip | テキスト | - |
| 国 | country.name | テキスト（アイコン付き） | 地球アイコン付き |
| 都道府県 | state.name | テキスト | - |

### 追加情報セクション

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| デフォルト通貨 | currency.full_name | テキスト（アイコン付き） | 通貨アイコン付き |
| 設立日 | founded_date | 日付（アイコン付き） | カレンダーアイコン付き |
| ステータス | is_active | アイコン（真偽値） | 有効/無効 |

### ブランディングセクション

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 会社ロゴ | partner.avatar | 画像（円形） | - |
| ブランドカラー | color | カラー | 16進数カラー表示 |

### 連絡先情報セクション

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 電話番号 | phone | テキスト（アイコン付き） | 電話アイコン付き |
| 携帯番号 | mobile | テキスト（アイコン付き） | 携帯アイコン付き |
| メールアドレス | email | テキスト（アイコン付き） | メールアイコン付き、コピー可能 |

## イベント仕様

### 01-編集ボタン押下

会社編集画面（/admin/companies/{record}/edit）へ遷移する。

### 02-削除ボタン押下

1. 確認ダイアログ表示
2. 確認後、会社の論理削除（deleted_atに日時設定）
3. 成功通知表示
4. 会社一覧画面へリダイレクト

デフォルト会社として使用中の場合はボタン自体が非表示。

### 03-メールアドレスコピー

メールアドレスの横にあるコピーボタンをクリックすると、クリップボードにメールアドレスがコピーされ、「Email address copied」というメッセージが1.5秒間表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | companies | SELECT | 会社情報の取得 |
| 画面表示 | partners | SELECT | パートナー情報の取得 |
| 画面表示 | countries | SELECT | 国マスタ情報の取得 |
| 画面表示 | states | SELECT | 都道府県マスタ情報の取得 |
| 画面表示 | currencies | SELECT | 通貨マスタ情報の取得 |
| 削除 | companies | UPDATE | deleted_atへの日時設定 |

### テーブル別更新項目詳細

#### companies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | URLパラメータのrecordで指定されたID | - |
| UPDATE | deleted_at | 現在日時 | 削除操作時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.title | 成功 | 会社が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 会社が正常に削除されました | 削除成功時 |
| copy.message | 情報 | Email address copied | メールコピー時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| レコード不存在 | 404エラーページ表示 |

## 備考

- 本画面はFilament PHPのViewRecordを継承して実装されている
- Infolist定義はCompanyResource::infolist()で共通管理
- BranchesRelationManagerにより支社の管理が可能
- HasCustomFieldsトレイトによりカスタムフィールドの表示が可能
- 値が空の場合は「—」（プレースホルダ）が表示される
