# 画面設計書 326-チーム管理

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「チーム管理」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システム内のチーム（グループ）を管理するための画面である。チームの一覧表示、新規作成、表示、編集、削除をモーダルダイアログ形式で行う単一画面管理（ManageRecords）パターンを採用している。

**業務上の目的・背景**：チームはユーザーを論理的にグループ化する機能である。プロジェクトチーム、部門、担当グループなど、様々な用途でユーザーをまとめて管理することができる。権限管理と組み合わせることで、チーム単位でのアクセス制御も可能となる。

**画面へのアクセス方法**：メインナビゲーションから「セキュリティ」 > 「チーム」を選択することでアクセスする。

**主要な操作・処理内容**：
1. チーム一覧の表示
2. チームの新規作成（モーダルダイアログ）
3. チームの詳細表示（モーダルダイアログ）
4. チームの編集（モーダルダイアログ）
5. チームの削除

**画面遷移**：本画面は単一画面で全操作を完結する。別画面への遷移はなく、モーダルダイアログでCRUD操作を行う。

**権限による表示制御**：TeamResourceに対する各種権限（view_any, view, create, update, delete）により操作が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SEC-017 | チーム一覧 | 主機能 | チーム一覧の表示 |
| FN-SEC-018 | チーム作成 | 主機能 | 新規チームの作成 |
| FN-SEC-019 | チーム編集 | 主機能 | 既存チームの編集 |
| FN-SEC-020 | チーム表示 | 主機能 | チーム詳細の表示 |

## 画面種別

管理（ManageRecords）

## URL/ルーティング

`/admin/teams`

## 画面構成

- ヘッダーアクション領域
  - 新規作成ボタン
- テーブル領域
  - チーム名カラム
  - 行アクション（表示、編集、削除）
- 空状態表示
  - 空状態用作成ボタン

## 入出力項目

### チーム作成/編集フォーム

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| チーム名 | name | string(255) | 入力 | ○ | 最大255文字 |

### チーム詳細表示

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| チーム名 | name | string(255) | 出力 | - | ユーザーアイコン付き |

## 表示項目

| 項目名 | カラムID | 表示形式 | 説明 |
|--------|----------|----------|------|
| チーム名 | name | テキスト | 検索・ソート可、最大50文字表示 |

## イベント仕様

### 01-新規作成ボタン押下

1. 作成モーダルダイアログを表示
2. チーム名入力
3. 保存ボタン押下で新規チームをデータベースに登録
4. 成功通知表示
5. モーダルを閉じ、一覧を更新

### 02-表示アクション

1. 表示モーダルダイアログを表示
2. チーム詳細情報（チーム名）を表示

### 03-編集アクション

1. 編集モーダルダイアログを表示
2. 既存のチーム名を表示
3. 編集後、保存ボタン押下でデータベースを更新
4. 成功通知表示
5. モーダルを閉じ、一覧を更新

### 04-削除アクション

1. 確認ダイアログ表示
2. 確認後、チームをデータベースから削除
3. 成功通知表示
4. 一覧を更新

### 05-空状態作成ボタン押下

データが存在しない場合に表示される空状態画面から、チーム作成モーダルを開く。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | teams | SELECT | チーム一覧の取得 |
| 新規作成 | teams | INSERT | チームレコードの新規作成 |
| 編集 | teams | UPDATE | チームレコードの更新 |
| 削除 | teams | DELETE | チームレコードの物理削除 |

### テーブル別更新項目詳細

#### teams

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name | 全レコード | - |
| INSERT | name | 入力値 | 必須 |
| UPDATE | name | 入力値 | 必須 |
| DELETE | - | IDで指定されたレコード | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create.notification.title | 成功 | チームが作成されました | 作成成功時 |
| create.notification.body | 成功 | チームが正常に作成されました | 作成成功時 |
| edit.notification.title | 成功 | チームが更新されました | 編集成功時 |
| edit.notification.body | 成功 | チームが正常に更新されました | 編集成功時 |
| delete.notification.title | 成功 | チームが削除されました | 削除成功時 |
| delete.notification.body | 成功 | チームが正常に削除されました | 削除成功時 |
| empty-state.create.notification.title | 成功 | チームが作成されました | 空状態から作成成功時 |
| empty-state.create.notification.body | 成功 | チームが正常に作成されました | 空状態から作成成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| バリデーションエラー | エラーメッセージ表示、画面に留まる |
| データベースエラー | エラー通知表示 |

## 備考

- 本画面はFilament PHPのManageRecordsを継承して実装されている
- チームとユーザーは多対多の関係（user_teamピボットテーブル）
- モーダルダイアログ形式のため、別画面への遷移なく全操作を完結
- TeamモデルはシンプルなEloquentモデルで、SoftDeletesは使用していない
