# 画面設計書 327-ユーザー設定

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「ユーザー設定」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システム全体のユーザー管理に関する設定を行うための画面である。ユーザー招待機能の有効/無効、パスワードリセット機能の有効/無効、デフォルトロール、デフォルト会社などの設定を管理する。

**業務上の目的・背景**：企業のセキュリティポリシーに応じて、ユーザー管理機能をカスタマイズする必要がある。ユーザー招待機能の制限、パスワードリセットの許可/禁止、新規ユーザーに自動適用するデフォルト値の設定により、組織の運用ルールに沿ったシステム運用が可能となる。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターにアクセスし、「ユーザー」を選択することでアクセスする。

**主要な操作・処理内容**：
1. ユーザー招待機能の有効/無効設定
2. パスワードリセット機能の有効/無効設定
3. デフォルトロールの設定
4. デフォルト会社の設定
5. 保存ボタンによる設定の反映

**画面遷移**：設定クラスター内のページとして単独で表示される。他画面への遷移はない。

**権限による表示制御**：HasPageShieldトレイトにより、本画面へのアクセス権限が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ユーザー設定 | 主機能 | ユーザー管理関連の設定 |

## 画面種別

設定

## URL/ルーティング

`/admin/settings/users`

## 画面構成

- パンくずリスト
- 設定フォーム
  - ユーザー招待機能トグル
  - パスワードリセット機能トグル
  - デフォルトロール選択
  - デフォルト会社選択
- フッターアクション
  - 保存ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| ユーザー招待を有効にする | enable_user_invitation | boolean | 入出力 | ○ | トグル形式、ヘルパーテキスト付き |
| パスワードリセットを有効にする | enable_reset_password | boolean | 入出力 | ○ | トグル形式、ヘルパーテキスト付き |
| デフォルトロール | default_role_id | integer | 入出力 | - | ロールマスタから選択、検索可能 |
| デフォルト会社 | default_company_id | integer | 入出力 | - | 会社マスタから選択、検索可能 |

## 表示項目

該当なし（設定フォーム画面のため入力項目のみ）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーション実行
2. UserSettings設定クラスに値を保存
3. 成功通知表示

### 02-デフォルトロール選択

ロールマスタ（roles）から選択。ロール名は先頭文字が大文字化されて表示される（ucfirst）。検索可能。

### 03-デフォルト会社選択

会社マスタ（companies）から選択。会社名で表示。検索可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | roles | SELECT | ロール一覧の取得 |
| 画面表示 | companies | SELECT | 会社一覧の取得 |
| 保存 | settings | UPDATE | 設定値の保存 |

### テーブル別更新項目詳細

本画面はSpatie/laravel-settingsパッケージを使用しており、設定値はsettingsテーブルまたは設定ファイルに保存される。

#### settings（または設定ファイル）

| 操作 | 項目（設定キー） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_user_invitation | true/false | UserSettings |
| UPDATE | enable_reset_password | true/false | UserSettings |
| UPDATE | default_role_id | 選択されたロールID | UserSettings |
| UPDATE | default_company_id | 選択された会社ID | UserSettings |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| settings.saved | 成功 | 設定が保存されました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| バリデーションエラー | エラーメッセージ表示 |

## 備考

- 本画面はFilament PHPのSettingsPageを継承して実装されている
- HasPageShieldトレイトによりページレベルの権限制御が可能
- UserSettingsクラス（Webkul\Security\Settings\UserSettings）で設定値を管理
- Spatie/laravel-settingsパッケージを使用して設定値を永続化
- 設定クラスター（Settings）配下のページとして構成
- ナビゲーションアイコン: heroicon-o-user-group
