# 画面設計書 328-通貨設定

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「通貨設定」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システム全体で使用するデフォルト通貨を設定するための画面である。ERPシステムにおける会計処理、取引金額表示などに使用される基準通貨を設定する。

**業務上の目的・背景**：多通貨対応のERPシステムにおいて、デフォルトの基準通貨を設定する必要がある。取引や会計処理において、明示的に通貨が指定されていない場合に適用される通貨を定義することで、一貫した金額処理が可能となる。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターにアクセスし、「通貨」を選択することでアクセスする。

**主要な操作・処理内容**：
1. デフォルト通貨の選択
2. 保存ボタンによる設定の反映

**画面遷移**：設定クラスター内のページとして単独で表示される。他画面への遷移はない。

**権限による表示制御**：HasPageShieldトレイトにより、本画面へのアクセス権限が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 通貨設定 | 主機能 | デフォルト通貨の設定 |

## 画面種別

設定

## URL/ルーティング

`/admin/settings/currency`

## 画面構成

- パンくずリスト
- 設定フォーム
  - デフォルト通貨選択
- フッターアクション
  - 保存ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| デフォルト通貨 | default_currency_id | integer | 入出力 | - | 通貨マスタから選択、検索可能、ヘルパーテキスト付き |

## 表示項目

該当なし（設定フォーム画面のため入力項目のみ）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーション実行
2. CurrencySettings設定クラスに値を保存
3. 成功通知表示

### 02-デフォルト通貨選択

通貨マスタ（currencies）から選択。通貨名（name）で表示。検索可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | currencies | SELECT | 通貨一覧の取得 |
| 保存 | settings | UPDATE | 設定値の保存 |

### テーブル別更新項目詳細

本画面はSpatie/laravel-settingsパッケージを使用しており、設定値はsettingsテーブルまたは設定ファイルに保存される。

#### settings（または設定ファイル）

| 操作 | 項目（設定キー） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | default_currency_id | 選択された通貨ID | CurrencySettings |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| settings.saved | 成功 | 設定が保存されました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| バリデーションエラー | エラーメッセージ表示 |

## 備考

- 本画面はFilament PHPのSettingsPageを継承して実装されている
- HasPageShieldトレイトによりページレベルの権限制御が可能
- CurrencySettingsクラス（Webkul\Security\Settings\CurrencySettings）で設定値を管理
- Spatie/laravel-settingsパッケージを使用して設定値を永続化
- 設定クラスター（Settings）配下のページとして構成
- ナビゲーションアイコン: heroicon-o-document-text
- フォームはschema()メソッドで定義（Schemaクラス使用）
