# 画面設計書 329-アクティビティ設定

## 概要

本ドキュメントは、Aureus ERPシステムのセキュリティモジュールにおける「アクティビティ設定」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、アクティビティ（活動）機能に関する説明を表示し、アクティビティタイプ管理画面への導線を提供する設定画面である。

**業務上の目的・背景**：アクティビティ機能は、タスクやフォローアップ、リマインダーなどの活動を管理するための機能である。本画面では、アクティビティ機能の概要説明を提供し、詳細なアクティビティタイプの管理画面へのリンクを提供する。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターにアクセスし、「アクティビティ」を選択することでアクセスする。

**主要な操作・処理内容**：
1. アクティビティ機能の説明表示
2. アクティビティタイプ管理画面へのリンク

**画面遷移**：設定クラスター内のページとして表示される。「アクティビティタイプを管理」リンクをクリックすると、アクティビティタイプ一覧画面へ遷移する。

**権限による表示制御**：HasPageShieldトレイトにより、本画面へのアクセス権限が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | アクティビティ設定 | 主機能 | アクティビティ機能の設定・説明 |

## 画面種別

設定

## URL/ルーティング

`/admin/settings/activity`

## 画面構成

- パンくずリスト
- 説明プレースホルダー
  - アクティビティ機能の説明テキスト
- アクション領域
  - アクティビティタイプを管理リンク

## 入出力項目

該当なし（本画面には入力フォームはない）

## 表示項目

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| アクティビティ説明 | activity_description | プレースホルダー（テキスト） | アクティビティ機能の説明 |
| アクティビティタイプ管理リンク | manageActivityTypes | リンクボタン | 外部リンクアイコン付き |

## イベント仕様

### 01-アクティビティタイプ管理リンク押下

アクティビティタイプ一覧画面（/admin/settings/activity-types）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへの書き込みを行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースアクセスなし |

## メッセージ仕様

該当なし（本画面ではメッセージ表示はない）

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |

## 備考

- 本画面はFilament PHPのSettingsPageを継承して実装されている
- HasPageShieldトレイトによりページレベルの権限制御が可能
- UserSettingsクラスを使用しているが、本画面では設定値の読み書きは行わない
- getFormActions()メソッドで空配列を返し、保存ボタンを非表示にしている
- 設定クラスター（Settings）配下のページとして構成
- ナビゲーションアイコン: heroicon-o-document-text
- Placeholder::make()とActions::make()を使用した情報提供型の設定画面
- 1カラムレイアウト（columns(1)）
