# 画面設計書 33-支払条件一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払条件一覧画面の設計仕様を定義するものです。この画面は会計モジュールの支払条件リソースの一部として、登録されている支払条件の一覧表示・管理機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払条件は、請求書や見積書において顧客・仕入先との支払いに関する取り決め（支払期限、早期支払割引など）を定義するマスタデータです。この一覧画面は、企業が使用する支払条件の全体像を把握し、新規作成・編集・削除などの管理操作を行う入り口となります。例えば「30日後支払い」「即時支払い」「2%割引/10日以内」などの支払条件を管理します。

**画面へのアクセス方法**：会計モジュールのナビゲーションから支払条件メニューを選択してアクセスします。URLパターンは `/payment-terms` です。

**主要な操作・処理内容**：
1. 支払条件の一覧表示（名称、会社、作成日、更新日）
2. 検索・ソート・グループ化によるデータ絞り込み
3. タブによる「すべて」と「アーカイブ済み」の切り替え
4. 新規作成ボタンからの支払条件作成
5. 各行からの表示・編集・削除・復元操作
6. 一括削除・一括復元・完全削除のバルクアクション

**画面遷移**：
- 遷移元：会計モジュールメニュー
- 遷移先：支払条件作成画面、支払条件詳細画面、支払条件編集画面

**権限による表示制御**：システムの権限設定に基づき、支払条件リソースへのアクセス権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-023 | 支払条件管理 | 主機能 | 支払条件の一覧表示・CRUD操作 |
| - | 支払条件作成 | 遷移先機能 | 新規作成ボタンからの遷移 |
| - | 支払条件詳細 | 遷移先機能 | 表示アクションからの遷移 |
| - | 支払条件編集 | 遷移先機能 | 編集アクションからの遷移 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/payment-terms`
- ルート名: `filament.accounts.resources.payment-terms.index`
- HTTPメソッド: GET

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払条件                                    [+ 新規作成]          |
+------------------------------------------------------------------+
| タブ                                                              |
|  [すべて (件数)] [アーカイブ済み (件数)]                           |
+------------------------------------------------------------------+
| テーブルツールバー                                                 |
|  [グループ化▼] [フィルター] [検索...]     [カラム▼] [一括操作▼]   |
+------------------------------------------------------------------+
| データテーブル                                                     |
| +--------+--------+------------+------------+--------+            |
| | □      | 支払条件 | 会社      | 作成日     | 更新日   | 操作    |
| +--------+--------+------------+------------+--------+            |
| | □      | Net 30  | 株式会社A | 2024/01/01 | 2024/12/01 | [表示][編集][...] |
| | □      | Net 60  | 株式会社A | 2024/02/15 | 2024/11/20 | [表示][編集][...] |
| | □      | 即時支払 | 株式会社B | 2024/03/10 | 2024/10/05 | [表示][編集][...] |
| +--------+--------+------------+------------+--------+            |
+------------------------------------------------------------------+
| フッター                                                          |
|  表示件数: [10▼]  1-10 of 25                  [<] [1] [2] [3] [>] |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 備考 |
|--------|--------|--------|----------|------|------|
| 検索キーワード | search | 入力 | string | - | 支払条件名で検索 |
| グループ化 | group | 入力 | enum | - | 複数のグループ化オプション |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 備考 |
|--------|--------|----------|--------|------|------|
| 支払条件 | name | string | ○ | ○ | メインカラム |
| 会社 | company.name | string | ○ | ○ | リレーション |
| 作成日 | created_at | datetime | ○ | - | デフォルト非表示 |
| 更新日 | updated_at | datetime | ○ | - | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

**トリガー**: ヘッダーの「新規作成」ボタンをクリック

**処理フロー**:
1. 支払条件作成画面への遷移
2. URLは `/payment-terms/create`

### 2-表示アクション

**トリガー**: 行の「表示」ボタンをクリック

**処理フロー**:
1. 支払条件詳細画面への遷移
2. URLは `/payment-terms/{id}`

### 3-編集アクション

**トリガー**: 行の「編集」ボタンをクリック

**処理フロー**:
1. 支払条件編集画面への遷移
2. URLは `/payment-terms/{id}/edit`

### 4-削除アクション

**トリガー**: 行の「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、ソフトデリート実行
3. 成功通知の表示
4. 一覧の再読み込み

### 5-復元アクション

**トリガー**: アーカイブ済みタブで行の「復元」ボタンをクリック

**処理フロー**:
1. ソフトデリートの解除
2. 成功通知の表示
3. 一覧の再読み込み

### 6-完全削除アクション

**トリガー**: アーカイブ済みタブで行の「完全削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、物理削除実行
3. 成功通知の表示
4. 一覧の再読み込み

### 7-タブ切り替え

**トリガー**: タブのクリック

**処理フロー**:
1. 「すべて」タブ: 通常のレコードを表示
2. 「アーカイブ済み」タブ: ソフトデリートされたレコードのみ表示（onlyTrashed）

### 8-グループ化

**トリガー**: グループ化セレクトの選択

**処理フロー**:
1. 選択したフィールドでレコードをグループ化表示
2. 各グループは折りたたみ可能

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_payment_terms | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元アクション | accounts_payment_terms | UPDATE | deleted_atをNULLに設定 |
| 完全削除アクション | accounts_payment_terms | DELETE | 物理削除 |
| 一括削除 | accounts_payment_terms | UPDATE | 複数レコードのソフトデリート |
| 一括復元 | accounts_payment_terms | UPDATE | 複数レコードの復元 |
| 一括完全削除 | accounts_payment_terms | DELETE | 複数レコードの物理削除 |

### テーブル別更新項目詳細

#### accounts_payment_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | WHERE id IN (選択ID) | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| delete.notification.title | 成功 | 支払条件が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 支払条件がアーカイブされました | 削除成功時 |
| restore.notification.title | 成功 | 支払条件が復元されました | 復元成功時 |
| restore.notification.body | 成功 | 支払条件が正常に復元されました | 復元成功時 |
| force-delete.notification.title | 成功 | 支払条件が完全に削除されました | 完全削除成功時 |
| force-delete.notification.body | 成功 | 支払条件が完全に削除されました | 完全削除成功時 |
| bulk-delete.notification.title | 成功 | 選択した支払条件が削除されました | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 選択した支払条件が復元されました | 一括復元成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの取得中にエラーが発生しました |
| 削除制約違反 | エラー通知表示 | この支払条件は使用中のため削除できません |

## 備考

- 本画面はFilament PHPのListRecordsページクラスを継承して実装されています
- SoftDeletesトレイトを使用しており、削除は論理削除（アーカイブ）として処理されます
- タブのバッジには各状態のレコード数が表示されます（PaymentTerm::count(), PaymentTerm::onlyTrashed()->count()）
- グループ化オプション：会社名、割引日数、早期支払割引、支払条件名、請求書表示、早期割引有無、割引率
- 作成日・更新日カラムはデフォルトで非表示（toggleable）ですが、ユーザーが表示切替可能です
- 新規作成ボタンには plus-circle アイコンが付いています
