# 画面設計書 330-アクティビティタイプ一覧

## 概要

本ドキュメントは、Aureus ERPシステムのサポートモジュールにおける「アクティビティタイプ一覧」画面の設計を定義するものである。

### 本画面の処理概要

本画面は、システムに登録されているアクティビティタイプ（活動種別）を一覧形式で表示・管理するための画面である。アクティビティタイプの検索、フィルタリング、ソート、グループ化機能を提供し、新規作成、編集、削除、復元といった操作を行うことができる。

**業務上の目的・背景**：アクティビティ（活動）機能において、タスク、電話、ミーティング、メールなど様々な種類の活動を分類・管理するためにアクティビティタイプを定義する必要がある。本画面により、組織の業務プロセスに合わせたアクティビティタイプをカスタマイズできる。

**画面へのアクセス方法**：アクティビティ設定画面から「アクティビティタイプを管理」リンクをクリック、または直接URLにアクセスすることでアクセスする。

**主要な操作・処理内容**：
1. アクティビティタイプ一覧の表示
2. タブ切り替えによる全件/アーカイブ済みの切り替え
3. 名前、サマリー、アクションでの検索
4. アクション、ステータス、遅延有無でのフィルタリング
5. 各種項目でのグループ化・ソート
6. アクティビティタイプの新規作成、表示、編集、削除、復元、完全削除操作
7. 一括削除・完全削除・復元操作

**画面遷移**：本画面から作成画面、詳細画面、編集画面へ遷移できる。

**権限による表示制御**：ActivityTypeResourceに対する各種権限により操作が制御される。プラグインごとにデータがフィルタリングされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | アクティビティタイプ一覧 | 主機能 | アクティビティタイプの一覧表示・検索・フィルタ |
| - | アクティビティタイプ作成 | 遷移先機能 | 新規アクティビティタイプ作成 |
| - | アクティビティタイプ編集 | 遷移先機能 | 既存アクティビティタイプ編集 |
| - | アクティビティタイプ詳細 | 遷移先機能 | アクティビティタイプ詳細表示 |

## 画面種別

一覧

## URL/ルーティング

`/admin/settings/activity-types`

## 画面構成

- ヘッダーアクション領域
  - 新規作成ボタン
- タブ領域
  - 全件タブ（件数バッジ付き）
  - アーカイブ済みタブ（件数バッジ付き）
- テーブル領域
  - カラム管理機能
  - フィルタ機能
  - グループ化機能
  - 検索機能
  - 一括アクション機能
  - 行アクション機能
  - ドラッグ&ドロップによる並び替え

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 検索キーワード | search | string | 入力 | - | 名前・サマリーで検索 |
| アクションフィルタ | category | string | 入力 | - | アクションタイプでフィルタ |
| ステータスフィルタ | is_active | boolean | 入力 | - | アクティブ/非アクティブ |
| 遅延有無フィルタ | has_delay | boolean | 入力 | - | 遅延設定の有無 |

## 表示項目

| 項目名 | カラムID | 表示形式 | 説明 |
|--------|----------|----------|------|
| 名前 | name | テキスト | アクティビティタイプ名（検索・ソート可） |
| サマリー | summary | テキスト | 概要説明（検索・ソート可） |
| 予定 | delay_count | テキスト | 遅延時間（カウント＋単位）または「No Delay」 |
| タイプ | delay_from | テキスト | 遅延の起点（検索・ソート可） |
| アクション | category | バッジ | アクションカテゴリ（検索・ソート可） |
| ステータス | is_active | アイコン（真偽値） | アクティブ状態 |
| 作成日時 | created_at | 日付 | 作成日（デフォルト非表示） |
| 更新日時 | updated_at | 日付 | 更新日（デフォルト非表示） |

## イベント仕様

### 01-新規作成ボタン押下

新規作成ボタンをクリックすると、アクティビティタイプ作成画面（/admin/settings/activity-types/create）へ遷移する。

### 02-行アクション（表示）

表示アクションをクリックすると、該当アクティビティタイプの詳細画面（/admin/settings/activity-types/{record}）へ遷移する。

### 03-行アクション（編集）

編集アクションをクリックすると、該当アクティビティタイプの編集画面（/admin/settings/activity-types/{record}/edit）へ遷移する。

### 04-行アクション（削除）

削除アクションをクリックすると、アクティビティタイプを論理削除する。成功通知が表示される。

### 05-行アクション（復元）

アーカイブ済みタブでのみ表示。復元アクションをクリックすると、論理削除されたアクティビティタイプを復元する。

### 06-行アクション（完全削除）

アーカイブ済みタブでのみ表示。完全削除アクションをクリックすると、アクティビティタイプを物理削除する。削除に失敗した場合（外部キー制約違反など）はエラー通知が表示される。

### 07-一括削除

チェックボックスで選択したアクティビティタイプを一括で論理削除する。

### 08-一括完全削除

チェックボックスで選択したアクティビティタイプを一括で物理削除する。

### 09-一括復元

チェックボックスで選択した論理削除済みアクティビティタイプを一括で復元する。

### 10-並び替え

ドラッグ&ドロップによりアクティビティタイプの表示順序（sort列）を変更する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | activity_types | SELECT | アクティビティタイプ一覧の取得 |
| 削除 | activity_types | UPDATE | deleted_atへの日時設定（論理削除） |
| 完全削除 | activity_types | DELETE | レコードの物理削除 |
| 復元 | activity_types | UPDATE | deleted_atのNULL設定 |
| 並び替え | activity_types | UPDATE | sort列の更新 |

### テーブル別更新項目詳細

#### activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | plugin = 'support' | プラグインでフィルタ |
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除 |
| UPDATE（復元） | deleted_at | NULL | 復元 |
| DELETE | - | IDで指定されたレコード | 物理削除 |
| UPDATE（並び替え） | sort | 新しい順序値 | ドラッグ&ドロップ時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification | 成功 | アクティビティタイプが削除されました | 削除成功時 |
| restore.notification | 成功 | アクティビティタイプが復元されました | 復元成功時 |
| force-delete.notification.success | 成功 | アクティビティタイプが完全に削除されました | 完全削除成功時 |
| force-delete.notification.error | エラー | 削除に失敗しました | 完全削除失敗時（外部キー制約違反等） |
| bulk-delete.notification | 成功 | アクティビティタイプが一括削除されました | 一括削除成功時 |
| bulk-restore.notification | 成功 | アクティビティタイプが一括復元されました | 一括復元成功時 |
| bulk-force-delete.notification | 成功 | アクティビティタイプが一括で完全削除されました | 一括完全削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | アクセス拒否画面へリダイレクト |
| 完全削除時の外部キー制約違反 | エラー通知表示（QueryException捕捉） |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されている
- ActivityTypeResourceで定義されたテーブル構成を使用
- プラグイン名（$pluginName = 'support'）でデータがフィルタリングされる
- 各モジュール（sales, purchasesなど）で同じActivityTypeResourceを継承し、$pluginNameを変更することで、モジュール固有のアクティビティタイプを管理可能
- ActivityTypeモデルはSoftDeletesとSortableTraitを使用
- ナビゲーションには登録されていない（$shouldRegisterNavigation = false）
- カラム管理で2カラム表示（columnManagerColumns(2)）
