# 画面設計書 331-アクティビティタイプ作成

## 概要

本ドキュメントは、サポートモジュールにおけるアクティビティタイプの新規作成画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：アクティビティタイプは、サポート業務において行われる各種活動（電話連絡、メール送信、会議など）を分類・管理するためのマスタデータです。本画面は、新しいアクティビティタイプを定義し、そのタイプに関連する遅延設定、連鎖設定、表示装飾などの詳細情報を登録することを目的としています。これにより、組織内のサポート活動を標準化し、効率的なワークフロー管理を実現します。

**画面へのアクセス方法**：設定メニューから「アクティビティタイプ」を選択し、一覧画面で「作成」ボタンをクリックすることでアクセスできます。URLパス: `/settings/activity-types/create`

**主要な操作・処理内容**：
1. アクティビティタイプ名、アクション種別、デフォルトユーザー、サマリー、デフォルトノートを入力
2. 遅延情報（遅延カウント、遅延単位、遅延起点）を設定
3. 詳細設定（アイコン、装飾タイプ、連鎖タイプ）を選択
4. 提案/トリガーするアクティビティタイプを指定（連鎖タイプに応じて）
5. ステータス（有効/無効）、完了済み保持フラグを設定
6. 「作成」ボタンで新規アクティビティタイプを保存

**画面遷移**：アクティビティタイプ一覧画面から遷移し、作成完了後はアクティビティタイプ詳細画面へリダイレクトされます。

**権限による表示制御**：サポートモジュールの管理権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SUP-001 | 活動タイプ管理 | 主機能 | 新規アクティビティタイプの作成 |
| FN-SUP-002 | ユーザー選択 | 補助機能 | デフォルトユーザーの選択 |
| FN-SUP-003 | アクティビティタイプ関連 | 補助機能 | 提案/トリガーするアクティビティタイプの選択 |

## 画面種別

登録画面

## URL/ルーティング

`/settings/activity-types/create`

## 画面構成

- ヘッダーセクション: ページタイトル「アクティビティタイプ作成」
- メインコンテンツ（3カラムレイアウト）
  - 左側（2カラム幅）
    - アクティビティタイプ詳細セクション
    - 遅延情報セクション
  - 右側（1カラム幅）
    - 詳細設定セクション
    - ステータス・設定セクション
- フッター: 作成ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 最大桁数 | デフォルト値 | バリデーション |
|--------|--------|----------|------|----------|----------|--------------|----------------|
| 名前 | name | string | ○ | テキスト | 255 | - | 必須、最大255文字 |
| アクション | category | string | - | セレクト | - | - | ActivityTypeAction Enum値 |
| デフォルトユーザー | default_user_id | integer | - | セレクト | - | - | usersテーブルに存在するID |
| サマリー | summary | text | - | テキストエリア | - | - | - |
| デフォルトノート | default_note | text | - | リッチエディタ | - | - | - |
| 遅延カウント | delay_count | integer | ○ | 数値 | 9 | 0 | 必須、0以上999999999以下 |
| 遅延単位 | delay_unit | string | ○ | セレクト | - | minutes | ActivityDelayUnit Enum値 |
| 遅延起点 | delay_from | string | ○ | セレクト | - | previous_activity | ActivityDelayFrom Enum値 |
| アイコン | icon | string | - | アイコンピッカー | - | - | heroicons, fontawesome-solid |
| 装飾タイプ | decoration_type | string | - | セレクト | - | - | ActivityDecorationType Enum値 |
| 連鎖タイプ | chaining_type | string | ○ | セレクト | - | suggest | ActivityChainingType Enum値 |
| 提案アクティビティタイプ | activity_type_suggestions | array | - | 複数選択 | - | - | activity_typesテーブルに存在するID |
| トリガー次タイプ | triggered_next_type_id | integer | - | セレクト | - | - | activity_typesテーブルに存在するID |
| ステータス | is_active | boolean | - | トグル | - | false | - |
| 完了済み保持 | keep_done | boolean | - | トグル | - | false | - |

## 表示項目

該当なし（登録画面のため）

## イベント仕様

### 1-作成ボタン押下

フォーム入力内容のバリデーションを実行し、成功時にactivity_typesテーブルへINSERTを実行します。plugin項目には自動的に'support'が設定されます。作成成功後、作成されたレコードの詳細画面へリダイレクトされます。

### 2-連鎖タイプ変更

連鎖タイプ（chaining_type）の値に応じて、表示される入力フィールドが動的に変更されます：
- 'suggest'選択時: 「提案アクティビティタイプ」フィールドが表示
- 'trigger'選択時: 「トリガー次タイプ」フィールドが表示
- カテゴリが'upload_file'の場合: 連鎖タイプフィールド自体が非表示

### 3-アクション種別変更

アクション種別（category）が'upload_file'に変更された場合、連鎖タイプフィールドと提案アクティビティタイプフィールドが非表示になります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | activity_types | INSERT | 新規アクティビティタイプの登録 |
| 作成ボタン押下 | activity_type_suggestions | INSERT | 提案アクティビティタイプ関連の登録（選択時のみ） |

### テーブル別更新項目詳細

#### activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | category | フォーム選択値 | アクション種別 |
| INSERT | default_user_id | フォーム選択値 | ユーザーID |
| INSERT | summary | フォーム入力値 | - |
| INSERT | default_note | フォーム入力値 | HTML形式 |
| INSERT | delay_count | フォーム入力値 | デフォルト0 |
| INSERT | delay_unit | フォーム選択値 | デフォルトminutes |
| INSERT | delay_from | フォーム選択値 | デフォルトprevious_activity |
| INSERT | icon | フォーム選択値 | アイコン名 |
| INSERT | decoration_type | フォーム選択値 | - |
| INSERT | chaining_type | フォーム選択値 | デフォルトsuggest |
| INSERT | triggered_next_type_id | フォーム選択値 | - |
| INSERT | is_active | フォーム選択値 | デフォルトfalse |
| INSERT | keep_done | フォーム選択値 | デフォルトfalse |
| INSERT | plugin | 'support' | システム自動設定 |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### activity_type_suggestions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | activity_type_id | 作成されたアクティビティタイプID | - |
| INSERT | suggested_activity_type_id | 選択された提案アクティビティタイプID | 複数レコード |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| notification.title | 成功 | アクティビティタイプが正常に作成されました | 作成成功時 |
| notification.body | 成功 | アクティビティタイプの作成が完了しました | 作成成功時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.max | エラー | 最大{max}文字までです | 最大文字数超過時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| 必須項目未入力 | フォームバリデーションエラー表示 | 該当項目に必須エラー表示 |
| データベース登録失敗 | トランザクションロールバック | システムエラー通知 |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装されています
- アイコン選択にはGuava IconPickerコンポーネントを使用しています
- plugin項目は自動的に'support'が設定され、プラグイン間でのデータ分離に使用されます
