# 画面設計書 332-アクティビティタイプ編集

## 概要

本ドキュメントは、サポートモジュールにおけるアクティビティタイプの編集画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：アクティビティタイプは、サポート業務において行われる各種活動を分類・管理するためのマスタデータです。本画面は、既存のアクティビティタイプの設定内容を変更・更新することを目的としています。業務要件の変更や運用改善に伴い、遅延設定や連鎖設定などを柔軟に変更できることで、組織のサポートワークフローを最適化できます。

**画面へのアクセス方法**：アクティビティタイプ一覧画面または詳細画面から「編集」アクションをクリックすることでアクセスできます。URLパス: `/settings/activity-types/{record}/edit`

**主要な操作・処理内容**：
1. 既存のアクティビティタイプ情報を読み込み、フォームに表示
2. アクティビティタイプ名、アクション種別、デフォルトユーザー、サマリー、デフォルトノートを編集
3. 遅延情報（遅延カウント、遅延単位、遅延起点）を変更
4. 詳細設定（アイコン、装飾タイプ、連鎖タイプ）を変更
5. 提案/トリガーするアクティビティタイプを更新
6. 「保存」ボタンで変更内容を更新

**画面遷移**：アクティビティタイプ一覧画面または詳細画面から遷移し、保存完了後はアクティビティタイプ詳細画面へリダイレクトされます。ヘッダーアクションから詳細表示画面への遷移、削除処理も可能です。

**権限による表示制御**：サポートモジュールの管理権限を持つユーザーのみがアクセス可能です。削除アクションは削除権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SUP-001 | 活動タイプ管理 | 主機能 | アクティビティタイプの編集・更新 |
| FN-SUP-002 | ユーザー選択 | 補助機能 | デフォルトユーザーの選択 |
| FN-SUP-003 | アクティビティタイプ関連 | 補助機能 | 提案/トリガーするアクティビティタイプの選択 |
| FN-SUP-004 | 削除機能 | 遷移先機能 | アクティビティタイプの削除 |

## 画面種別

編集画面

## URL/ルーティング

`/settings/activity-types/{record}/edit`

## 画面構成

- ヘッダーセクション
  - ページタイトル「アクティビティタイプ編集」
  - ヘッダーアクション: 詳細表示ボタン、削除ボタン
- メインコンテンツ（3カラムレイアウト）
  - 左側（2カラム幅）
    - アクティビティタイプ詳細セクション
    - 遅延情報セクション
  - 右側（1カラム幅）
    - 詳細設定セクション
    - ステータス・設定セクション
- フッター: 保存ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 最大桁数 | デフォルト値 | バリデーション |
|--------|--------|----------|------|----------|----------|--------------|----------------|
| 名前 | name | string | ○ | テキスト | 255 | 既存値 | 必須、最大255文字 |
| アクション | category | string | - | セレクト | - | 既存値 | ActivityTypeAction Enum値 |
| デフォルトユーザー | default_user_id | integer | - | セレクト | - | 既存値 | usersテーブルに存在するID |
| サマリー | summary | text | - | テキストエリア | - | 既存値 | - |
| デフォルトノート | default_note | text | - | リッチエディタ | - | 既存値 | - |
| 遅延カウント | delay_count | integer | ○ | 数値 | 9 | 既存値 | 必須、0以上999999999以下 |
| 遅延単位 | delay_unit | string | ○ | セレクト | - | 既存値 | ActivityDelayUnit Enum値 |
| 遅延起点 | delay_from | string | ○ | セレクト | - | 既存値 | ActivityDelayFrom Enum値 |
| アイコン | icon | string | - | アイコンピッカー | - | 既存値 | heroicons, fontawesome-solid |
| 装飾タイプ | decoration_type | string | - | セレクト | - | 既存値 | ActivityDecorationType Enum値 |
| 連鎖タイプ | chaining_type | string | ○ | セレクト | - | 既存値 | ActivityChainingType Enum値 |
| 提案アクティビティタイプ | activity_type_suggestions | array | - | 複数選択 | - | 既存値 | activity_typesテーブルに存在するID |
| トリガー次タイプ | triggered_next_type_id | integer | - | セレクト | - | 既存値 | activity_typesテーブルに存在するID |
| ステータス | is_active | boolean | - | トグル | - | 既存値 | - |
| 完了済み保持 | keep_done | boolean | - | トグル | - | 既存値 | - |

## 表示項目

該当なし（編集画面のため、入力項目と同一）

## イベント仕様

### 1-保存ボタン押下

フォーム入力内容のバリデーションを実行し、成功時にactivity_typesテーブルへUPDATEを実行します。plugin項目には自動的に'support'が再設定されます。保存成功後、詳細画面へリダイレクトされます。

### 2-詳細表示ボタン押下

ヘッダーアクションの「詳細表示」ボタンをクリックすると、現在編集中のアクティビティタイプの詳細画面へ遷移します。

### 3-削除ボタン押下

ヘッダーアクションの「削除」ボタンをクリックすると、確認ダイアログが表示されます。確認後、該当レコードを論理削除（SoftDelete）し、成功通知を表示します。

### 4-連鎖タイプ変更

連鎖タイプ（chaining_type）の値に応じて、表示される入力フィールドが動的に変更されます（作成画面と同様）。

### 5-アクション種別変更

アクション種別（category）が'upload_file'に変更された場合、連鎖タイプフィールドと提案アクティビティタイプフィールドが非表示になります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | activity_types | UPDATE | アクティビティタイプの更新 |
| 保存ボタン押下 | activity_type_suggestions | DELETE/INSERT | 提案アクティビティタイプ関連の更新 |
| 削除ボタン押下 | activity_types | UPDATE | 論理削除（deleted_at設定） |

### テーブル別更新項目詳細

#### activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | category | フォーム選択値 | アクション種別 |
| UPDATE | default_user_id | フォーム選択値 | ユーザーID |
| UPDATE | summary | フォーム入力値 | - |
| UPDATE | default_note | フォーム入力値 | HTML形式 |
| UPDATE | delay_count | フォーム入力値 | - |
| UPDATE | delay_unit | フォーム選択値 | - |
| UPDATE | delay_from | フォーム選択値 | - |
| UPDATE | icon | フォーム選択値 | アイコン名 |
| UPDATE | decoration_type | フォーム選択値 | - |
| UPDATE | chaining_type | フォーム選択値 | - |
| UPDATE | triggered_next_type_id | フォーム選択値 | - |
| UPDATE | is_active | フォーム選択値 | - |
| UPDATE | keep_done | フォーム選択値 | - |
| UPDATE | plugin | 'support' | システム自動設定 |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE(削除時) | deleted_at | 現在日時 | SoftDelete |

#### activity_type_suggestions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | activity_type_id | 編集対象のID | 既存関連を削除 |
| INSERT | activity_type_id | 編集対象のID | 新規関連を登録 |
| INSERT | suggested_activity_type_id | 選択された提案アクティビティタイプID | 複数レコード |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| notification.title | 成功 | アクティビティタイプが正常に更新されました | 保存成功時 |
| notification.body | 成功 | アクティビティタイプの更新が完了しました | 保存成功時 |
| header-actions.delete.notification.title | 成功 | アクティビティタイプが削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | アクティビティタイプの削除が完了しました | 削除成功時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.max | エラー | 最大{max}文字までです | 最大文字数超過時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| レコードが存在しない | 404エラーページ表示 | レコードが見つかりません |
| 必須項目未入力 | フォームバリデーションエラー表示 | 該当項目に必須エラー表示 |
| データベース更新失敗 | トランザクションロールバック | システムエラー通知 |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 削除済みレコードへのアクセス | 404エラーページ表示 | レコードが見つかりません |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装されています
- ヘッダーアクションにViewActionとDeleteActionが配置されています
- 削除はSoftDelete（論理削除）で実装されており、復元が可能です
- plugin項目は保存時に自動的に'support'が設定され、プラグイン間でのデータ分離に使用されます
