# 画面設計書 333-アクティビティタイプ詳細

## 概要

本ドキュメントは、サポートモジュールにおけるアクティビティタイプの詳細表示画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：アクティビティタイプは、サポート業務において行われる各種活動を分類・管理するためのマスタデータです。本画面は、登録されたアクティビティタイプの詳細情報を閲覧することを目的としています。管理者やサポートスタッフが各アクティビティタイプの設定内容（遅延設定、連鎖設定、ステータスなど）を確認し、業務運用の参考にすることができます。

**画面へのアクセス方法**：アクティビティタイプ一覧画面から対象レコードをクリック、または一覧画面のアクションメニューから「詳細表示」を選択することでアクセスできます。URLパス: `/settings/activity-types/{record}`

**主要な操作・処理内容**：
1. 選択されたアクティビティタイプの詳細情報を読み取り専用で表示
2. アクティビティタイプの基本情報（名前、アクション、デフォルトユーザー、プラグイン）を確認
3. 遅延情報（遅延カウント、遅延単位、遅延起点）を確認
4. 詳細設定（アイコン、装飾タイプ、連鎖タイプ、提案/トリガータイプ）を確認
5. ステータス情報（有効/無効、完了済み保持）を確認

**画面遷移**：アクティビティタイプ一覧画面から遷移します。ヘッダーアクションから編集画面への遷移、削除処理も可能です。

**権限による表示制御**：サポートモジュールの閲覧権限を持つユーザーがアクセス可能です。編集・削除アクションは該当権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SUP-001 | 活動タイプ管理 | 主機能 | アクティビティタイプの詳細表示 |
| FN-SUP-004 | 編集機能 | 遷移先機能 | アクティビティタイプの編集画面への遷移 |
| FN-SUP-005 | 削除機能 | 遷移先機能 | アクティビティタイプの削除 |

## 画面種別

詳細画面

## URL/ルーティング

`/settings/activity-types/{record}`

## 画面構成

- ヘッダーセクション
  - ページタイトル（レコード名）
  - ヘッダーアクション: 編集ボタン、削除ボタン
- メインコンテンツ（3カラムレイアウト）
  - 左側（2カラム幅）
    - アクティビティタイプ詳細セクション
    - サマリー・ノートセクション
    - 遅延情報セクション
  - 右側（1カラム幅）
    - 詳細設定セクション
    - ステータス・設定セクション

## 入出力項目

該当なし（詳細表示画面のため入力なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| 名前 | name | string | テキスト | heroicon-o-clipboard-document-list |
| アクション | category | string | ラベル（Enum表示） | heroicon-o-tag |
| デフォルトユーザー | defaultUser.name | string | テキスト | heroicon-o-user |
| プラグイン | plugin | string | テキスト | heroicon-o-puzzle-piece |
| サマリー | summary | text | テキスト | - |
| デフォルトノート | default_note | text | HTML | - |
| 遅延カウント | delay_count | integer | 数値 | heroicon-o-clock |
| 遅延単位 | delay_unit | string | ラベル（Enum表示） | heroicon-o-calendar |
| 遅延起点 | delay_from | string | ラベル（Enum表示） | heroicon-o-arrow-right |
| アイコン | icon | string | アイコン表示 | 設定されたアイコン |
| 装飾タイプ | decoration_type | string | ラベル（Enum表示） | heroicon-o-paint-brush |
| 連鎖タイプ | chaining_type | string | ラベル（Enum表示） | heroicon-o-link |
| 提案アクティビティタイプ | suggestedActivityTypes.name | array | リスト表示（改行区切り） | heroicon-o-list-bullet |
| トリガー次タイプ | triggeredNextType.name | string | テキスト | heroicon-o-forward |
| ステータス | is_active | boolean | アイコン（○/×） | - |
| 完了済み保持 | keep_done | boolean | アイコン（○/×） | - |

## イベント仕様

### 1-編集ボタン押下

ヘッダーアクションの「編集」ボタンをクリックすると、現在表示中のアクティビティタイプの編集画面へ遷移します。

### 2-削除ボタン押下

ヘッダーアクションの「削除」ボタンをクリックすると、確認ダイアログが表示されます。確認後、該当レコードを論理削除（SoftDelete）し、成功通知を表示してから一覧画面へリダイレクトします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | activity_types | SELECT | アクティビティタイプ情報の取得 |
| 画面表示 | users | SELECT | デフォルトユーザー情報の取得 |
| 画面表示 | activity_type_suggestions | SELECT | 提案アクティビティタイプの取得 |
| 削除ボタン押下 | activity_types | UPDATE | 論理削除（deleted_at設定） |

### テーブル別更新項目詳細

#### activity_types（参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URLパラメータのrecord | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | category | - | Enum変換して表示 |
| SELECT | default_user_id | - | リレーション取得 |
| SELECT | summary | - | 表示用 |
| SELECT | default_note | - | HTML表示 |
| SELECT | delay_count | - | 数値表示 |
| SELECT | delay_unit | - | Enum変換して表示 |
| SELECT | delay_from | - | Enum変換して表示 |
| SELECT | icon | - | アイコン表示 |
| SELECT | decoration_type | - | Enum変換して表示 |
| SELECT | chaining_type | - | Enum変換して表示 |
| SELECT | triggered_next_type_id | - | リレーション取得 |
| SELECT | is_active | - | アイコン表示 |
| SELECT | keep_done | - | アイコン表示 |
| SELECT | plugin | - | 表示用 |
| UPDATE(削除時) | deleted_at | 現在日時 | SoftDelete |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| header-actions.delete.notification.title | 成功 | アクティビティタイプが削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | アクティビティタイプの削除が完了しました | 削除成功時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| レコードが存在しない | 404エラーページ表示 | レコードが見つかりません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 削除済みレコードへのアクセス | 404エラーページ表示 | レコードが見つかりません |
| リレーション先レコードが存在しない | プレースホルダー「—」を表示 | - |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装されています
- ヘッダーアクションにEditActionとDeleteActionが配置されています
- 各表示項目には適切なアイコンが設定されており、視認性が向上しています
- 値が未設定の項目はプレースホルダー「—」が表示されます
- Enum値は自動的に人間が読みやすいラベルに変換されて表示されます
- 提案アクティビティタイプは改行区切りのリスト形式で表示されます
