# 画面設計書 334-マイ休暇一覧

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇申請一覧画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：従業員が自分自身の休暇申請状況を確認・管理するための画面です。有給休暇、病欠、その他の休暇タイプに対する申請履歴を一元管理し、申請ステータス（申請中、承認済み、却下など）を確認できます。これにより、従業員は自身の休暇取得状況を把握し、計画的な休暇管理を行うことができます。

**画面へのアクセス方法**：メインナビゲーションから「休暇」モジュール → 「マイ休暇」クラスターの「マイ休暇」メニューをクリックすることでアクセスできます。URLパス: `/my-time/my-time-offs`

**主要な操作・処理内容**：
1. 自分の休暇申請一覧をテーブル形式で表示
2. 従業員名、休暇タイプ、説明、日付、期間、ステータスで検索・ソート
3. グループ化機能（従業員名、休暇タイプ、ステータス、開始日、終了日）
4. 新規休暇申請の作成
5. 個別レコードの詳細表示・編集・削除
6. 承認・却下アクション（管理者権限時）
7. 一括削除

**画面遷移**：新規作成ボタンから作成画面へ、一覧のレコードクリックまたはアクションから詳細画面・編集画面へ遷移します。

**権限による表示制御**：ログインユーザー自身の休暇申請のみが表示されます。承認・却下アクションは適切な権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-009 | 自分の休暇申請 | 主機能 | 休暇申請一覧の表示・検索・フィルタ |
| FN-TOFF-002 | 休暇申請作成 | 遷移先機能 | 新規休暇申請の作成 |
| FN-TOFF-003 | 休暇申請編集 | 遷移先機能 | 休暇申請の編集 |
| FN-TOFF-004 | 休暇申請表示 | 遷移先機能 | 休暇申請の詳細表示 |

## 画面種別

一覧画面

## URL/ルーティング

`/my-time/my-time-offs`

## 画面構成

- ヘッダーセクション
  - ページタイトル「マイ休暇」
  - ヘッダーアクション: 作成ボタン（+アイコン付き）
- フィルター・検索バー
- グループ化オプション
- テーブル（データ一覧）
- ページネーション
- 一括アクションツールバー

## 入出力項目

該当なし（一覧画面のため入力なし、検索・フィルタは標準機能）

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 |
|--------|--------|----------|----------|--------|------|
| 従業員名 | employee.name | string | テキスト | ○ | ○ |
| 休暇タイプ | holidayStatus.name | string | テキスト | ○ | ○ |
| 説明 | private_name | string | テキスト | ○ | ○ |
| 開始日 | date_from | date | 日付 | ○ | ○ |
| 終了日 | date_to | date | 日付 | ○ | ○ |
| 期間 | duration_display | string | テキスト | ○ | ○ |
| ステータス | state | enum | バッジ | ○ | ○ |

## イベント仕様

### 1-作成ボタン押下

ヘッダーの「作成」ボタンをクリックすると、新規休暇申請作成画面へ遷移します。

### 2-レコード行クリック

一覧のレコード行をクリックすると、該当休暇申請の詳細画面へ遷移します。

### 3-アクションメニュー

各レコードのアクションメニューから以下の操作が可能です：
- **承認**: ステータスを「承認済み」に更新（ステータスが「承認済み」以外の場合に表示）
- **却下**: ステータスを「却下」に更新（ステータスが「却下」以外の場合に表示）
- **詳細表示**: 詳細画面へ遷移
- **編集**: 編集画面へ遷移
- **削除**: 確認後、レコードを削除

### 4-一括削除

チェックボックスで選択した複数レコードを一括で削除します。

### 5-グループ化

テーブルのグループ化オプションから以下の項目でグループ化が可能です：
- 従業員名
- 休暇タイプ
- ステータス
- 開始日
- 終了日

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | time_off_leaves | SELECT | 自分の休暇申請一覧を取得 |
| 画面表示 | employees | SELECT | 従業員情報を取得（リレーション） |
| 画面表示 | time_off_leave_types | SELECT | 休暇タイプ情報を取得（リレーション） |
| 承認アクション | time_off_leaves | UPDATE | ステータスを「承認済み」に更新 |
| 却下アクション | time_off_leaves | UPDATE | ステータスを「却下」に更新 |
| 削除アクション | time_off_leaves | DELETE | 休暇申請レコードを削除 |
| 一括削除 | time_off_leaves | DELETE | 複数の休暇申請レコードを削除 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | employee_id = ログインユーザーの従業員ID | 自分のデータのみ取得 |
| UPDATE(承認時) | state | 'validate_two' | State::VALIDATE_TWO |
| UPDATE(却下時) | state | 'refuse' | State::REFUSE |
| DELETE | id | 選択されたレコードID | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| table.actions.approve.notification.title | 成功 | 休暇申請が承認されました | 承認成功時 |
| table.actions.approve.notification.body | 成功 | 休暇申請の承認が完了しました | 承認成功時 |
| table.actions.refused.notification.title | 成功 | 休暇申請が却下されました | 却下成功時 |
| table.actions.refused.notification.body | 成功 | 休暇申請の却下が完了しました | 却下成功時 |
| table.actions.delete.notification.title | 成功 | 休暇申請が削除されました | 削除成功時 |
| table.actions.delete.notification.body | 成功 | 休暇申請の削除が完了しました | 削除成功時 |
| table.bulk-actions.delete.notification.title | 成功 | 選択した休暇申請が削除されました | 一括削除成功時 |
| table.bulk-actions.delete.notification.body | 成功 | 選択した休暇申請の削除が完了しました | 一括削除成功時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| データが存在しない | 空の一覧を表示 | データがありません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 従業員情報未登録 | 空の一覧を表示 | 従業員情報が登録されていません |
| データベースエラー | エラー通知を表示 | システムエラーが発生しました |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装されています
- テーブル定義はTimeOffResourceから継承されています
- クエリは自動的にログインユーザーの従業員IDでフィルタリングされます
- ステータスはState Enumで管理され、バッジ形式で色分け表示されます
- 承認・却下アクションは現在のステータスに応じて表示/非表示が制御されます
- MyTimeクラスターに属しており、サブナビゲーションが表示されます
